/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.range;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.reads.range.RangeCommandIterator;
import org.apache.cassandra.service.reads.range.ReplicaPlanIterator;
import org.apache.cassandra.service.reads.range.ReplicaPlanMerger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.assertj.core.util.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeCommands {
    private static final Logger logger = LoggerFactory.getLogger(RangeCommandIterator.class);
    private static final double CONCURRENT_SUBREQUESTS_MARGIN = 0.1;
    private static final int MAX_CONCURRENT_RANGE_REQUESTS = Math.max(1, Integer.getInteger("cassandra.max_concurrent_range_requests", FBUtilities.getAvailableProcessors() * 10));

    public static PartitionIterator partitions(PartitionRangeReadCommand command, ConsistencyLevel consistencyLevel, long queryStartNanoTime) {
        RangeCommandIterator rangeCommands = RangeCommands.rangeCommandIterator(command, consistencyLevel, queryStartNanoTime);
        return command.limits().filter(command.postReconciliationProcessing(rangeCommands), command.nowInSec(), command.selectsFullPartition(), command.metadata().enforceStrictLiveness());
    }

    @VisibleForTesting
    static RangeCommandIterator rangeCommandIterator(PartitionRangeReadCommand command, ConsistencyLevel consistencyLevel, long queryStartNanoTime) {
        Tracing.trace("Computing ranges to query");
        Keyspace keyspace = Keyspace.open(command.metadata().keyspace);
        ReplicaPlanIterator replicaPlans = new ReplicaPlanIterator(command.dataRange().keyRange(), keyspace, consistencyLevel);
        float resultsPerRange = RangeCommands.estimateResultsPerRange(command, keyspace);
        resultsPerRange = (float)((double)resultsPerRange - (double)resultsPerRange * 0.1);
        int maxConcurrencyFactor = Math.min(replicaPlans.size(), MAX_CONCURRENT_RANGE_REQUESTS);
        int concurrencyFactor = (double)resultsPerRange == 0.0 ? 1 : Math.max(1, Math.min(maxConcurrencyFactor, (int)Math.ceil((float)command.limits().count() / resultsPerRange)));
        logger.trace("Estimated result rows per range: {}; requested rows: {}, ranges.size(): {}; concurrent range requests: {}", new Object[]{Float.valueOf(resultsPerRange), command.limits().count(), replicaPlans.size(), concurrencyFactor});
        Tracing.trace("Submitting range requests on {} ranges with a concurrency of {} ({} rows per range expected)", replicaPlans.size(), concurrencyFactor, Float.valueOf(resultsPerRange));
        ReplicaPlanMerger mergedReplicaPlans = new ReplicaPlanMerger(replicaPlans, keyspace, consistencyLevel);
        return new RangeCommandIterator(mergedReplicaPlans, command, concurrencyFactor, maxConcurrencyFactor, replicaPlans.size(), queryStartNanoTime);
    }

    @VisibleForTesting
    static float estimateResultsPerRange(PartitionRangeReadCommand command, Keyspace keyspace) {
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(command.metadata().id);
        Index index = command.getIndex(cfs);
        float maxExpectedResults = index == null ? command.limits().estimateTotalResults(cfs) : (float)index.getEstimatedResultRows();
        return maxExpectedResults / (float)DatabaseDescriptor.getNumTokens() / (float)keyspace.getReplicationStrategy().getReplicationFactor().allReplicas;
    }

    public static boolean sufficientLiveNodesForSelectStar(TableMetadata metadata, ConsistencyLevel consistency) {
        try {
            Keyspace keyspace = Keyspace.open(metadata.keyspace);
            ReplicaPlanIterator rangeIterator = new ReplicaPlanIterator(DataRange.allData(metadata.partitioner).keyRange(), keyspace, consistency);
            rangeIterator.forEachRemaining(r -> ReplicaPlans.forRangeRead(keyspace, consistency, r.range(), -1));
            return true;
        }
        catch (UnavailableException e) {
            return false;
        }
    }
}

