/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.locator.SeedProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSeedProvider.class);
    private final List<InetAddress> seeds;

    public SimpleSeedProvider(Map<String, String> args) {
        String[] hosts = args.get("seeds").split(",", -1);
        this.seeds = new ArrayList<InetAddress>(hosts.length);
        for (String host : hosts) {
            try {
                this.seeds.add(InetAddress.getByName(host.trim()));
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host " + host);
            }
        }
    }

    @Override
    public List<InetAddress> getSeeds() {
        return Collections.unmodifiableList(this.seeds);
    }

    public void addSeed(InetAddress addr) {
        if (!this.seeds.contains(addr)) {
            this.seeds.add(addr);
        }
    }
}

