/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCache;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSavingCache<K extends CacheKey, V>
extends InstrumentingCache<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(AutoSavingCache.class);
    public static final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    protected volatile ScheduledFuture<?> saveTask;
    protected final CacheService.CacheType cacheType;

    public AutoSavingCache(ICache<K, V> cache, CacheService.CacheType cacheType) {
        super(cache);
        this.cacheType = cacheType;
    }

    public File getCachePath(String ksName, String cfName) {
        return DatabaseDescriptor.getSerializedCachePath(ksName, cfName, this.cacheType);
    }

    public Writer getWriter(int keysToSave) {
        return new Writer(keysToSave);
    }

    public void scheduleSaving(int savePeriodInSeconds, final int keysToSave) {
        if (this.saveTask != null) {
            this.saveTask.cancel(false);
            this.saveTask = null;
        }
        if (savePeriodInSeconds > 0) {
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                public void runMayThrow() {
                    AutoSavingCache.this.submitWrite(keysToSave);
                }
            };
            this.saveTask = StorageService.optionalTasks.scheduleWithFixedDelay(runnable, savePeriodInSeconds, savePeriodInSeconds, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DecoratedKey> readSaved(String ksName, String cfName) {
        File path = this.getCachePath(ksName, cfName);
        TreeSet<DecoratedKey> keys = new TreeSet<DecoratedKey>();
        if (path.exists()) {
            DataInputStream in = null;
            try {
                long start = System.currentTimeMillis();
                logger.info(String.format("reading saved cache %s", path));
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(path)));
                while (in.available() > 0) {
                    DecoratedKey key;
                    int size = in.readInt();
                    byte[] bytes = new byte[size];
                    in.readFully(bytes);
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    try {
                        key = StorageService.getPartitioner().decorateKey(buffer);
                    }
                    catch (Exception e) {
                        logger.info(String.format("unable to read entry #%s from saved cache %s; skipping remaining entries", keys.size(), path.getAbsolutePath()), (Throwable)e);
                        break;
                    }
                    keys.add(key);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("completed reading (%d ms; %d keys) saved cache %s", System.currentTimeMillis() - start, keys.size(), path));
                }
                FileUtils.closeQuietly(in);
            }
            catch (Exception e) {
                logger.warn(String.format("error reading saved cache %s", path.getAbsolutePath()), (Throwable)e);
            }
            finally {
                FileUtils.closeQuietly(in);
            }
        }
        return keys;
    }

    public Future<?> submitWrite(int keysToSave) {
        return CompactionManager.instance.submitCacheWrite(this.getWriter(keysToSave));
    }

    public void reduceCacheSize() {
        if (this.getCapacity() > 0L) {
            int newCapacity = (int)(DatabaseDescriptor.getReduceCacheCapacityTo() * (double)this.weightedSize());
            logger.warn(String.format("Reducing %s capacity from %d to %s to reduce memory pressure", new Object[]{this.cacheType, this.getCapacity(), newCapacity}));
            this.setCapacity(newCapacity);
        }
    }

    public int estimateSizeToSave(Set<K> keys) {
        int bytes = 0;
        for (CacheKey key : keys) {
            bytes += key.serializedSize();
        }
        return bytes;
    }

    public class Writer
    extends CompactionInfo.Holder {
        private final Set<K> keys;
        private final CompactionInfo info;
        private final long estimatedTotalBytes;
        private long bytesWritten;

        protected Writer(int keysToSave) {
            this.keys = keysToSave >= AutoSavingCache.this.getKeySet().size() ? AutoSavingCache.this.getKeySet() : AutoSavingCache.this.hotKeySet(keysToSave);
            this.estimatedTotalBytes = AutoSavingCache.this.estimateSizeToSave(this.keys);
            OperationType type = AutoSavingCache.this.cacheType == CacheService.CacheType.KEY_CACHE ? OperationType.KEY_CACHE_SAVE : (AutoSavingCache.this.cacheType == CacheService.CacheType.ROW_CACHE ? OperationType.ROW_CACHE_SAVE : OperationType.UNKNOWN);
            this.info = new CompactionInfo(type, 0L, this.estimatedTotalBytes);
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            long bytesWritten = this.bytesWritten;
            return this.info.forProgress(bytesWritten, Math.max(bytesWritten, this.estimatedTotalBytes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveCache() throws IOException {
            SequentialWriter writer;
            Pair path;
            logger.debug("Deleting old {} files.", (Object)AutoSavingCache.this.cacheType);
            this.deleteOldCacheFiles();
            if (this.keys.size() == 0 || this.estimatedTotalBytes == 0L) {
                logger.debug("Skipping {} save, cache is empty.", (Object)AutoSavingCache.this.cacheType);
                return;
            }
            long start = System.currentTimeMillis();
            HashMap<Pair, SequentialWriter> writers = new HashMap<Pair, SequentialWriter>();
            try {
                for (CacheKey cacheKey : this.keys) {
                    path = cacheKey.getPathInfo();
                    writer = (SequentialWriter)writers.get(path);
                    if (writer == null) {
                        writer = this.tempCacheFile(path);
                        writers.put(path, writer);
                    }
                    cacheKey.write(writer.stream);
                    this.bytesWritten += (long)cacheKey.serializedSize();
                }
            }
            finally {
                for (SequentialWriter sequentialWriter : writers.values()) {
                    FileUtils.closeQuietly(sequentialWriter);
                }
            }
            for (Map.Entry entry : writers.entrySet()) {
                path = (Pair)entry.getKey();
                writer = (SequentialWriter)entry.getValue();
                File tmpFile = new File(writer.getPath());
                File cacheFile = AutoSavingCache.this.getCachePath((String)path.left, (String)path.right);
                cacheFile.delete();
                if (tmpFile.renameTo(cacheFile)) continue;
                logger.error("Unable to rename " + tmpFile + " to " + cacheFile);
            }
            logger.info(String.format("Saved %s (%d items) in %d ms", new Object[]{AutoSavingCache.this.cacheType, this.keys.size(), System.currentTimeMillis() - start}));
        }

        private SequentialWriter tempCacheFile(Pair<String, String> pathInfo) throws IOException {
            File path = AutoSavingCache.this.getCachePath((String)pathInfo.left, (String)pathInfo.right);
            File tmpFile = File.createTempFile(path.getName(), null, path.getParentFile());
            return SequentialWriter.open(tmpFile, true);
        }

        private void deleteOldCacheFiles() {
            File savedCachesDir = new File(DatabaseDescriptor.getSavedCachesLocation());
            if (savedCachesDir.exists() && savedCachesDir.isDirectory()) {
                for (File file : savedCachesDir.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith(AutoSavingCache.this.cacheType.toString()) || file.delete()) continue;
                    logger.warn("Failed to delete {}", (Object)file.getAbsolutePath());
                }
            }
        }
    }
}

