/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSliceResponseResolver
implements IResponseResolver<Iterable<Row>> {
    private static final Logger logger = LoggerFactory.getLogger(RangeSliceResponseResolver.class);
    private static final Comparator<Pair<Row, InetAddress>> pairComparator = new Comparator<Pair<Row, InetAddress>>(){

        @Override
        public int compare(Pair<Row, InetAddress> o1, Pair<Row, InetAddress> o2) {
            return ((Row)o1.left).key.compareTo(((Row)o2.left).key);
        }
    };
    private final String table;
    private final List<InetAddress> sources;
    protected final Collection<Message> responses = new LinkedBlockingQueue<Message>();
    public final List<IAsyncResult> repairResults = new ArrayList<IAsyncResult>();

    public RangeSliceResponseResolver(String table, List<InetAddress> sources) {
        this.sources = sources;
        this.table = table;
    }

    @Override
    public List<Row> getData() throws IOException {
        Message response = this.responses.iterator().next();
        RangeSliceReply reply = RangeSliceReply.read(response.getMessageBody(), response.getVersion());
        return reply.rows;
    }

    @Override
    public Iterable<Row> resolve() throws IOException {
        ArrayList<RowIterator> iters = new ArrayList<RowIterator>(this.responses.size());
        int n = 0;
        for (Message response : this.responses) {
            RangeSliceReply reply = RangeSliceReply.read(response.getMessageBody(), response.getVersion());
            n = Math.max(n, reply.rows.size());
            iters.add(new RowIterator(reply.rows.iterator(), response.getFrom()));
        }
        IMergeIterator<Pair<Row, InetAddress>, Row> iter = MergeIterator.get(iters, pairComparator, new Reducer());
        ArrayList<Row> resolvedRows = new ArrayList<Row>(n);
        while (iter.hasNext()) {
            resolvedRows.add((Row)iter.next());
        }
        return resolvedRows;
    }

    @Override
    public void preprocess(Message message) {
        this.responses.add(message);
    }

    @Override
    public boolean isDataPresent() {
        return !this.responses.isEmpty();
    }

    @Override
    public Iterable<Message> getMessages() {
        return this.responses;
    }

    @Override
    public int getMaxLiveColumns() {
        throw new UnsupportedOperationException();
    }

    private class Reducer
    extends MergeIterator.Reducer<Pair<Row, InetAddress>, Row> {
        List<ColumnFamily> versions;
        List<InetAddress> versionSources;
        DecoratedKey key;

        private Reducer() {
            this.versions = new ArrayList<ColumnFamily>(RangeSliceResponseResolver.this.sources.size());
            this.versionSources = new ArrayList<InetAddress>(RangeSliceResponseResolver.this.sources.size());
        }

        @Override
        public void reduce(Pair<Row, InetAddress> current) {
            this.key = ((Row)current.left).key;
            this.versions.add(((Row)current.left).cf);
            this.versionSources.add((InetAddress)current.right);
        }

        @Override
        protected Row getReduced() {
            ColumnFamily resolved;
            ColumnFamily columnFamily = resolved = this.versions.size() > 1 ? RowRepairResolver.resolveSuperset(this.versions) : this.versions.get(0);
            if (this.versions.size() < RangeSliceResponseResolver.this.sources.size()) {
                for (InetAddress source : RangeSliceResponseResolver.this.sources) {
                    if (this.versionSources.contains(source)) continue;
                    this.versions.add(null);
                    this.versionSources.add(source);
                }
            }
            if (resolved != null) {
                RangeSliceResponseResolver.this.repairResults.addAll(RowRepairResolver.scheduleRepairs(resolved, RangeSliceResponseResolver.this.table, this.key, this.versions, this.versionSources));
            }
            this.versions.clear();
            this.versionSources.clear();
            return new Row(this.key, resolved);
        }
    }

    private static class RowIterator
    extends AbstractIterator<Pair<Row, InetAddress>>
    implements CloseableIterator<Pair<Row, InetAddress>> {
        private final Iterator<Row> iter;
        private final InetAddress source;

        private RowIterator(Iterator<Row> iter, InetAddress source) {
            this.iter = iter;
            this.source = source;
        }

        protected Pair<Row, InetAddress> computeNext() {
            return this.iter.hasNext() ? new Pair<Row, InetAddress>(this.iter.next(), this.source) : (Pair)this.endOfData();
        }

        @Override
        public void close() {
        }
    }
}

