/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Map;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.HeaderSerializer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class Header {
    private static ICompactSerializer<Header> serializer_ = new HeaderSerializer();
    private final InetAddress from_;
    private final StorageService.Verb verb_;
    protected Map<String, byte[]> details_ = new Hashtable<String, byte[]>();

    static ICompactSerializer<Header> serializer() {
        return serializer_;
    }

    Header(InetAddress from, StorageService.Verb verb) {
        assert (from != null);
        assert (verb != null);
        this.from_ = from;
        this.verb_ = verb;
    }

    Header(InetAddress from, StorageService.Verb verb, Map<String, byte[]> details) {
        this(from, verb);
        this.details_ = details;
    }

    InetAddress getFrom() {
        return this.from_;
    }

    StorageService.Verb getVerb() {
        return this.verb_;
    }

    byte[] getDetail(String key) {
        return this.details_.get(key);
    }

    void setDetail(String key, byte[] value) {
        this.details_.put(key, value);
    }

    void removeDetail(String key) {
        this.details_.remove(key);
    }

    public int serializedSize() {
        int size = 0;
        size += CompactEndpointSerializationHelper.serializedSize(this.getFrom());
        size += 4;
        size += 4;
        for (String key : this.details_.keySet()) {
            size += 2 + FBUtilities.encodedUTF8Length(key);
            byte[] value = this.details_.get(key);
            size += 4 + value.length;
        }
        return size;
    }
}

