/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class AddKeyspace
extends Migration {
    private KSMetaData ksm;

    protected AddKeyspace() {
    }

    public AddKeyspace(KSMetaData ksm) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress()), Schema.instance.getVersion());
        if (this.schema.getTableDefinition(ksm.name) != null) {
            throw new ConfigurationException("Keyspace already exists.");
        }
        if (!Migration.isLegalName(ksm.name)) {
            throw new ConfigurationException("Invalid keyspace name: " + ksm.name);
        }
        for (CFMetaData cfm : ksm.cfMetaData().values()) {
            if (Migration.isLegalName(cfm.cfName)) continue;
            throw new ConfigurationException("Invalid column family name: " + cfm.cfName);
        }
        this.ksm = ksm;
        this.rm = this.makeDefinitionMutation(ksm, null, this.newVersion);
    }

    @Override
    public void applyModels() throws IOException {
        for (CFMetaData cfm : this.ksm.cfMetaData().values()) {
            try {
                this.schema.load(cfm);
            }
            catch (ConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.schema.setTableDefinition(this.ksm, this.newVersion);
        this.schema.fixCFMaxId();
        if (!StorageService.instance.isClientMode()) {
            Table.open(this.ksm.name, this.schema);
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.AddKeyspace aks = new org.apache.cassandra.db.migration.avro.AddKeyspace();
        aks.ks = this.ksm.toAvro();
        mi.migration = aks;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.AddKeyspace aks = (org.apache.cassandra.db.migration.avro.AddKeyspace)((Object)mi.migration);
        this.ksm = KSMetaData.fromAvro(aks.ks);
    }

    public String toString() {
        return "Add keyspace: " + this.ksm.toString();
    }
}

