/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.util;

import java.util.List;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.web.util.PredicateRenderer;
import org.apache.camel.web.util.SendDefinitionRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnCompletionDefinitionRenderer {
    private OnCompletionDefinitionRenderer() {
    }

    public static void render(StringBuilder buffer, ProcessorDefinition<?> processor) {
        boolean notGlobal = buffer.toString().endsWith(")");
        if (notGlobal) {
            buffer.append(".");
        }
        OnCompletionDefinition onComplete = (OnCompletionDefinition)processor;
        buffer.append(processor.getShortName()).append("()");
        if (onComplete.getOnWhen() != null) {
            WhenDefinition when = onComplete.getOnWhen();
            buffer.append(".onWhen");
            if (when.getExpression().getPredicate() != null) {
                buffer.append("(");
                PredicateRenderer.render(buffer, when.getExpression().getPredicate());
                buffer.append(")");
            } else {
                buffer.append("Unsupported Expression!");
            }
        }
        if (onComplete.getOnCompleteOnly().booleanValue()) {
            buffer.append(".onCompleteOnly()");
        }
        if (onComplete.getOnFailureOnly().booleanValue()) {
            buffer.append(".onFailureOnly()");
        }
        List branches = onComplete.getOutputs();
        for (ProcessorDefinition branch : branches) {
            SendDefinitionRenderer.render(buffer, branch);
        }
        if (notGlobal) {
            buffer.append(".end()");
        }
    }
}

