/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.util.IOHelper;

public final class SkipIterator
implements Iterator<Object>,
Closeable {
    private final Iterator<?> it;
    private final int skip;
    private boolean closed;
    private final AtomicBoolean hasSkip = new AtomicBoolean();

    public SkipIterator(Iterator<?> it, int skip) {
        this.it = it;
        this.skip = skip;
        if (skip < 0) {
            throw new IllegalArgumentException("Skip must not be a negative number, was: " + skip);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOHelper.closeIterator(this.it);
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() {
        boolean answer;
        if (this.closed) {
            return false;
        }
        if (this.hasSkip.compareAndSet(false, true)) {
            this.doSkip();
        }
        if (!(answer = this.it.hasNext())) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    @Override
    public Object next() {
        if (this.hasSkip.compareAndSet(false, true)) {
            this.doSkip();
        }
        return this.it.next();
    }

    private void doSkip() {
        for (int i = 0; i < this.skip; ++i) {
            if (!this.it.hasNext()) continue;
            this.it.next();
        }
    }

    @Override
    public void remove() {
        this.it.remove();
    }
}

