/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.impl.InterceptSendToMockEndpointStrategy;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.test.TestSupport;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;

public abstract class CamelTestSupport
extends TestSupport {
    protected volatile ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile ConsumerTemplate consumer;
    private boolean useRouteBuilder = true;
    private Service camelContextService;
    private final DebugBreakpoint breakpoint = new DebugBreakpoint();
    private final StopWatch watch = new StopWatch();

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public String isMockEndpoints() {
        return null;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public boolean isUseDebugger() {
        return false;
    }

    public boolean isUseAdviceWith() {
        return false;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public void setCamelContextService(Service camelContextService) {
        this.camelContextService = camelContextService;
    }

    protected void setUp() throws Exception {
        this.log.info("********************************************************************************");
        this.log.info("Testing: " + this.getTestMethodName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
        this.log.info("********************************************************************************");
        this.log.debug("setUp test");
        if (!this.useJmx()) {
            this.disableJMX();
        } else {
            this.enableJMX();
        }
        this.context = (ModelCamelContext)this.createCamelContext();
        CamelTestSupport.assertNotNull((String)"No context found!", (Object)this.context);
        this.context.getShutdownStrategy().setTimeout((long)this.getShutdownTimeout());
        if (this.isUseDebugger()) {
            this.context.setDebugger((Debugger)new DefaultDebugger());
            this.context.getDebugger().addBreakpoint((Breakpoint)this.breakpoint);
        }
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
        String pattern = this.isMockEndpoints();
        if (pattern != null) {
            this.context.addRegisterEndpointCallback((EndpointStrategy)new InterceptSendToMockEndpointStrategy(pattern));
        }
        this.postProcessTest();
        if (this.isUseRouteBuilder()) {
            RouteBuilder[] builders;
            for (RouteBuilder builder : builders = this.createRouteBuilders()) {
                this.log.debug("Using created route builder: " + builder);
                this.context.addRoutes((RoutesBuilder)builder);
            }
            boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
            if (skip) {
                this.log.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
            } else if (this.isUseAdviceWith()) {
                this.log.info("Skipping starting CamelContext as isUseAdviceWith is set to true.");
            } else {
                this.startCamelContext();
            }
        } else {
            this.log.debug("Using route builder from the created context: " + this.context);
        }
        this.log.debug("Routing Rules are: " + this.context.getRoutes());
        this.assertValidContext((CamelContext)this.context);
        this.watch.restart();
    }

    protected void tearDown() throws Exception {
        long time = this.watch.stop();
        this.log.info("********************************************************************************");
        this.log.info("Testing done: " + this.getTestMethodName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
        this.log.info("Took: " + TimeUtils.printDuration((double)time) + " (" + time + " millis)");
        this.log.info("********************************************************************************");
        this.log.debug("tearDown test: " + this.getName());
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.template != null) {
            this.template.stop();
        }
        this.stopCamelContext();
    }

    protected int getShutdownTimeout() {
        return 10;
    }

    protected boolean useJmx() {
        return false;
    }

    protected boolean isLazyLoadingTypeConverter() {
        return true;
    }

    protected void postProcessTest() throws Exception {
        CamelBeanPostProcessor processor = new CamelBeanPostProcessor();
        processor.setCamelContext((CamelContext)this.context);
        processor.postProcessBeforeInitialization((Object)this, "this");
    }

    protected void stopCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.stop();
        } else if (this.context != null) {
            this.context.stop();
        }
    }

    protected void startCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            this.context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.setLazyLoadTypeConverters(Boolean.valueOf(this.isLazyLoadingTypeConverter()));
        return context;
    }

    protected JndiRegistry createRegistry() throws Exception {
        return new JndiRegistry(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        Properties properties = new Properties();
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jndi.properties");
        if (in != null) {
            this.log.debug("Using jndi.properties from classpath root");
            properties.load(in);
        } else {
            properties.put("java.naming.factory.initial", "org.apache.camel.util.jndi.CamelInitialContextFactory");
        }
        return new InitialContext(new Hashtable<Object, Object>(properties));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return CamelTestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return CamelTestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void sendBody(String endpointUri, final Object body) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("testCase", (Object)CamelTestSupport.this.getName());
            }
        });
    }

    protected void sendBody(String endpointUri, final Object body, final Map<String, Object> headers) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("testCase", (Object)CamelTestSupport.this.getName());
                for (Map.Entry entry : headers.entrySet()) {
                    in.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody((CamelContext)this.context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        CamelTestSupport.assertNotNull((String)("No Expression could be created for text: " + expressionText + " language: " + language), (Object)expression);
        CamelTestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        CamelTestSupport.assertNotNull((String)("No Predicate could be created for text: " + expressionText + " language: " + language), (Object)predicate);
        CamelTestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        CamelTestSupport.assertNotNull((String)("No language found for name: " + languageName), (Object)language);
        return language;
    }

    protected void assertMockEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
    }

    protected void assertMockEndpointsSatisfied(long timeout, TimeUnit unit) throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)timeout, (TimeUnit)unit);
    }

    protected void resetMocks() {
        MockEndpoint.resetMocks((CamelContext)this.context);
    }

    protected void assertValidContext(CamelContext context) {
        CamelTestSupport.assertNotNull((String)"No context found!", (Object)context);
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = this.context.getEndpoint(uri, type);
        CamelTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        CamelTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return endpoint;
    }

    protected void disableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "true");
    }

    protected void enableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "false");
    }

    protected void debugBefore(Exchange exchange, Processor processor, ProcessorDefinition definition, String id, String shortName) {
    }

    protected void debugAfter(Exchange exchange, Processor processor, ProcessorDefinition definition, String id, String shortName, long timeTaken) {
    }

    private class DebugBreakpoint
    extends BreakpointSupport {
        private DebugBreakpoint() {
        }

        public void beforeProcess(Exchange exchange, Processor processor, ProcessorDefinition definition) {
            CamelTestSupport.this.debugBefore(exchange, processor, definition, definition.getId(), definition.getShortName());
        }

        public void afterProcess(Exchange exchange, Processor processor, ProcessorDefinition definition, long timeTaken) {
            CamelTestSupport.this.debugAfter(exchange, processor, definition, definition.getId(), definition.getShortName(), timeTaken);
        }
    }
}

