/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http.AuthMethod;
import org.apache.camel.component.http.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.CompositeHttpConfigurer;
import org.apache.camel.component.http.HttpBinding;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.http.HttpConfiguration;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.component.http.NTLMAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http.UrlRewrite;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public class HttpComponent
extends HeaderFilterStrategyComponent {
    protected HttpClientConfigurer httpClientConfigurer;
    protected HttpConnectionManager httpConnectionManager;
    protected HttpBinding httpBinding;
    protected HttpConfiguration httpConfiguration;

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, Set<AuthMethod> authMethods) {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurerRef", HttpClientConfigurer.class);
        if (configurer == null) {
            configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class);
        }
        if (configurer == null) {
            configurer = this.getHttpClientConfigurer();
        }
        String authUsername = (String)this.getAndRemoveParameter(parameters, "authUsername", String.class);
        AuthMethod authMethod = (AuthMethod)((Object)this.getAndRemoveParameter(parameters, "authMethod", AuthMethod.class));
        if (authUsername != null && authMethod == null) {
            throw new IllegalArgumentException("Option authMethod must be provided to use authentication");
        }
        if (authMethod != null) {
            String authPassword = (String)this.getAndRemoveParameter(parameters, "authPassword", String.class);
            String authDomain = (String)this.getAndRemoveParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getAndRemoveParameter(parameters, "authHost", String.class);
            configurer = this.configureAuth(configurer, authMethod, authUsername, authPassword, authDomain, authHost, authMethods);
        } else if (this.httpConfiguration != null) {
            configurer = this.configureAuth(configurer, this.httpConfiguration.getAuthMethod(), this.httpConfiguration.getAuthUsername(), this.httpConfiguration.getAuthPassword(), this.httpConfiguration.getAuthDomain(), this.httpConfiguration.getAuthHost(), authMethods);
        }
        String proxyAuthUsername = (String)this.getAndRemoveParameter(parameters, "proxyAuthUsername", String.class);
        AuthMethod proxyAuthMethod = (AuthMethod)((Object)this.getAndRemoveParameter(parameters, "proxyAuthMethod", AuthMethod.class));
        if (proxyAuthUsername != null && proxyAuthMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        if (proxyAuthMethod != null) {
            String proxyAuthPassword = (String)this.getAndRemoveParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = (String)this.getAndRemoveParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthHost = (String)this.getAndRemoveParameter(parameters, "proxyAuthHost", String.class);
            configurer = this.configureProxyAuth(configurer, proxyAuthMethod, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthHost, authMethods);
        } else if (this.httpConfiguration != null) {
            configurer = this.configureProxyAuth(configurer, this.httpConfiguration.getProxyAuthMethod(), this.httpConfiguration.getProxyAuthUsername(), this.httpConfiguration.getProxyAuthPassword(), this.httpConfiguration.getProxyAuthDomain(), this.httpConfiguration.getProxyAuthHost(), authMethods);
        }
        return configurer;
    }

    protected HttpClientConfigurer configureAuth(HttpClientConfigurer configurer, AuthMethod authMethod, String username, String password, String domain, String host, Set<AuthMethod> authMethods) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option authMethod must be provided to use authentication");
        }
        ObjectHelper.notNull((Object)((Object)authMethod), (String)"authMethod");
        ObjectHelper.notNull((Object)username, (String)"authUsername");
        ObjectHelper.notNull((Object)password, (String)"authPassword");
        authMethods.add(authMethod);
        if (authMethod == AuthMethod.Basic || authMethod == AuthMethod.Digest) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(false, username, password));
        }
        if (authMethod == AuthMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"authDomain");
            return CompositeHttpConfigurer.combineConfigurers(configurer, new NTLMAuthenticationHttpClientConfigurer(false, username, password, domain, host));
        }
        throw new IllegalArgumentException("Unknown authMethod " + (Object)((Object)authMethod));
    }

    protected HttpClientConfigurer configureProxyAuth(HttpClientConfigurer configurer, AuthMethod authMethod, String username, String password, String domain, String host, Set<AuthMethod> authMethods) {
        if (username == null && authMethod == null) {
            return configurer;
        }
        if (username != null && authMethod == null) {
            throw new IllegalArgumentException("Option proxyAuthMethod must be provided to use proxy authentication");
        }
        ObjectHelper.notNull((Object)((Object)authMethod), (String)"proxyAuthMethod");
        ObjectHelper.notNull((Object)username, (String)"proxyAuthUsername");
        ObjectHelper.notNull((Object)password, (String)"proxyAuthPassword");
        authMethods.add(authMethod);
        if (authMethod == AuthMethod.Basic || authMethod == AuthMethod.Digest) {
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(true, username, password));
        }
        if (authMethod == AuthMethod.NTLM) {
            ObjectHelper.notNull((Object)domain, (String)"proxyAuthDomain");
            return CompositeHttpConfigurer.combineConfigurers(configurer, new NTLMAuthenticationHttpClientConfigurer(true, username, password, domain, host));
        }
        throw new IllegalArgumentException("Unknown proxyAuthMethod " + (Object)((Object)authMethod));
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String addressUri = uri;
        if (!uri.startsWith("http:") && !uri.startsWith("https:")) {
            addressUri = remaining;
        }
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        if (binding == null) {
            binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        }
        String proxyHost = (String)this.getAndRemoveParameter(parameters, "proxyHost", String.class);
        Integer proxyPort = (Integer)this.getAndRemoveParameter(parameters, "proxyPort", Integer.class);
        String authMethodPriority = (String)this.getAndRemoveParameter(parameters, "authMethodPriority", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        HttpClientParams clientParams = new HttpClientParams();
        IntrospectionSupport.setProperties((Object)clientParams, parameters, (String)"httpClient.");
        this.validateParameters(uri, parameters, "httpClient.");
        HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
        IntrospectionSupport.setProperties((Object)connectionManagerParams, parameters, (String)"httpConnectionManager.");
        this.validateParameters(uri, parameters, "httpConnectionManager.");
        HttpConnectionManager thisHttpConnectionManager = this.httpConnectionManager;
        if (thisHttpConnectionManager == null) {
            thisHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            thisHttpConnectionManager.setParams(connectionManagerParams);
        }
        LinkedHashSet<AuthMethod> authMethods = new LinkedHashSet<AuthMethod>();
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, authMethods);
        URI endpointUri = URISupport.createRemainingURI((URI)new URI(addressUri), httpClientParameters);
        HttpEndpoint endpoint = new HttpEndpoint(endpointUri.toString(), this, clientParams, thisHttpConnectionManager, configurer);
        endpoint.getHttpConnectionManager().setParams(connectionManagerParams);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (proxyHost != null) {
            endpoint.setProxyHost(proxyHost);
            endpoint.setProxyPort(proxyPort);
        } else if (this.httpConfiguration != null) {
            endpoint.setProxyHost(this.httpConfiguration.getProxyHost());
            endpoint.setProxyPort(this.httpConfiguration.getProxyPort());
        }
        if (authMethodPriority != null) {
            endpoint.setAuthMethodPriority(authMethodPriority);
        } else if (this.httpConfiguration != null && this.httpConfiguration.getAuthMethodPriority() != null) {
            endpoint.setAuthMethodPriority(this.httpConfiguration.getAuthMethodPriority());
        } else if (!authMethods.isEmpty()) {
            authMethodPriority = CollectionHelper.collectionAsCommaDelimitedString(authMethods);
            endpoint.setAuthMethodPriority(authMethodPriority);
        }
        this.setProperties((Object)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(addressUri), parameters);
        String part = httpUri.getSchemeSpecificPart();
        if (part != null && ((part = part.toLowerCase()).startsWith("//http//") || part.startsWith("//https//") || part.startsWith("//http://") || part.startsWith("//https://"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        endpoint.setHttpUri(httpUri);
        return endpoint;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public void setHttpConfiguration(HttpConfiguration httpConfiguration) {
        this.httpConfiguration = httpConfiguration;
    }
}

