/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.RobustOutOnlyAxisOperation;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.httpclient.Header;

public abstract class Stub {
    protected AxisService _service;
    protected ArrayList modules = new ArrayList();
    protected ServiceClient _serviceClient;

    public ServiceClient _getServiceClient() {
        return this._serviceClient;
    }

    public void _setServiceClient(ServiceClient _serviceClient) {
        this._serviceClient = _serviceClient;
    }

    protected static SOAPEnvelope createEnvelope(Options options) throws SOAPProcessingException {
        return Stub.getFactory(options.getSoapVersionURI()).getDefaultEnvelope();
    }

    protected static SOAPFactory getFactory(String soapVersionURI) {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapVersionURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        throw new RuntimeException(Messages.getMessage("unknownsoapversion"));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    public void cleanup() throws AxisFault {
        this._service.getAxisConfiguration().removeService(this._service.getName());
    }

    protected void setServiceClientEPR(String address) {
        EndpointReference toEPRFromServiceClient = this._serviceClient.getOptions().getTo();
        toEPRFromServiceClient.setAddress(address);
    }

    protected void addHttpHeader(MessageContext messageContext, String name, String value) {
        ArrayList headersObj = messageContext.getProperty("HTTP_HEADERS");
        if (headersObj == null) {
            headersObj = new ArrayList();
        }
        List headers = headersObj;
        Header header = new Header();
        header.setName(name);
        header.setValue(value);
        headers.add(header);
        messageContext.setProperty("HTTP_HEADERS", headers);
    }

    protected void addPropertyToOperationClient(OperationClient operationClient, String propertyKey, Object propertyValue) {
        operationClient.getOptions().setProperty(propertyKey, propertyValue);
    }

    protected void addPropertyToOperationClient(OperationClient operationClient, String propertyKey, boolean value) {
        this.addPropertyToOperationClient(operationClient, propertyKey, new Boolean(value));
    }

    protected void addPropertyToOperationClient(OperationClient operationClient, String propertyKey, int value) {
        this.addPropertyToOperationClient(operationClient, propertyKey, new Integer(value));
    }

    protected void setMustUnderstand(OMElement headerElement, OMNamespace omNamespace) {
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMAttribute mustUnderstandAttribute = omFactory.createOMAttribute("mustUnderstand", omNamespace, "true");
        headerElement.addAttribute(mustUnderstandAttribute);
    }

    protected void addHeader(OMElement omElementToadd, SOAPEnvelope envelop, boolean mustUnderstand) {
        SOAPHeaderBlock soapHeaderBlock = envelop.getHeader().addHeaderBlock(omElementToadd.getLocalName(), omElementToadd.getNamespace());
        soapHeaderBlock.setMustUnderstand(mustUnderstand);
        OMNode omNode = null;
        Iterator iter = omElementToadd.getChildren();
        while (iter.hasNext()) {
            omNode = (OMNode)iter.next();
            soapHeaderBlock.addChild(omNode);
        }
        OMAttribute omatribute = null;
        Iterator iter2 = omElementToadd.getAllAttributes();
        while (iter2.hasNext()) {
            omatribute = (OMAttribute)iter2.next();
            soapHeaderBlock.addAttribute(omatribute);
        }
    }

    protected void addHeader(OMElement omElementToadd, SOAPEnvelope envelop) {
        this.addHeader(omElementToadd, envelop, false);
    }

    protected void addAnonymousOperations() {
        RobustOutOnlyAxisOperation robustoutoonlyOperation = new RobustOutOnlyAxisOperation(ServiceClient.ANON_ROBUST_OUT_ONLY_OP);
        this._service.addOperation(robustoutoonlyOperation);
        OutOnlyAxisOperation outOnlyOperation = new OutOnlyAxisOperation(ServiceClient.ANON_OUT_ONLY_OP);
        this._service.addOperation(outOnlyOperation);
        OutInAxisOperation outInOperation = new OutInAxisOperation(ServiceClient.ANON_OUT_IN_OP);
        this._service.addOperation(outInOperation);
    }
}

