/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.AbstractAgent;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyRegistry;
import org.apache.ws.commons.schema.XmlSchema;

public class ListingAgent
extends AbstractAgent {
    private static final String LIST_MULTIPLE_SERVICE_JSP_NAME = "listServices.jsp";
    private static final String LIST_SINGLE_SERVICE_JSP_NAME = "listSingleService.jsp";
    private static final String LIST_FAULTY_SERVICES_JSP_NAME = "listFaultyService.jsp";
    public static final String RUNNING_PORT = "RUNNING_PORT";

    public ListingAgent(ConfigurationContext aConfigContext) {
        super(aConfigContext);
    }

    private void addTransportListner(String schema, int port) {
        try {
            TransportInDescription trsIn = this.configContext.getAxisConfiguration().getTransportIn(new QName(schema));
            if (trsIn == null) {
                trsIn = new TransportInDescription(new QName(schema));
                trsIn.setReceiver(new HTTPSListener(port, schema));
                this.configContext.getListenerManager().addListener(trsIn, true);
            }
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String query;
        String filePart = httpServletRequest.getRequestURL().toString();
        int ipindex = filePart.indexOf("//");
        if (ipindex >= 0) {
            String ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            String portstr = ip.substring(seperatorIndex + 1, slashIndex);
            try {
                this.addTransportListner(httpServletRequest.getScheme(), Integer.parseInt(portstr));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((query = httpServletRequest.getQueryString()) != null) {
            if (query.indexOf("?wsdl2") > 0 || query.indexOf("?wsdl") > 0 || query.indexOf("?xsd") > 0) {
                this.processListService(httpServletRequest, httpServletResponse);
            } else {
                super.handle(httpServletRequest, httpServletResponse);
            }
        } else {
            super.handle(httpServletRequest, httpServletResponse);
        }
    }

    protected void processListFaultyServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String serviceName = req.getParameter("serviceName");
        if (serviceName != null) {
            AxisService service = this.configContext.getAxisConfiguration().getService(serviceName);
            req.getSession().setAttribute("singleservice", (Object)service);
        }
        this.renderView(LIST_FAULTY_SERVICES_JSP_NAME, req, res);
    }

    protected void processIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.processListServices(httpServletRequest, httpServletResponse);
    }

    private String extractHostAndPort(String filePart, boolean isHttp) {
        int ipindex = filePart.indexOf("//");
        String ip = null;
        if (ipindex >= 0) {
            String port;
            ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            if (seperatorIndex >= 0) {
                port = ip.substring(seperatorIndex + 1, slashIndex);
                ip = ip.substring(0, seperatorIndex);
            } else {
                ip = ip.substring(0, slashIndex);
                port = "80";
            }
            if (isHttp) {
                this.configContext.setProperty(RUNNING_PORT, port);
            }
        }
        return ip;
    }

    public void processListService(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String filePart = req.getRequestURL().toString();
        String serviceName = filePart.substring(filePart.lastIndexOf("/") + 1, filePart.length());
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        String query = req.getQueryString();
        int wsdl2 = query.indexOf("wsdl2");
        int wsdl = query.indexOf("wsdl");
        int xsd = query.indexOf("xsd");
        int policy = query.indexOf("policy");
        if (services != null && !services.isEmpty()) {
            Object serviceObj = services.get(serviceName);
            if (serviceObj != null) {
                boolean isHttp = "http".equals(req.getScheme());
                if (wsdl2 >= 0) {
                    ServletOutputStream out = res.getOutputStream();
                    res.setContentType("text/xml");
                    String ip = this.extractHostAndPort(filePart, isHttp);
                    ((AxisService)serviceObj).printWSDL2((OutputStream)out, ip, this.configContext.getServiceContextPath());
                    out.flush();
                    out.close();
                    return;
                }
                if (wsdl >= 0) {
                    ServletOutputStream out = res.getOutputStream();
                    res.setContentType("text/xml");
                    String ip = this.extractHostAndPort(filePart, isHttp);
                    ((AxisService)serviceObj).printWSDL((OutputStream)out, ip, this.configContext.getServicePath());
                    out.flush();
                    out.close();
                    return;
                }
                if (xsd >= 0) {
                    ServletOutputStream out = res.getOutputStream();
                    res.setContentType("text/xml");
                    AxisService axisService = (AxisService)serviceObj;
                    axisService.populateSchemaMappings();
                    Map schemaMappingtable = axisService.getSchemaMappingTable();
                    ArrayList schemas = axisService.getSchema();
                    String xsds = req.getParameter("xsd");
                    if (!"".equals(xsds)) {
                        XmlSchema schema = (XmlSchema)schemaMappingtable.get(xsds);
                        if (schema != null) {
                            schema.write((OutputStream)out);
                            out.flush();
                            out.close();
                        } else {
                            InputStream in = axisService.getClassLoader().getResourceAsStream("META-INF/" + xsds);
                            if (in != null) {
                                out.write(IOUtils.getStreamAsByteArray((InputStream)in));
                                out.flush();
                                out.close();
                            } else {
                                res.sendError(404);
                            }
                        }
                    } else if (schemas.size() > 1) {
                        res.sendRedirect("");
                    } else {
                        XmlSchema schema = axisService.getSchema(0);
                        if (schema != null) {
                            schema.write((OutputStream)out);
                            out.flush();
                            out.close();
                        }
                    }
                    return;
                }
                if (policy >= 0) {
                    ServletOutputStream out = res.getOutputStream();
                    ExternalPolicySerializer serializer = new ExternalPolicySerializer();
                    serializer.setAssertionsToFilter(this.configContext.getAxisConfiguration().getLocalPolicyAssertions());
                    String idParam = req.getParameter("id");
                    if (idParam != null) {
                        Policy targetPolicy = this.findPolicy(idParam, (AxisService)serviceObj);
                        if (targetPolicy != null) {
                            try {
                                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)out);
                                res.setContentType("text/xml");
                                targetPolicy.serialize(writer);
                                writer.flush();
                            }
                            catch (XMLStreamException e) {
                                throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                            }
                            catch (FactoryConfigurationError e) {
                                throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                            }
                        } else {
                            res.setContentType("text/html");
                            String outStr = "<b>No policy found for id=" + idParam + "</b>";
                            out.write(outStr.getBytes());
                        }
                    } else {
                        PolicyInclude policyInclude = ((AxisService)serviceObj).getPolicyInclude();
                        Policy effecPolicy = policyInclude.getEffectivePolicy();
                        if (effecPolicy != null) {
                            try {
                                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)out);
                                res.setContentType("text/xml");
                                effecPolicy.serialize(writer);
                                writer.flush();
                            }
                            catch (XMLStreamException e) {
                                throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                            }
                            catch (FactoryConfigurationError e) {
                                throw new ServletException("Error occured when serializing the Policy", (Throwable)e);
                            }
                        } else {
                            res.setContentType("text/html");
                            String outStr = "<b>No effective policy for " + serviceName + " servcie</b>";
                            out.write(outStr.getBytes());
                        }
                    }
                    return;
                }
                req.getSession().setAttribute("singleservice", serviceObj);
            } else {
                req.getSession().setAttribute("singleservice", null);
            }
        }
        this.renderView(LIST_SINGLE_SERVICE_JSP_NAME, req, res);
    }

    protected void processListServices(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.populateSessionInformation(req);
        req.getSession().setAttribute("errprservicemap", (Object)this.configContext.getAxisConfiguration().getFaultyServices());
        this.renderView(LIST_MULTIPLE_SERVICE_JSP_NAME, req, res);
    }

    private Policy findPolicy(String id, AxisDescription des) {
        ArrayList policyElements = des.getPolicyInclude().getPolicyElements();
        PolicyRegistry registry = des.getPolicyInclude().getPolicyRegistry();
        Object policyComponent = null;
        Policy policy = registry.lookup(id);
        if (policy != null) {
            return policy;
        }
        Iterator iterator = policyElements.iterator();
        while (iterator.hasNext()) {
            policyComponent = iterator.next();
            if (!(policyComponent instanceof Policy) || !id.equals(((Policy)policyComponent).getId())) continue;
            return policyComponent;
        }
        Iterator iterator2 = des.getChildren();
        while (iterator2.hasNext()) {
            AxisDescription child = (AxisDescription)iterator2.next();
            policy = this.findPolicy(id, child);
            if (policy == null) continue;
            return policy;
        }
        return null;
    }

    private class HTTPSListener
    implements TransportListener {
        private int port;
        private String schema;
        private ConfigurationContext axisConf;

        public HTTPSListener(int port, String schema) {
            this.port = port;
            this.schema = schema;
        }

        public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
            this.axisConf = axisConf;
        }

        public void start() throws AxisFault {
        }

        public void stop() throws AxisFault {
        }

        public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
            return new EndpointReference[]{new EndpointReference(this.schema + "://" + ip + ":" + this.port + "/" + this.axisConf.getServiceContextPath() + "/" + serviceName)};
        }

        public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
            return this.getEPRsForService(serviceName, ip)[0];
        }
    }
}

