/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.deployment.WarBasedAxisConfigurator;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisServlet
extends HttpServlet
implements TransportListener {
    private static final Log log = LogFactory.getLog((Class)AxisServlet.class);
    private static final long serialVersionUID = -2085869393709833372L;
    public static final String CONFIGURATION_CONTEXT = "CONFIGURATION_CONTEXT";
    public static final String SESSION_ID = "SessionId";
    protected transient ConfigurationContext configContext;
    protected transient AxisConfiguration axisConfiguration;
    protected transient ServletConfig servletConfig;
    private transient ListingAgent agent;
    private String contextRoot = null;
    protected boolean enableRESTInAxis2MainServlet = false;
    protected boolean disableREST = false;
    protected boolean disableSeperateEndpointForREST = false;
    private static final String LIST_SERVICES_SUFIX = "/services/listServices";
    private static final String LIST_FAUKT_SERVICES_SUFIX = "/services/ListFaultyServices";

    protected MessageContext createAndSetInitialParamsToMsgCtxt(HttpServletResponse resp, HttpServletRequest req) throws AxisFault {
        MessageContext msgContext = new MessageContext();
        if (this.axisConfiguration.isManageTransportSession()) {
            Object sessionContext = this.getSessionContext(req);
            msgContext.setSessionContext((SessionContext)sessionContext);
        }
        msgContext.setConfigurationContext(this.configContext);
        msgContext.setTransportIn(this.axisConfiguration.getTransportIn(new QName("http")));
        msgContext.setTransportOut(this.axisConfiguration.getTransportOut(new QName("http")));
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(resp));
        msgContext.setProperty("REMOTE_ADDR", req.getRemoteAddr());
        msgContext.setFrom(new EndpointReference(req.getRemoteAddr()));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getTransportHeaders(req));
        msgContext.setProperty(SESSION_ID, req.getSession().getId());
        msgContext.setProperty("TransportInURL", req.getRequestURL().toString());
        msgContext.setIncomingTransportName("http");
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        return msgContext;
    }

    public void destroy() {
        super.destroy();
        try {
            this.configContext.getListenerManager().stop();
        }
        catch (AxisFault axisFault) {
            log.info((Object)axisFault.getMessage());
        }
    }

    public void initContextRoot(HttpServletRequest req) {
        boolean findContext = true;
        String findContextParameter = this.servletConfig.getInitParameter("axis2.find.context");
        if (findContextParameter != null) {
            findContextParameter = findContextParameter.trim();
            findContext = JavaUtils.isTrue(findContextParameter);
        }
        if (!findContext && this.contextRoot == null) {
            this.contextRoot = this.configContext.getContextRoot();
        }
        if (this.contextRoot == null || "".equals(this.contextRoot)) {
            String[] parts = JavaUtils.split(req.getContextPath(), '/');
            if (parts != null) {
                for (int i = 0; i < parts.length; ++i) {
                    if (parts[i].length() <= 0) continue;
                    this.contextRoot = parts[i];
                    break;
                }
            }
            if (this.contextRoot == null || req.getContextPath().equals("/")) {
                this.contextRoot = "/";
            }
            this.configContext.setContextRoot(this.contextRoot);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initContextRoot(req);
        String requestURI = req.getRequestURI();
        String query = req.getQueryString();
        if (query != null && (query.indexOf("wsdl2") >= 0 || query.indexOf("wsdl") >= 0 || query.indexOf("xsd") >= 0 || query.indexOf("policy") >= 0)) {
            this.agent.processListService(req, resp);
        } else if (requestURI.endsWith(LIST_SERVICES_SUFIX) || requestURI.endsWith(LIST_FAUKT_SERVICES_SUFIX)) {
            try {
                this.agent.handle(req, resp);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else if (!this.disableREST && this.enableRESTInAxis2MainServlet) {
            MessageContext messageContext = null;
            try {
                messageContext = this.createMessageContext(req, resp);
                new RESTUtil(this.configContext).processGetRequest(messageContext, req, resp);
            }
            catch (Exception e) {
                log.error((Object)e);
                if (messageContext != null) {
                    resp.setStatus(500);
                    this.handleFault(messageContext, (OutputStream)resp.getOutputStream(), new AxisFault(e));
                }
                throw new ServletException((Throwable)e);
            }
        } else {
            PrintWriter writer = new PrintWriter((OutputStream)resp.getOutputStream());
            writer.println("<html><body><h2>Please enable REST support in WEB-INF/conf/axis2.xml and WEB-INF/web.xml</h2></body></html>");
            writer.flush();
            resp.setStatus(202);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.initContextRoot(req);
        ServletOutputStream out = res.getOutputStream();
        if (!this.disableREST && this.enableRESTInAxis2MainServlet && this.isRESTRequest(req)) {
            MessageContext msgContext = this.createMessageContext(req, res);
            try {
                new RESTUtil(this.configContext).processPostRequest(msgContext, req, res);
            }
            catch (Exception e) {
                log.error((Object)e);
                if (msgContext != null) {
                    res.setStatus(500);
                    this.handleFault(msgContext, (OutputStream)out, new AxisFault(e));
                }
                throw new ServletException((Throwable)e);
            }
        } else {
            MessageContext msgContext = this.createAndSetInitialParamsToMsgCtxt(res, req);
            try {
                out = res.getOutputStream();
                HTTPTransportUtils.processHTTPPostRequest(msgContext, (InputStream)req.getInputStream(), (OutputStream)out, req.getContentType(), req.getHeader("SOAPAction"), req.getRequestURL().toString());
                Object contextWritten = msgContext.getOperationContext().getProperty("CONTENT_WRITTEN");
                res.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
                if (contextWritten == null || !"true".equals(contextWritten)) {
                    res.setStatus(202);
                }
            }
            catch (AxisFault e) {
                log.debug((Object)e);
                if (msgContext != null) {
                    try {
                        if (AddressingHelper.isFaultRedirected(msgContext)) {
                            res.setStatus(202);
                        } else {
                            res.setStatus(500);
                        }
                        this.handleFault(msgContext, (OutputStream)out, e);
                    }
                    catch (AxisFault e2) {
                        log.info((Object)e2);
                    }
                }
                throw new ServletException((Throwable)e);
            }
            catch (Throwable t) {
                log.error((Object)t);
                if (msgContext != null) {
                    try {
                        if (AddressingHelper.isFaultRedirected(msgContext)) {
                            res.setStatus(202);
                        } else {
                            res.setStatus(500);
                        }
                        this.handleFault(msgContext, (OutputStream)out, new AxisFault(t.toString(), t));
                    }
                    catch (AxisFault e2) {
                        log.info((Object)e2);
                    }
                }
                throw new ServletException(t);
            }
        }
    }

    protected void handleFault(MessageContext msgContext, OutputStream out, AxisFault e) throws AxisFault {
        msgContext.setProperty("TRANSPORT_OUT", out);
        AxisEngine engine = new AxisEngine(this.configContext);
        MessageContext faultContext = engine.createFaultMessageContext(msgContext, e);
        engine.sendFault(faultContext);
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.servletConfig = config;
            this.configContext = this.initConfigContext(config);
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            config.getServletContext().setAttribute(CONFIGURATION_CONTEXT, (Object)this.configContext);
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            TransportInDescription transportInDescription = new TransportInDescription(new QName("http"));
            transportInDescription.setReceiver(this);
            listenerManager.addListener(transportInDescription, true);
            ListenerManager.defaultConfigurationContext = this.configContext;
            this.agent = new ListingAgent(this.configContext);
            this.initParams();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void initParams() {
        Parameter parameter = this.axisConfiguration.getParameter("enableRESTInAxis2MainServlet");
        if (parameter != null) {
            boolean bl = this.enableRESTInAxis2MainServlet = !JavaUtils.isFalseExplicitly(parameter.getValue());
        }
        if ((parameter = this.axisConfiguration.getParameter("disableREST")) != null) {
            boolean bl = this.disableREST = !JavaUtils.isFalseExplicitly(parameter.getValue());
        }
        if ((parameter = this.axisConfiguration.getParameter("disableSeparateEndpointForREST")) != null) {
            this.disableSeperateEndpointForREST = !JavaUtils.isFalseExplicitly(parameter.getValue());
        }
    }

    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }

    protected ConfigurationContext initConfigContext(ServletConfig config) throws ServletException {
        try {
            ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContext(new WarBasedAxisConfigurator(config));
            configContext.setProperty("ContainerManaged", "true");
            return configContext;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected HashMap getHTTPParameters(HttpServletRequest httpServletRequest) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration enu = httpServletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = httpServletRequest.getParameter(name);
            map.put(name, value);
        }
        return map;
    }

    protected Object getSessionContext(HttpServletRequest httpServletRequest) {
        Object sessionContext = httpServletRequest.getSession(true).getAttribute("SessionContext");
        if (sessionContext == null) {
            sessionContext = new SessionContext(null);
            httpServletRequest.getSession().setAttribute("SessionContext", sessionContext);
        }
        return sessionContext;
    }

    protected Map getTransportHeaders(HttpServletRequest req) {
        return new TransportHeaders(req);
    }

    public void init(ConfigurationContext axisConf, TransportInDescription transprtIn) throws AxisFault {
    }

    public void start() throws AxisFault {
    }

    public void stop() throws AxisFault {
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String port = (String)this.configContext.getProperty("RUNNING_PORT");
        if (port == null) {
            port = "8080";
        }
        if (ip == null) {
            try {
                ip = HttpUtils.getIpAddress();
                if (ip == null) {
                    ip = "localhost";
                }
            }
            catch (SocketException e) {
                throw new AxisFault(e);
            }
        }
        EndpointReference soapEndpoint = new EndpointReference("http://" + ip + ":" + port + '/' + this.configContext.getServiceContextPath() + "/" + serviceName);
        if (!this.disableREST && !this.disableSeperateEndpointForREST) {
            EndpointReference restEndpoint = new EndpointReference("http://" + ip + ":" + port + '/' + this.configContext.getRESTContextPath() + "/" + serviceName);
            return new EndpointReference[]{soapEndpoint, restEndpoint};
        }
        return new EndpointReference[]{soapEndpoint};
    }

    protected MessageContext createMessageContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MessageContext msgContext = new MessageContext();
        String trsPrefix = req.getRequestURL().toString();
        int sepindex = trsPrefix.indexOf(58);
        if (sepindex >= 0) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            msgContext.setIncomingTransportName(trsPrefix);
        } else {
            msgContext.setIncomingTransportName("http");
        }
        msgContext.setConfigurationContext(this.configContext);
        msgContext.setTransportIn(this.configContext.getAxisConfiguration().getTransportIn(new QName("http")));
        TransportOutDescription transportOut = this.configContext.getAxisConfiguration().getTransportOut(new QName("http"));
        msgContext.setTransportOut(transportOut);
        msgContext.setServerSide(true);
        String requestURI = req.getRequestURI();
        if (requestURI.indexOf("rest") != -1) {
            requestURI = requestURI.replaceFirst("rest", this.configContext.getServiceContextPath());
        }
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setFrom(new EndpointReference(req.getRemoteAddr()));
        msgContext.setProperty("REMOTE_ADDR", req.getRemoteAddr());
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(resp));
        msgContext.setProperty("TRANSPORT_HEADERS", this.getHeaders(req));
        msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, req);
        return msgContext;
    }

    protected Map getHeaders(HttpServletRequest request) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String field = (String)e.nextElement();
            headerMap.put(field, request.getAttribute(field));
        }
        return headerMap;
    }

    private boolean isRESTRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        String soapActionHeader = request.getHeader("SOAPAction");
        return soapActionHeader == null || contentType != null && contentType.indexOf("application/x-www-form-urlencoded") > -1;
    }
}

