/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.OutInAxisOperationClient;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;

public class RobustOutOnlyAxisOperation
extends OutInAxisOperation {
    public RobustOutOnlyAxisOperation() {
        this.setMessageExchangePattern("http://www.w3.org/2004/08/wsdl/robust-out-only");
    }

    public RobustOutOnlyAxisOperation(QName name) {
        super(name);
        this.setMessageExchangePattern("http://www.w3.org/2004/08/wsdl/robust-out-only");
    }

    public OperationClient createClient(ServiceContext sc, Options options) {
        return new RobustOperationClient(this, sc, options);
    }

    class RobustOperationClient
    extends OutInAxisOperationClient {
        public RobustOperationClient(OutInAxisOperation axisOp, ServiceContext sc, Options options) {
            super(axisOp, sc, options);
        }

        protected MessageContext send(MessageContext msgctx) throws AxisFault {
            InputStream inStream;
            AxisEngine engine = new AxisEngine(msgctx.getConfigurationContext());
            MessageContext responseMessageContext = new MessageContext();
            responseMessageContext.setOptions(this.options);
            responseMessageContext.setServerSide(false);
            responseMessageContext.setMessageID(msgctx.getMessageID());
            this.addMessageContext(responseMessageContext);
            responseMessageContext.setServiceContext(msgctx.getServiceContext());
            responseMessageContext.setAxisMessage(msgctx.getAxisOperation().getMessage("In"));
            engine.send(msgctx);
            responseMessageContext.setDoingREST(msgctx.isDoingREST());
            responseMessageContext.setProperty("TRANSPORT_IN", msgctx.getProperty("TRANSPORT_IN"));
            responseMessageContext.setTransportIn(msgctx.getTransportIn());
            responseMessageContext.setTransportOut(msgctx.getTransportOut());
            responseMessageContext.setSoapAction("");
            SOAPEnvelope envelope = responseMessageContext.getEnvelope();
            if (envelope == null && (inStream = (InputStream)responseMessageContext.getProperty("TRANSPORT_IN")) != null) {
                envelope = TransportUtils.createSOAPMessage(responseMessageContext, msgctx.getEnvelope().getNamespace().getNamespaceURI());
            }
            if (envelope != null && envelope.getBody().hasFault()) {
                engine.receiveFault(responseMessageContext);
                SOAPFault soapFault = envelope.getBody().getFault();
                throw new AxisFault(soapFault.getCode(), soapFault.getReason(), soapFault.getNode(), soapFault.getRole(), soapFault.getDetail());
            }
            return null;
        }
    }
}

