/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;

public class ClientUtils {
    public static synchronized TransportOutDescription inferOutTransport(AxisConfiguration ac, EndpointReference epr, MessageContext msgctx) throws AxisFault {
        String transport;
        String transportURI = (String)msgctx.getProperty("TransportURL");
        if (transportURI != null && !"".equals(transportURI)) {
            String transport2;
            int index = transportURI.indexOf(58);
            String string = transport2 = index > 0 ? transportURI.substring(0, index) : null;
            if (transport2 != null) {
                return ac.getTransportOut(new QName(transport2));
            }
            throw new AxisFault(Messages.getMessage("cannotInferTransport", transportURI));
        }
        if (msgctx.getOptions().getTransportOut() != null) {
            if (msgctx.getOptions().getTransportOut().getSender() == null) {
                throw new AxisFault("Incomplete transport sender: missing sender!");
            }
            return msgctx.getOptions().getTransportOut();
        }
        if (epr == null || epr.getAddress() == null) {
            throw new AxisFault(Messages.getMessage("cannotInferTransportNoAddr"));
        }
        String uri = epr.getAddress();
        int index = uri.indexOf(58);
        String string = transport = index > 0 ? uri.substring(0, index) : null;
        if (transport != null) {
            return ac.getTransportOut(new QName(transport));
        }
        throw new AxisFault(Messages.getMessage("cannotInferTransport", uri));
    }

    public static synchronized TransportInDescription inferInTransport(AxisConfiguration ac, Options options, MessageContext msgCtxt) throws AxisFault {
        String listenerTransportProtocol = options.getTransportInProtocol();
        if (listenerTransportProtocol == null) {
            EndpointReference replyTo = msgCtxt.getReplyTo();
            if (replyTo != null) {
                try {
                    URI uri = new URI(replyTo.getAddress());
                    listenerTransportProtocol = uri.getScheme();
                }
                catch (URISyntaxException e) {}
            } else {
                listenerTransportProtocol = msgCtxt.getTransportOut().getName().getLocalPart();
            }
        }
        TransportInDescription transportIn = null;
        if (options.isUseSeparateListener()) {
            if (listenerTransportProtocol != null && !"".equals(listenerTransportProtocol)) {
                transportIn = ac.getTransportIn(new QName(listenerTransportProtocol));
                ListenerManager listenerManager = msgCtxt.getConfigurationContext().getListenerManager();
                if (transportIn == null) {
                    throw new AxisFault(Messages.getMessage("unknownTransport", listenerTransportProtocol));
                }
                if (!listenerManager.isListenerRunning(transportIn.getName().getLocalPart())) {
                    listenerManager.addListener(transportIn, false);
                }
            }
            if (msgCtxt.getAxisService() != null ? !msgCtxt.isEngaged(new QName("addressing")) : !ac.isEngaged(new QName("addressing"))) {
                throw new AxisFault(Messages.getMessage("2channelNeedAddressing"));
            }
        }
        return transportIn;
    }
}

