/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService2OM;
import org.apache.axis2.description.AxisService2WSDL2;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DefaultObjectSupplier;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.http.server.HttpUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.java2wsdl.SchemaGenerator;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JMethod;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AxisService
extends AxisDescription {
    private int nsCount = 0;
    private static final Log log = LogFactory.getLog((Class)AxisService.class);
    private URL fileName;
    private HashMap operationsAliasesMap = null;
    private ArrayList moduleRefs = null;
    private ArrayList engagedModules = null;
    private String serviceDescription;
    private long lastupdate;
    private HashMap moduleConfigmap;
    private String name;
    private ClassLoader serviceClassLoader;
    private ArrayList schemaList;
    private boolean wsdlFound = false;
    private String scope = "request";
    private HashMap messageReceivers;
    private boolean useDefaultChains = true;
    private boolean active = true;
    private boolean elementFormDefault = true;
    private String targetNamespace = "http://ws.apache.org/axis2";
    private String targetNamespacePrefix = "tns";
    private String schematargetNamespace;
    private String schematargetNamespacePrefix = "ns";
    private boolean enableAllTransports = true;
    private List exposedTransports = new ArrayList();
    private ServiceLifeCycle serviceLifeCycle;
    private boolean schemaLocationsAdjusted = false;
    private Map schemaMappingTable = null;
    private int count = 0;
    private String customSchemaNamePrefix = null;
    private String customSchemaNameSuffix = null;
    private NamespaceMap nameSpacesMap;
    private String soapNsUri;
    private String endpoint;
    private String wsaddressingFlag = "unspecified";
    private boolean clientSide = false;
    private ObjectSupplier objectSupplier;
    private Map p2nMap;
    private TypeTable typeTable;
    private String bindingName;
    private String portTypeName;

    public String getWSAddressingFlag() {
        return this.wsaddressingFlag;
    }

    public void setWSAddressingFlag(String ar) {
        this.wsaddressingFlag = ar;
        if (this.wsaddressingFlag == null) {
            this.wsaddressingFlag = "unspecified";
        }
    }

    public boolean isSchemaLocationsAdjusted() {
        return this.schemaLocationsAdjusted;
    }

    public void setSchemaLocationsAdjusted(boolean schemaLocationsAdjusted) {
        this.schemaLocationsAdjusted = schemaLocationsAdjusted;
    }

    public Map getSchemaMappingTable() {
        return this.schemaMappingTable;
    }

    public void setSchemaMappingTable(Map schemaMappingTable) {
        this.schemaMappingTable = schemaMappingTable;
    }

    public String getCustomSchemaNamePrefix() {
        return this.customSchemaNamePrefix;
    }

    public void setCustomSchemaNamePrefix(String customSchemaNamePrefix) {
        this.customSchemaNamePrefix = customSchemaNamePrefix;
    }

    public String getCustomSchemaNameSuffix() {
        return this.customSchemaNameSuffix;
    }

    public void setCustomSchemaNameSuffix(String customSchemaNameSuffix) {
        this.customSchemaNameSuffix = customSchemaNameSuffix;
    }

    public AxisService() {
        this.operationsAliasesMap = new HashMap();
        this.moduleConfigmap = new HashMap();
        this.messageReceivers = new HashMap();
        this.moduleRefs = new ArrayList();
        this.engagedModules = new ArrayList();
        this.schemaList = new ArrayList();
        this.serviceClassLoader = Thread.currentThread().getContextClassLoader();
        this.objectSupplier = new DefaultObjectSupplier();
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getSoapNsUri() {
        return this.soapNsUri;
    }

    public void setSoapNsUri(String soapNsUri) {
        this.soapNsUri = soapNsUri;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public AxisService(String name) {
        this();
        this.name = name;
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return (MessageReceiver)this.messageReceivers.get(mepURL);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addModuleOperations(AxisModule module, AxisConfiguration axisConfig) throws AxisFault {
        HashMap map = module.getOperations();
        Collection col = map.values();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = this.copyOperation((AxisOperation)iterator.next());
            if (this.getOperation(axisOperation.getName()) != null) continue;
            ArrayList wsamappings = axisOperation.getWsamappingList();
            if (wsamappings != null) {
                int size = wsamappings.size();
                for (int j = 0; j < size; ++j) {
                    String mapping = (String)wsamappings.get(j);
                    this.mapActionToOperation(mapping, axisOperation);
                }
            }
            axisOperation.setControlOperation(true);
            this.addOperation(axisOperation);
        }
    }

    public void addModuleref(QName moduleref) {
        this.moduleRefs.add(moduleref);
    }

    public void addOperation(AxisOperation axisOperation) {
        ArrayList wsamappings;
        axisOperation.setParent(this);
        Iterator modules = this.getEngagedModules().iterator();
        while (modules.hasNext()) {
            AxisModule module = (AxisModule)modules.next();
            AxisServiceGroup parent = (AxisServiceGroup)this.getParent();
            AxisConfiguration axisConfig = null;
            if (parent != null) {
                axisConfig = (AxisConfiguration)parent.getParent();
            }
            try {
                Module moduleImpl = module.getModule();
                if (moduleImpl != null) {
                    moduleImpl.engageNotify(axisOperation);
                }
                axisOperation.engageModule(module, axisConfig);
            }
            catch (AxisFault axisFault) {
                log.info((Object)Messages.getMessage("modulealredyengagetoservice", module.getName().getLocalPart()));
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
        if (axisOperation.getSoapAction() == null) {
            axisOperation.setSoapAction("urn:" + axisOperation.getName().getLocalPart());
        }
        this.addChild(axisOperation);
        String operationName = axisOperation.getName().getLocalPart();
        Iterator axisMessageIter = axisOperation.getChildren();
        while (axisMessageIter.hasNext()) {
            AxisMessage axisMessage = (AxisMessage)axisMessageIter.next();
            String messageName = axisMessage.getName();
            if (messageName == null || messageName.equals(operationName)) continue;
            this.mapActionToOperation(messageName, axisOperation);
        }
        this.mapActionToOperation(operationName, axisOperation);
        String action = axisOperation.getSoapAction();
        if (action.length() > 0) {
            this.mapActionToOperation(action, axisOperation);
        }
        if ((wsamappings = axisOperation.getWsamappingList()) != null) {
            int size = wsamappings.size();
            for (int j = 0; j < size; ++j) {
                String mapping = (String)wsamappings.get(j);
                this.mapActionToOperation(mapping, axisOperation);
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
    }

    private MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/2004/08/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        if (this.getParent() != null && this.getParent().getParent() != null) {
            return ((AxisConfiguration)this.getParent().getParent()).getMessageReceiver(mepURL);
        }
        return null;
    }

    private AxisOperation copyOperation(AxisOperation axisOperation) throws AxisFault {
        AxisOperation operation = AxisOperationFactory.getOperationDescription(axisOperation.getMessageExchangePattern());
        operation.setMessageReceiver(axisOperation.getMessageReceiver());
        operation.setName(axisOperation.getName());
        Iterator parameters = axisOperation.getParameters().iterator();
        while (parameters.hasNext()) {
            Parameter parameter = (Parameter)parameters.next();
            operation.addParameter(parameter);
        }
        operation.setWsamappingList(axisOperation.getWsamappingList());
        operation.setRemainingPhasesInFlow(axisOperation.getRemainingPhasesInFlow());
        operation.setPhasesInFaultFlow(axisOperation.getPhasesInFaultFlow());
        operation.setPhasesOutFaultFlow(axisOperation.getPhasesOutFaultFlow());
        operation.setPhasesOutFlow(axisOperation.getPhasesOutFlow());
        operation.setOutputAction(axisOperation.getOutputAction());
        String[] faultActionNames = axisOperation.getFaultActionNames();
        for (int i = 0; i < faultActionNames.length; ++i) {
            operation.addFaultAction(faultActionNames[i], axisOperation.getFaultAction(faultActionNames[i]));
        }
        return operation;
    }

    public void engageModule(AxisModule axisModule, AxisConfiguration axisConfig) throws AxisFault {
        if (axisModule == null) {
            throw new AxisFault(Messages.getMessage("modulenf"));
        }
        Iterator itr_engageModules = this.engagedModules.iterator();
        QName moduleName = axisModule.getName();
        while (itr_engageModules.hasNext()) {
            AxisModule module = (AxisModule)itr_engageModules.next();
            QName modu = module.getName();
            boolean isEngagable = Utils.checkVersion(moduleName, modu);
            if (isEngagable) continue;
            return;
        }
        Module moduleImpl = axisModule.getModule();
        if (moduleImpl != null) {
            moduleImpl.engageNotify(this);
        }
        this.addModuleOperations(axisModule, axisConfig);
        Iterator operations = this.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            if (moduleImpl != null) {
                moduleImpl.engageNotify(axisOperation);
            }
            axisOperation.engageModule(axisModule, axisConfig);
        }
        this.engagedModules.add(axisModule);
    }

    public void mapActionToOperation(String action, AxisOperation axisOperation) {
        this.operationsAliasesMap.put(action, axisOperation);
    }

    public void printSchema(OutputStream out) throws AxisFault {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchema schema = this.addNameSpaces(i);
            schema.write(out);
        }
    }

    public XmlSchema getSchema(int index) {
        return this.addNameSpaces(index);
    }

    private XmlSchema addNameSpaces(int i) {
        XmlSchema schema = (XmlSchema)this.schemaList.get(i);
        NamespaceMap map = (NamespaceMap)this.nameSpacesMap.clone();
        NamespacePrefixList namespaceContext = schema.getNamespaceContext();
        String[] prefixes = namespaceContext.getDeclaredPrefixes();
        for (int j = 0; j < prefixes.length; ++j) {
            String prefix = prefixes[j];
            map.add(prefix, namespaceContext.getNamespaceURI(prefix));
        }
        schema.setNamespaceContext((NamespacePrefixList)map);
        return schema;
    }

    public AxisConfiguration getAxisConfiguration() {
        if (this.getParent() != null) {
            return (AxisConfiguration)this.getParent().getParent();
        }
        return null;
    }

    public void printWSDL(OutputStream out, String requestIP, String servicePath) throws AxisFault {
        if (this.isUseUserWSDL()) {
            Parameter wsld4jdefinition = this.getParameter("wsdl4jDefinition");
            if (wsld4jdefinition != null) {
                try {
                    Definition definition = (Definition)wsld4jdefinition.getValue();
                    this.setPortAddress(definition);
                    WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                    writer.writeWSDL(definition, out);
                }
                catch (WSDLException e) {
                    throw new AxisFault(e);
                }
            } else {
                this.printWSDLError(out);
            }
        } else {
            String[] eprArray = this.getEPRs(requestIP);
            this.getWSDL(out, eprArray, servicePath);
        }
    }

    public String[] getEPRs() throws AxisFault {
        String requestIP;
        try {
            requestIP = HttpUtils.getIpAddress();
        }
        catch (SocketException e) {
            throw new AxisFault("Cannot get local IP address", e);
        }
        return this.getEPRs(requestIP);
    }

    private String[] getEPRs(String requestIP) throws AxisFault {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        ArrayList<String> eprList = new ArrayList<String>();
        if (this.enableAllTransports) {
            Iterator transports = axisConfig.getTransportsIn().values().iterator();
            while (transports.hasNext()) {
                TransportInDescription transportIn = (TransportInDescription)transports.next();
                TransportListener listener = transportIn.getReceiver();
                if (listener == null) continue;
                try {
                    EndpointReference[] eprsForService = listener.getEPRsForService(this.name, requestIP);
                    if (eprsForService == null) continue;
                    for (int i = 0; i < eprsForService.length; ++i) {
                        EndpointReference endpointReference = eprsForService[i];
                        String address = endpointReference.getAddress();
                        if (address == null) continue;
                        eprList.add(address);
                    }
                }
                catch (AxisFault axisFault) {
                    log.warn((Object)axisFault.getMessage());
                }
            }
        } else {
            List trs = this.exposedTransports;
            for (int i = 0; i < trs.size(); ++i) {
                TransportListener listener;
                String trsName = (String)trs.get(i);
                TransportInDescription transportIn = axisConfig.getTransportIn(new QName(trsName));
                if (transportIn == null || (listener = transportIn.getReceiver()) == null) continue;
                try {
                    EndpointReference[] eprsForService = listener.getEPRsForService(this.name, requestIP);
                    if (eprsForService == null) continue;
                    for (int j = 0; j < eprsForService.length; ++j) {
                        EndpointReference endpointReference = eprsForService[j];
                        String address = endpointReference.getAddress();
                        if (address == null) continue;
                        eprList.add(address);
                    }
                    continue;
                }
                catch (AxisFault axisFault) {
                    log.warn((Object)axisFault.getMessage());
                }
            }
        }
        return eprList.toArray(new String[eprList.size()]);
    }

    public void printWSDL(OutputStream out, String requestIP) throws AxisFault {
        this.printWSDL(out, requestIP, "services");
    }

    public void printWSDL(OutputStream out) throws AxisFault {
        if (this.isUseUserWSDL()) {
            Parameter wsld4jdefinition = this.getParameter("wsdl4jDefinition");
            if (wsld4jdefinition != null) {
                try {
                    Definition definition = (Definition)wsld4jdefinition.getValue();
                    this.setPortAddress(definition);
                    WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                    writer.writeWSDL(definition, out);
                }
                catch (WSDLException e) {
                    throw new AxisFault(e);
                }
            } else {
                this.printWSDLError(out);
            }
        } else {
            this.setWsdlFound(true);
            this.getWSDL(out, new String[]{this.endpoint}, "services");
        }
    }

    private void setPortAddress(Definition definition) throws AxisFault {
        Iterator serviceItr = definition.getServices().values().iterator();
        while (serviceItr.hasNext()) {
            Service serviceElement = (Service)serviceItr.next();
            Iterator portItr = serviceElement.getPorts().values().iterator();
            while (portItr.hasNext()) {
                Port port = (Port)portItr.next();
                List list = port.getExtensibilityElements();
                for (int i = 0; i < list.size(); ++i) {
                    Object extensibilityEle = list.get(i);
                    if (!(extensibilityEle instanceof SOAPAddress)) continue;
                    ((SOAPAddress)extensibilityEle).setLocationURI(this.getEPRs()[0]);
                }
            }
        }
    }

    private void getWSDL(OutputStream out, String[] serviceURL, String servicePath) throws AxisFault {
        if (this.wsdlFound) {
            AxisService2OM axisService2WOM = new AxisService2OM(this, serviceURL, "document", "literal", servicePath);
            try {
                OMElement wsdlElement = axisService2WOM.generateOM();
                wsdlElement.serialize(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            this.printWSDLError(out);
        }
    }

    private void printWSDLError(OutputStream out) throws AxisFault {
        try {
            String wsdlntfound = "<error><description>Unable to generate WSDL for this service</description><reason>If you wish Axis2 to automatically generate the WSDL, then please use one of the RPC message receivers for the service(s)/operation(s) in services.xml. If you have added a custom WSDL in the META-INF directory, then please make sure that the name of the service in services.xml (/serviceGroup/service/@name) is the same as in the custom wsdl's service name (/wsdl:definitions/wsdl:service/@name). </reason></error>";
            out.write(wsdlntfound.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new AxisFault(e);
        }
    }

    public void printWSDL2(OutputStream out) throws AxisFault {
        if (this.isUseUserWSDL()) {
            Parameter wsld4jdefinition = this.getParameter("wsdl4jDefinition");
            if (wsld4jdefinition != null) {
                try {
                    String error = "<error><description>Unable to showtwo will WSDL for this service</description><reason>WSDL 2.0 document is to be shown. But we do not support WSDL 2.0serialization yet.</reason></error>";
                    out.write(error.getBytes());
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    throw new AxisFault(e);
                }
            } else {
                this.printWSDLError(out);
            }
        } else {
            this.setWsdlFound(true);
            this.getWSDL2(out, new String[]{this.endpoint});
        }
    }

    public void printWSDL2(OutputStream out, String requestIP, String servicePath) throws AxisFault {
        this.getWSDL2(out, this.getEPRs());
    }

    private void getWSDL2(OutputStream out, String[] serviceURL) throws AxisFault {
        if (this.wsdlFound) {
            AxisService2WSDL2 axisService2WSDL2 = new AxisService2WSDL2(this, serviceURL);
            try {
                OMElement wsdlElement = axisService2WSDL2.generateOM();
                wsdlElement.serialize(out);
                out.flush();
                out.close();
            }
            catch (Exception e) {
                throw new AxisFault(e);
            }
        } else {
            this.printWSDLError(out);
        }
    }

    public String getServiceDescription() {
        return this.serviceDescription;
    }

    public ClassLoader getClassLoader() {
        return this.serviceClassLoader;
    }

    public ArrayList getControlOperations() {
        Iterator op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (!operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public Collection getEngagedModules() {
        return this.engagedModules;
    }

    public URL getFileName() {
        return this.fileName;
    }

    public long getLastupdate() {
        return this.lastupdate;
    }

    public ModuleConfiguration getModuleConfig(QName moduleName) {
        return (ModuleConfiguration)this.moduleConfigmap.get(moduleName);
    }

    public ArrayList getModules() {
        return this.moduleRefs;
    }

    public String getName() {
        return this.name;
    }

    public AxisOperation getOperation(QName operationName) {
        AxisOperation axisOperation = (AxisOperation)this.getChild(operationName);
        if (axisOperation == null) {
            axisOperation = (AxisOperation)this.operationsAliasesMap.get(operationName.getLocalPart());
        }
        return axisOperation;
    }

    public AxisOperation getOperationByAction(String action) {
        return (AxisOperation)this.operationsAliasesMap.get(action);
    }

    public AxisOperation getOperationBySOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            return null;
        }
        AxisOperation operation = (AxisOperation)this.getChild(new QName(soapAction));
        if (operation != null) {
            return operation;
        }
        operation = (AxisOperation)this.operationsAliasesMap.get(soapAction);
        return operation;
    }

    public Iterator getOperations() {
        return this.getChildren();
    }

    public ArrayList getPublishedOperations() {
        Iterator op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = (AxisOperation)op_itr.next();
            if (operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public void setServiceDescription(String serviceDescription) {
        this.serviceDescription = serviceDescription;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setFileName(URL fileName) {
        this.fileName = fileName;
    }

    public void setLastupdate() {
        this.lastupdate = new Date().getTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getSchema() {
        return this.schemaList;
    }

    public void addSchema(XmlSchema schema) {
        if (schema != null) {
            this.schemaList.add(schema);
            if (schema.getTargetNamespace() != null) {
                this.addSchemaNameSpace(schema);
            }
        }
    }

    public void addSchema(Collection schemas) {
        Iterator iterator = schemas.iterator();
        while (iterator.hasNext()) {
            XmlSchema schema = (XmlSchema)iterator.next();
            this.schemaList.add(schema);
            this.addSchemaNameSpace(schema);
        }
    }

    public boolean isWsdlFound() {
        return this.wsdlFound;
    }

    public void setWsdlFound(boolean wsdlFound) {
        this.wsdlFound = wsdlFound;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if ("application".equals(scope) || "transportsession".equals(scope) || "soapsession".equals(scope) || "request".equals(scope)) {
            this.scope = scope;
        }
    }

    public boolean isUseDefaultChains() {
        return this.useDefaultChains;
    }

    public void setUseDefaultChains(boolean useDefaultChains) {
        this.useDefaultChains = useDefaultChains;
    }

    public Object getKey() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSchematargetNamespace() {
        return this.schematargetNamespace;
    }

    public void setSchematargetNamespace(String schematargetNamespace) {
        this.schematargetNamespace = schematargetNamespace;
    }

    public String getSchematargetNamespacePrefix() {
        return this.schematargetNamespacePrefix;
    }

    public void setSchematargetNamespacePrefix(String schematargetNamespacePrefix) {
        this.schematargetNamespacePrefix = schematargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public XmlSchemaElement getSchemaElement(QName elementQName) {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchemaElement element;
            XmlSchema schema = (XmlSchema)this.schemaList.get(i);
            if (schema == null || (element = schema.getElementByName(elementQName)) == null) continue;
            return element;
        }
        return null;
    }

    public boolean isEnableAllTransports() {
        return this.enableAllTransports;
    }

    public void setEnableAllTransports(boolean enableAllTransports) {
        this.enableAllTransports = enableAllTransports;
    }

    public List getExposedTransports() {
        return this.exposedTransports;
    }

    public void setExposedTransports(List transports) {
        this.enableAllTransports = false;
        this.exposedTransports = transports;
    }

    public void addExposedTransport(String transport) {
        this.enableAllTransports = false;
        if (!this.exposedTransports.contains(transport)) {
            this.exposedTransports.add(transport);
        }
    }

    public void removeExposedTransport(String transport) {
        this.enableAllTransports = false;
        this.exposedTransports.remove(transport);
    }

    public boolean isExposedTransport(String transport) {
        return this.exposedTransports.contains(transport);
    }

    public void disengageModule(AxisModule module) {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (axisConfig != null) {
            PhaseResolver phaseResolver = new PhaseResolver(axisConfig);
            if (axisConfig.isEngaged(module.getName())) {
                this.removeModuleOperations(module);
                Iterator operations = this.getChildren();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    phaseResolver.disengageModuleFromOperationChain(module, axisOperation);
                    axisOperation.removeFromEngagedModuleList(module);
                }
            } else if (this.isEngaged(module.getName())) {
                phaseResolver.disengageModuleFromGlobalChains(module);
                this.removeModuleOperations(module);
                Iterator operations = this.getChildren();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    phaseResolver.disengageModuleFromOperationChain(module, axisOperation);
                    axisOperation.removeFromEngagedModuleList(module);
                }
            }
        }
        this.engagedModules.remove(module);
    }

    private void removeModuleOperations(AxisModule module) {
        HashMap moduleOerations = module.getOperations();
        if (moduleOerations != null) {
            Iterator moduleOperations_itr = moduleOerations.values().iterator();
            while (moduleOperations_itr.hasNext()) {
                AxisOperation operation = (AxisOperation)moduleOperations_itr.next();
                this.removeOperation(operation.getName());
            }
        }
    }

    public boolean isEngaged(QName moduleName) {
        AxisModule module = this.getAxisConfiguration().getModule(moduleName);
        if (module == null) {
            return false;
        }
        Iterator engagedModuleItr = this.engagedModules.iterator();
        while (engagedModuleItr.hasNext()) {
            AxisModule axisModule = (AxisModule)engagedModuleItr.next();
            if (!axisModule.getName().getLocalPart().equals(module.getName().getLocalPart())) continue;
            return true;
        }
        return false;
    }

    public static AxisService createClientSideAxisService(URL wsdlURL, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        try {
            InputStream in = wsdlURL.openConnection().getInputStream();
            Document doc = XMLUtils.newDocument(in);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefinition = reader.readWSDL(null, doc);
            return AxisService.createClientSideAxisService(wsdlDefinition, wsdlServiceName, portName, options);
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new AxisFault("IOException : " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e);
            throw new AxisFault("ParserConfigurationException : " + e.getMessage());
        }
        catch (SAXException e) {
            log.error((Object)e);
            throw new AxisFault("SAXException : " + e.getMessage());
        }
        catch (WSDLException e) {
            log.error((Object)e);
            throw new AxisFault("WSDLException : " + e.getMessage());
        }
    }

    public static AxisService createClientSideAxisService(Definition wsdlDefinition, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(wsdlDefinition, wsdlServiceName, portName);
        serviceBuilder.setServerSide(false);
        AxisService axisService = serviceBuilder.populateService();
        options.setTo(new EndpointReference(axisService.getEndpoint()));
        options.setSoapVersionURI(axisService.getSoapNsUri());
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig, Class messageReceiverClass) throws AxisFault {
        return AxisService.createService(implClass, axisConfig, messageReceiverClass, null, null);
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfiguration, Map messageReceiverClassMap, String targetNamespace, String schemaNamespace) throws AxisFault {
        SchemaGenerator schemaGenerator;
        int index;
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = org.apache.axis2.deployment.util.Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        if (schemaNamespace == null) {
            schemaNamespace = axisService.getSchematargetNamespace();
        }
        String serviceName = (index = implClass.lastIndexOf(".")) > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(axisConfiguration.getServiceClassLoader());
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        ArrayList<String> excludeOpeartion = new ArrayList<String>();
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        try {
            schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, schemaNamespace, axisService.getSchematargetNamespacePrefix());
            schemaGenerator.setElementFormDefault("unqualified");
            axisService.setElementFormDefault(false);
            excludeOpeartion.add("init");
            excludeOpeartion.add("setOperationContext");
            excludeOpeartion.add("destroy");
            excludeOpeartion.add("startUp");
            schemaGenerator.setExcludeMethods(excludeOpeartion);
            axisService.addSchema(schemaGenerator.generateSchema());
            axisService.setSchematargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
            axisService.setTypeTable(schemaGenerator.getTypeTable());
            if (targetNamespace == null) {
                targetNamespace = schemaGenerator.getSchemaTargetNameSpace();
            }
            if (targetNamespace != null && !"".equals(targetNamespace)) {
                axisService.setTargetNamespace(targetNamespace);
            }
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfiguration.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            MessageReceiver mr;
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || excludeOpeartion.contains(jmethod.getSimpleName())) continue;
            AxisOperation operation = org.apache.axis2.deployment.util.Utils.getAxisOperationforJmethod(jmethod, table);
            String mep = operation.getMessageExchangePattern();
            if (messageReceiverClassMap != null) {
                if (messageReceiverClassMap.get(mep) != null) {
                    Object obj = messageReceiverClassMap.get(mep);
                    if (obj instanceof MessageReceiver) {
                        mr = (MessageReceiver)obj;
                        operation.setMessageReceiver(mr);
                    } else {
                        log.error((Object)"Object is not an instance of MessageReceiver, thus, default MessageReceiver has been set");
                        mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                        operation.setMessageReceiver(mr);
                    }
                } else {
                    log.error((Object)"Required MessageReceiver couldn't be found, thus, default MessageReceiver has been used");
                    mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
            } else {
                log.error((Object)"MessageRecevierClassMap couldn't be found, thus, default MessageReceiver has been used");
                mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig, Class messageReceiverClass, String targetNameSpace, String schemaNameSpace) throws AxisFault {
        SchemaGenerator schemaGenerator;
        int index;
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = org.apache.axis2.deployment.util.Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        AxisService axisService = new AxisService();
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        if (schemaNameSpace == null) {
            schemaNameSpace = axisService.getSchematargetNamespace();
        }
        String serviceName = (index = implClass.lastIndexOf(".")) > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        axisService.setName(serviceName);
        axisService.setClassLoader(axisConfig.getServiceClassLoader());
        ClassLoader serviceClassLoader = axisService.getClassLoader();
        ArrayList<String> excludeOpeartion = new ArrayList<String>();
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNameSpacesMap(map);
        try {
            schemaGenerator = new SchemaGenerator(serviceClassLoader, implClass, schemaNameSpace, axisService.getSchematargetNamespacePrefix());
            schemaGenerator.setElementFormDefault("unqualified");
            axisService.setElementFormDefault(false);
            excludeOpeartion.add("init");
            excludeOpeartion.add("setOperationContext");
            excludeOpeartion.add("destroy");
            excludeOpeartion.add("startUp");
            schemaGenerator.setExcludeMethods(excludeOpeartion);
            axisService.addSchema(schemaGenerator.generateSchema());
            axisService.setSchematargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
            axisService.setTypeTable(schemaGenerator.getTypeTable());
            if (targetNameSpace == null) {
                targetNameSpace = schemaGenerator.getSchemaTargetNameSpace();
            }
            if (targetNameSpace != null && !"".equals(targetNameSpace)) {
                axisService.setTargetNamespace(targetNameSpace);
            }
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
        JMethod[] method = schemaGenerator.getMethods();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            JMethod jmethod = method[i];
            if (!jmethod.isPublic() || excludeOpeartion.contains(jmethod.getSimpleName())) continue;
            AxisOperation operation = org.apache.axis2.deployment.util.Utils.getAxisOperationforJmethod(jmethod, table);
            try {
                MessageReceiver messageReceiver = (MessageReceiver)messageReceiverClass.newInstance();
                operation.setMessageReceiver(messageReceiver);
            }
            catch (IllegalAccessException e) {
                throw new AxisFault("IllegalAccessException occurred during message receiver loading" + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new AxisFault("InstantiationException occurred during message receiver loading" + e.getMessage());
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig) throws AxisFault {
        Class clazz;
        try {
            clazz = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault("ClassNotFoundException occured during message receiver loading" + e.getMessage());
        }
        return AxisService.createService(implClass, axisConfig, clazz);
    }

    public void removeOperation(QName opName) {
        AxisOperation operation = this.getOperation(opName);
        if (operation != null) {
            this.removeChild(opName);
            ArrayList mappingList = operation.getWsamappingList();
            if (mappingList != null) {
                for (int i = 0; i < mappingList.size(); ++i) {
                    String actionMapping = (String)mappingList.get(i);
                    this.operationsAliasesMap.remove(actionMapping);
                }
            }
            this.operationsAliasesMap.remove(operation.getName().getLocalPart());
        }
    }

    public Map getNameSpacesMap() {
        return this.nameSpacesMap;
    }

    public void setNameSpacesMap(NamespaceMap nameSpacesMap) {
        this.nameSpacesMap = nameSpacesMap;
    }

    private void addSchemaNameSpace(XmlSchema schema) {
        String targetNameSpace = schema.getTargetNamespace();
        String prefix = schema.getNamespaceContext().getPrefix(targetNameSpace);
        boolean found = false;
        if (this.nameSpacesMap != null && this.nameSpacesMap.size() > 0) {
            Iterator itr = this.nameSpacesMap.values().iterator();
            Set keys = this.nameSpacesMap.keySet();
            while (itr.hasNext()) {
                String value = (String)itr.next();
                if (!value.equals(targetNameSpace) || !keys.contains(prefix)) continue;
                found = true;
            }
        }
        if (this.nameSpacesMap == null) {
            this.nameSpacesMap = new NamespaceMap();
        }
        if (!found) {
            this.nameSpacesMap.put((Object)("ns" + this.nsCount), (Object)targetNameSpace);
            ++this.nsCount;
        }
    }

    public void populateSchemaMappings() {
        ArrayList schema = this.schemaList;
        if (!this.schemaLocationsAdjusted) {
            Hashtable nameTable = new Hashtable();
            this.calcualteSchemaNames(schema, nameTable);
            this.adjustSchemaNames(schema, nameTable);
            this.setSchemaMappingTable(this.swapMappingTable(nameTable));
            this.setSchemaLocationsAdjusted(true);
        }
    }

    private void calcualteSchemaNames(List schemas, Hashtable nameTable) {
        for (int i = 0; i < schemas.size(); ++i) {
            XmlSchema schema = (XmlSchema)schemas.get(i);
            XmlSchemaObjectCollection includes = schema.getIncludes();
            for (int j = 0; j < includes.getCount(); ++j) {
                XmlSchemaExternal externalSchema;
                XmlSchema s;
                XmlSchemaObject item = includes.getItem(j);
                if (!(item instanceof XmlSchemaExternal) || (s = (externalSchema = (XmlSchemaExternal)item).getSchema()) == null || nameTable.get(s) != null) continue;
                this.insertIntoNameTable(nameTable, s);
                this.calcualteSchemaNames(Arrays.asList(s), nameTable);
            }
        }
    }

    private void insertIntoNameTable(Hashtable nameTable, XmlSchema s) {
        nameTable.put(s, "xsd" + this.count++ + (this.customSchemaNameSuffix != null ? this.customSchemaNameSuffix : ""));
    }

    private void adjustSchemaNames(List schemas, Hashtable nameTable) {
        Hashtable importedSchemas = new Hashtable();
        for (int i = 0; i < schemas.size(); ++i) {
            this.adjustSchemaName((XmlSchema)schemas.get(i), nameTable, importedSchemas);
        }
        Enumeration nameTableKeys = nameTable.keys();
        while (nameTableKeys.hasMoreElements()) {
            this.adjustSchemaName((XmlSchema)nameTableKeys.nextElement(), nameTable, importedSchemas);
        }
    }

    private void adjustSchemaName(XmlSchema parentSchema, Hashtable nameTable, Hashtable importedScheams) {
        XmlSchemaObjectCollection includes = parentSchema.getIncludes();
        for (int j = 0; j < includes.getCount(); ++j) {
            XmlSchemaObject item = includes.getItem(j);
            if (!(item instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal xmlSchemaExternal = (XmlSchemaExternal)item;
            XmlSchema s = xmlSchemaExternal.getSchema();
            this.adjustSchemaLocation(s, xmlSchemaExternal, nameTable, importedScheams);
        }
    }

    private void adjustSchemaLocation(XmlSchema s, XmlSchemaExternal xmlSchemaExternal, Hashtable nameTable, Hashtable importedScheams) {
        if (s != null) {
            String schemaLocation = xmlSchemaExternal.getSchemaLocation();
            if (importedScheams.get(schemaLocation) != null) {
                xmlSchemaExternal.setSchemaLocation((String)importedScheams.get(xmlSchemaExternal.getSchemaLocation()));
            } else {
                String newscheamlocation = this.customSchemaNamePrefix == null ? this.getName() + "?xsd=" + nameTable.get(s) : this.customSchemaNamePrefix + nameTable.get(s);
                xmlSchemaExternal.setSchemaLocation(newscheamlocation);
                importedScheams.put(schemaLocation, newscheamlocation);
            }
        }
    }

    private Map swapMappingTable(Map originalTable) {
        HashMap swappedTable = new HashMap(originalTable.size());
        Iterator keys = originalTable.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            swappedTable.put(originalTable.get(key), key);
        }
        return swappedTable;
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public boolean isElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(boolean elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public boolean isUseUserWSDL() {
        String value;
        Parameter parameter = this.getParameter("useOriginalwsdl");
        return parameter != null && "true".equals(value = (String)parameter.getValue());
    }

    public ServiceLifeCycle getServiceLifeCycle() {
        return this.serviceLifeCycle;
    }

    public void setServiceLifeCycle(ServiceLifeCycle serviceLifeCycle) {
        this.serviceLifeCycle = serviceLifeCycle;
    }

    public Map getP2nMap() {
        return this.p2nMap;
    }

    public void setP2nMap(Map p2nMap) {
        this.p2nMap = p2nMap;
    }

    public ObjectSupplier getObjectSupplier() {
        return this.objectSupplier;
    }

    public void setObjectSupplier(ObjectSupplier objectSupplier) {
        this.objectSupplier = objectSupplier;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public void setTypeTable(TypeTable typeTable) {
        this.typeTable = typeTable;
    }
}

