/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.schema;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.compiler.schema.SchemaVisitor;
import org.apache.avro.compiler.schema.SchemaVisitorAction;
import org.apache.avro.compiler.schema.Schemas;

public final class CloningVisitor
implements SchemaVisitor<Schema> {
    private final IdentityHashMap<Schema, Schema> replace = new IdentityHashMap();
    private final Schema root;
    private final PropertyCopier copyProperties;
    private final boolean copyDocs;

    public CloningVisitor(Schema root) {
        this(new PropertyCopier(){

            @Override
            public void copy(Schema first, Schema second) {
                Schemas.copyLogicalTypes(first, second);
                Schemas.copyAliases(first, second);
            }

            @Override
            public void copy(Schema.Field first, Schema.Field second) {
                Schemas.copyAliases(first, second);
            }
        }, false, root);
    }

    public CloningVisitor(PropertyCopier copyProperties, boolean copyDocs, Schema root) {
        this.copyProperties = copyProperties;
        this.copyDocs = copyDocs;
        this.root = root;
    }

    @Override
    public SchemaVisitorAction visitTerminal(Schema terminal) {
        Schema newSchema;
        Schema.Type type = terminal.getType();
        switch (type) {
            case RECORD: 
            case ARRAY: 
            case MAP: 
            case UNION: {
                if (!this.replace.containsKey(terminal)) {
                    throw new IllegalStateException("Schema " + terminal + " must be already processed");
                }
                return SchemaVisitorAction.CONTINUE;
            }
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case NULL: 
            case STRING: {
                newSchema = Schema.create((Schema.Type)type);
                break;
            }
            case ENUM: {
                newSchema = Schema.createEnum((String)terminal.getName(), (String)(this.copyDocs ? terminal.getDoc() : null), (String)terminal.getNamespace(), (List)terminal.getEnumSymbols());
                break;
            }
            case FIXED: {
                newSchema = Schema.createFixed((String)terminal.getName(), (String)(this.copyDocs ? terminal.getDoc() : null), (String)terminal.getNamespace(), (int)terminal.getFixedSize());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported schema " + terminal);
            }
        }
        this.copyProperties.copy(terminal, newSchema);
        this.replace.put(terminal, newSchema);
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction visitNonTerminal(Schema nt) {
        Schema.Type type = nt.getType();
        if (type == Schema.Type.RECORD) {
            Schema newSchema = Schema.createRecord((String)nt.getName(), (String)(this.copyDocs ? nt.getDoc() : null), (String)nt.getNamespace(), (boolean)nt.isError());
            this.copyProperties.copy(nt, newSchema);
            this.replace.put(nt, newSchema);
        }
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public SchemaVisitorAction afterVisitNonTerminal(Schema nt) {
        Schema newSchema;
        Schema.Type type = nt.getType();
        switch (type) {
            case RECORD: {
                Schema newSchema2 = this.replace.get(nt);
                List fields = nt.getFields();
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>(fields.size());
                for (Schema.Field field : fields) {
                    Schema.Field newField = new Schema.Field(field.name(), this.replace.get(field.schema()), this.copyDocs ? field.doc() : null, field.defaultVal(), field.order());
                    this.copyProperties.copy(field, newField);
                    newFields.add(newField);
                }
                newSchema2.setFields(newFields);
                return SchemaVisitorAction.CONTINUE;
            }
            case UNION: {
                List types = nt.getTypes();
                ArrayList<Schema> newTypes = new ArrayList<Schema>(types.size());
                for (Schema sch : types) {
                    newTypes.add(this.replace.get(sch));
                }
                newSchema = Schema.createUnion(newTypes);
                break;
            }
            case ARRAY: {
                newSchema = Schema.createArray((Schema)this.replace.get(nt.getElementType()));
                break;
            }
            case MAP: {
                newSchema = Schema.createMap((Schema)this.replace.get(nt.getValueType()));
                break;
            }
            default: {
                throw new IllegalStateException("Illegal type " + type + ", schema " + nt);
            }
        }
        this.copyProperties.copy(nt, newSchema);
        this.replace.put(nt, newSchema);
        return SchemaVisitorAction.CONTINUE;
    }

    @Override
    public Schema get() {
        return this.replace.get(this.root);
    }

    public String toString() {
        return "CloningVisitor{replace=" + this.replace + ", root=" + this.root + '}';
    }

    public static interface PropertyCopier {
        public void copy(Schema var1, Schema var2);

        public void copy(Schema.Field var1, Schema.Field var2);
    }
}

