/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.TreeMap;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.schema.core.DtoNetworkConnector;
import org.apache.activemq.util.IntrospectionSupport;

public class NetworkConnectorProcessor
extends DefaultConfigurationProcessor {
    public NetworkConnectorProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void addNew(Object o) {
        DtoNetworkConnector networkConnector = (DtoNetworkConnector)o;
        if (networkConnector.getUri() != null) {
            try {
                DiscoveryNetworkConnector nc = this.fromDto(networkConnector, new DiscoveryNetworkConnector());
                this.plugin.getBrokerService().addNetworkConnector((NetworkConnector)nc);
                this.plugin.getBrokerService().startNetworkConnector((NetworkConnector)nc, null);
                this.plugin.info("started new network connector: " + nc);
            }
            catch (Exception e) {
                this.plugin.info("Failed to add new networkConnector " + networkConnector, e);
            }
        }
    }

    @Override
    public void remove(Object o) {
        DtoNetworkConnector toRemove = (DtoNetworkConnector)o;
        for (NetworkConnector existingCandidate : this.plugin.getBrokerService().getNetworkConnectors()) {
            if (!this.configMatch(toRemove, existingCandidate) || !this.plugin.getBrokerService().removeNetworkConnector(existingCandidate)) continue;
            try {
                existingCandidate.stop();
                this.plugin.info("stopped and removed networkConnector: " + existingCandidate);
            }
            catch (Exception e) {
                this.plugin.info("Failed to stop removed network connector: " + existingCandidate);
            }
        }
    }

    private boolean configMatch(DtoNetworkConnector dto, NetworkConnector candidate) {
        TreeMap dtoProps = new TreeMap();
        IntrospectionSupport.getProperties((Object)dto, dtoProps, null);
        TreeMap candidateProps = new TreeMap();
        IntrospectionSupport.getProperties((Object)candidate, candidateProps, null);
        for (String key : dtoProps.keySet()) {
            if (candidateProps.containsKey(key) && ((String)candidateProps.get(key)).equals(dtoProps.get(key))) continue;
            return false;
        }
        return true;
    }
}

