/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.util.URIUtil;

public final class RedirectUtil {
    public static String toRedirectURL(HttpServletRequest request, String location) {
        if (!URIUtil.hasScheme(location)) {
            StringBuilder url = new StringBuilder(128);
            URIUtil.appendSchemeHostPort(url, request.getScheme(), request.getServerName(), request.getServerPort());
            if (location.startsWith("/")) {
                location = URIUtil.canonicalEncodedPath(location);
            } else {
                String path = request.getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath(path);
                location = URIUtil.canonicalPath(URIUtil.addEncodedPaths(parent, location));
                if (!location.startsWith("/")) {
                    url.append('/');
                }
            }
            if (location == null) {
                throw new IllegalStateException("path cannot be above root");
            }
            url.append(location);
            location = url.toString();
        }
        return location;
    }
}

