/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.processor.WrapProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TransactedPolicy;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(label="configuration")
@XmlRootElement(name="transacted")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TransactedDefinition
extends OutputDefinition<TransactedDefinition> {
    @XmlTransient
    public static final String PROPAGATION_REQUIRED = "PROPAGATION_REQUIRED";
    private static final Logger LOG = LoggerFactory.getLogger(TransactedDefinition.class);
    @XmlTransient
    protected Class<? extends Policy> type = TransactedPolicy.class;
    @XmlAttribute
    protected String ref;
    @XmlTransient
    private Policy policy;

    public TransactedDefinition() {
    }

    public TransactedDefinition(Policy policy) {
        this.policy = policy;
    }

    @Override
    public String toString() {
        String desc = this.description();
        if (ObjectHelper.isEmpty(desc)) {
            return "Transacted";
        }
        return "Transacted[" + desc + "]";
    }

    protected String description() {
        if (this.ref != null) {
            return "ref:" + this.ref;
        }
        if (this.policy != null) {
            return this.policy.toString();
        }
        return "";
    }

    @Override
    public String getShortName() {
        return "transacted";
    }

    @Override
    public String getLabel() {
        String desc = this.description();
        if (ObjectHelper.isEmpty(desc)) {
            return "transacted";
        }
        return "transacted[" + desc + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public boolean isWrappingEntireOutput() {
        return true;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setType(Class<? extends Policy> type) {
        this.type = type;
    }

    public TransactedDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Policy policy = this.resolvePolicy(routeContext);
        ObjectHelper.notNull(policy, "policy", this);
        policy.beforeWrap(routeContext, this);
        Processor childProcessor = this.createChildProcessor(routeContext, true);
        Processor target = policy.wrap(routeContext, childProcessor);
        if (!(target instanceof Service)) {
            target = new WrapProcessor(target, childProcessor);
        }
        return target;
    }

    protected Policy resolvePolicy(RouteContext routeContext) {
        if (this.policy != null) {
            return this.policy;
        }
        return TransactedDefinition.doResolvePolicy(routeContext, this.getRef(), this.type);
    }

    protected static Policy doResolvePolicy(RouteContext routeContext, String ref, Class<? extends Policy> type) {
        Class<?> tmClazz;
        Policy found;
        Map<String, ? extends Policy> types;
        if (ObjectHelper.isNotEmpty(ref)) {
            return CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), ref, Policy.class);
        }
        Policy answer = null;
        if (type != null && (types = routeContext.lookupByType(type)).size() == 1 && type.isInstance(found = types.values().iterator().next())) {
            return type.cast(found);
        }
        if (type == TransactedPolicy.class) {
            answer = routeContext.lookup(PROPAGATION_REQUIRED, TransactedPolicy.class);
        }
        if (answer == null && type == TransactedPolicy.class && (tmClazz = routeContext.getCamelContext().getClassResolver().resolveClass("org.springframework.transaction.PlatformTransactionManager")) != null) {
            Map<String, ?> maps = routeContext.lookupByType(tmClazz);
            if (maps.size() == 1) {
                Object transactionManager = maps.values().iterator().next();
                LOG.debug("One instance of PlatformTransactionManager found in registry: {}", transactionManager);
                Class<?> txClazz = routeContext.getCamelContext().getClassResolver().resolveClass("org.apache.camel.spring.spi.SpringTransactionPolicy");
                if (txClazz != null) {
                    Method method;
                    LOG.debug("Creating a new temporary SpringTransactionPolicy using the PlatformTransactionManager: {}", transactionManager);
                    TransactedPolicy txPolicy = ObjectHelper.newInstance(txClazz, TransactedPolicy.class);
                    try {
                        method = txClazz.getMethod("setTransactionManager", tmClazz);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeCamelException("Cannot get method setTransactionManager(PlatformTransactionManager) on class: " + txClazz);
                    }
                    ObjectHelper.invokeMethod(method, txPolicy, transactionManager);
                    return txPolicy;
                }
                throw new RuntimeCamelException("Cannot create a transacted policy as camel-spring.jar is not on the classpath!");
            }
            if (maps.isEmpty()) {
                throw new NoSuchBeanException(null, "PlatformTransactionManager");
            }
            throw new IllegalArgumentException("Found " + maps.size() + " PlatformTransactionManager in registry. Cannot determine which one to use. Please configure a TransactionTemplate on the transacted policy.");
        }
        return answer;
    }
}

