/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.IOException;
import org.apache.activemq.kaha.impl.index.hash.HashEntry;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.kaha.impl.index.hash.HashPage;
import org.apache.activemq.kaha.impl.index.hash.HashPageInfo;

class HashBin {
    private HashIndex hashIndex;
    private int id;
    private int maximumEntries;
    private int size;
    private int numberOfPages = 0;
    private HashPageInfo root = null;
    private HashPageInfo tail = null;

    HashBin(HashIndex hashIndex, int id, int maximumEntries) {
        this.hashIndex = hashIndex;
        this.id = id;
        this.maximumEntries = maximumEntries;
    }

    public String toString() {
        return "HashBin[" + this.getId() + "]";
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof HashBin) {
            HashBin other = (HashBin)o;
            result = other.id == this.id;
        }
        return result;
    }

    public int hashCode() {
        return this.getId();
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    boolean isEmpty() {
        return true;
    }

    int getMaximumEntries() {
        return this.maximumEntries;
    }

    void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    int size() {
        return this.size;
    }

    HashPageInfo addHashPageInfo(long id, int size2) throws IOException {
        HashPageInfo info2 = new HashPageInfo(this.hashIndex);
        info2.setId(id);
        info2.setSize(size2);
        if (this.root == null) {
            this.root = info2;
        } else {
            this.tail.linkAfter(info2);
        }
        this.tail = info2;
        ++this.numberOfPages;
        this.size += size2;
        return info2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashEntry find(HashEntry key) throws IOException {
        HashEntry result = null;
        try {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                HashEntry te = this.getHashEntry(mid);
                int cmp = te.compareTo(key);
                if (cmp == 0) {
                    result = te;
                    break;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        }
        finally {
            this.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(HashEntry newEntry) throws IOException {
        boolean replace = false;
        try {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                HashEntry midVal = this.getHashEntry(mid);
                int cmp = midVal.compareTo(newEntry);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                replace = true;
                midVal.setIndexOffset(newEntry.getIndexOffset());
                break;
            }
            if (!replace) {
                this.addHashEntry(low, newEntry);
                ++this.size;
            }
        }
        finally {
            this.end();
        }
        return replace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashEntry remove(HashEntry entry) throws IOException {
        HashEntry result = null;
        try {
            int low = 0;
            int high = this.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                HashEntry te = this.getHashEntry(mid);
                int cmp = te.compareTo(entry);
                if (cmp == 0) {
                    result = te;
                    this.removeHashEntry(mid);
                    --this.size;
                    break;
                }
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        }
        finally {
            this.end();
        }
        return result;
    }

    private void addHashEntry(int index, HashEntry entry) throws IOException {
        HashPageInfo pageToUse = null;
        int offset = 0;
        if (index >= this.getMaximumBinSize()) {
            while (index >= this.getMaximumBinSize()) {
                HashPage hp = this.hashIndex.createPage(this.id);
                pageToUse = this.addHashPageInfo(hp.getId(), 0);
                pageToUse.setPage(hp);
            }
            offset = 0;
        } else {
            int count = 0;
            int countSoFar = 0;
            int pageNo = 0;
            for (HashPageInfo page = this.root; page != null; page = (HashPageInfo)page.getNext()) {
                pageToUse = page;
                if (index < (count += page.size())) {
                    offset = index - countSoFar;
                    break;
                }
                if (index == count && page.size() + 1 <= this.maximumEntries) {
                    offset = page.size();
                    break;
                }
                countSoFar += page.size();
                ++pageNo;
            }
            while (pageNo >= this.numberOfPages) {
                HashPage hp = this.hashIndex.createPage(this.id);
                pageToUse = this.addHashPageInfo(hp.getId(), 0);
            }
        }
        pageToUse.begin();
        pageToUse.addHashEntry(offset, entry);
        this.doOverFlow(index);
    }

    private HashEntry removeHashEntry(int index) throws IOException {
        HashPageInfo page = this.getRetrievePage(index);
        int offset = this.getRetrieveOffset(index);
        HashEntry result = page.removeHashEntry(offset);
        if (page.isEmpty()) {
            if (this.root.equals(page)) {
                this.root = (HashPageInfo)this.root.getNext();
            }
            if (this.tail.equals(page)) {
                this.tail = (HashPageInfo)page.getPrevious();
            }
            page.unlink();
            --this.numberOfPages;
            this.hashIndex.releasePage(page.getPage());
        }
        this.doUnderFlow(index);
        return result;
    }

    private HashEntry getHashEntry(int index) throws IOException {
        HashPageInfo page = this.getRetrievePage(index);
        page.begin();
        int offset = this.getRetrieveOffset(index);
        HashEntry result = page.getHashEntry(offset);
        return result;
    }

    private int getMaximumBinSize() {
        return this.maximumEntries * this.numberOfPages;
    }

    private HashPageInfo getRetrievePage(int index) throws IOException {
        HashPageInfo result = null;
        int count = 0;
        for (HashPageInfo page = this.root; page != null; page = (HashPageInfo)page.getNext()) {
            result = page;
            if (index < (count += page.size())) break;
        }
        result.begin();
        return result;
    }

    private int getRetrieveOffset(int index) throws IOException {
        int result = 0;
        int count = 0;
        for (HashPageInfo page = this.root; page != null; page = (HashPageInfo)page.getNext()) {
            if (index + 1 <= count + page.size()) {
                result = index - count;
                break;
            }
            count += page.size();
        }
        return result;
    }

    private void doOverFlow(int index) throws IOException {
        HashPageInfo info2 = this.getRetrievePage(index);
        if (info2.size() > this.maximumEntries) {
            info2.begin();
            HashEntry entry = info2.removeHashEntry(info2.size() - 1);
            this.doOverFlow(this.getNextPage(info2), entry);
        }
    }

    private void doOverFlow(HashPageInfo next, HashEntry entry) throws IOException {
        HashPageInfo info2 = null;
        if (next == null) {
            HashPage page = this.hashIndex.createPage(this.id);
            info2 = this.addHashPageInfo(page.getId(), 0);
            info2.setPage(page);
        } else {
            info2 = next;
        }
        info2.begin();
        info2.addHashEntry(0, entry);
        if (info2.size() > this.maximumEntries) {
            HashEntry overflowed = info2.removeHashEntry(info2.size() - 1);
            this.doOverFlow(this.getNextPage(info2), overflowed);
        }
    }

    private HashPageInfo getNextPage(HashPageInfo start2) {
        return (HashPageInfo)start2.getNext();
    }

    private void doUnderFlow(int index) {
    }

    String dump() throws IOException {
        String str = "[" + this.numberOfPages + "]";
        for (HashPageInfo page = this.root; page != null; page = (HashPageInfo)page.getNext()) {
            page.begin();
            str = str + page.dump();
            page.end();
        }
        return str;
    }

    private void end() throws IOException {
        for (HashPageInfo page = this.root; page != null; page = (HashPageInfo)page.getNext()) {
            page.end();
        }
    }
}

