/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.hibernate;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.andromda.metafacades.uml.Role;
import org.andromda.metafacades.uml.Service;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;

public class HibernateUtils {
    private String hibernateVersion;
    private String hibernateXmlPersistence;
    private String hibernateMappingStrategy;

    public Collection<Role> getAllRoles(Collection services) {
        final LinkedHashSet<Role> allRoles = new LinkedHashSet<Role>();
        CollectionUtils.forAllDo((Collection)services, (Closure)new Closure(){

            public void execute(Object object) {
                if (object instanceof Service) {
                    allRoles.addAll(((Service)object).getAllRoles());
                }
            }
        });
        return allRoles;
    }

    public void setHibernateVersion(String hibernateVersion) {
        this.hibernateVersion = hibernateVersion;
    }

    public String getHibernatePackage() {
        return this.isVersion3() || this.isVersion4() ? "org.hibernate" : "net.sf.hibernate";
    }

    public String getHibernateUserTypePackage() {
        return this.isVersion3() || this.isVersion4() ? this.getHibernatePackage() + ".usertype" : this.getHibernatePackage();
    }

    public boolean isVersion2() {
        return HibernateUtils.isVersion2(this.hibernateVersion);
    }

    public boolean isVersion3() {
        return HibernateUtils.isVersion3(this.hibernateVersion);
    }

    public boolean isVersion4() {
        return HibernateUtils.isVersion4(this.hibernateVersion);
    }

    public static boolean isVersion2(String hibernateVersionPropertyValue) {
        boolean version2 = false;
        if (hibernateVersionPropertyValue != null) {
            version2 = hibernateVersionPropertyValue.startsWith("2");
        }
        return version2;
    }

    public static boolean isVersion3(String hibernateVersionPropertyValue) {
        boolean version3 = false;
        if (hibernateVersionPropertyValue != null) {
            version3 = hibernateVersionPropertyValue.startsWith("3");
        }
        return version3;
    }

    public static boolean isVersion4(String hibernateVersionPropertyValue) {
        boolean version4 = false;
        if (hibernateVersionPropertyValue != null) {
            version4 = hibernateVersionPropertyValue.startsWith("4");
        }
        return version4;
    }

    public void setHibernateXMLPersistence(String hibernateXmlPersistence) {
        this.hibernateXmlPersistence = hibernateXmlPersistence;
    }

    public boolean isXmlPersistenceActive() {
        return HibernateUtils.isXmlPersistenceActive(this.hibernateVersion, this.hibernateXmlPersistence);
    }

    public static boolean isXmlPersistenceActive(String hibernateVersionPropertyValue, String hibernateXMLPersistencePropertyValue) {
        return HibernateUtils.isVersion3(hibernateVersionPropertyValue) && "true".equalsIgnoreCase(hibernateXMLPersistencePropertyValue);
    }

    public void setHibernateMappingStrategy(String hibernateMappingStrategy) {
        this.hibernateMappingStrategy = hibernateMappingStrategy;
    }

    public boolean isMapSubclassesInSeparateFile() {
        return HibernateUtils.mapSubclassesInSeparateFile(this.hibernateMappingStrategy);
    }

    public static boolean mapSubclassesInSeparateFile(String hibernateMappingStrategy) {
        return "subclass".equalsIgnoreCase(hibernateMappingStrategy);
    }

    public static String getInheritanceTypeEnum(String hibernateMappingStrategy) {
        String inheritanceType = null;
        inheritanceType = "hierarchy".equalsIgnoreCase(hibernateMappingStrategy) ? "JOINED" : ("concrete".equalsIgnoreCase(hibernateMappingStrategy) ? "TABLE_PER_CLASS" : "SINGLE_TABLE");
        return inheritanceType;
    }
}

