/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation.library;

import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.library.Library;
import org.andromda.core.translation.library.LibraryTranslation;
import org.apache.log4j.Logger;

public class LibraryTranslationFinder {
    private static final Logger logger = Logger.getLogger(LibraryTranslationFinder.class);
    protected static final Map libraryTranslations = new LinkedHashMap();

    protected static Library findLibrary(String libraryName) {
        return (Library)ComponentContainer.instance().findComponentByNamespace(libraryName, Library.class);
    }

    public static LibraryTranslation findLibraryTranslation(String translation) {
        ExceptionUtils.checkEmpty("translation", translation);
        LibraryTranslation libraryTranslation = (LibraryTranslation)libraryTranslations.get(translation);
        if (libraryTranslation == null) {
            char libSeparator = '.';
            int index = translation.indexOf(libSeparator);
            if (index == -1) {
                throw new IllegalArgumentException("libraryTranslation '" + translation + "' must contain the character '" + libSeparator + "' in order to separate the library name from the translation" + " name (must be in the form: <library name>.<translation name>)");
            }
            String libraryName = translation.substring(0, index);
            Library library = LibraryTranslationFinder.findLibrary(libraryName);
            int translationLength = translation.length();
            String translationName = translation.substring(index + 1, translationLength);
            if (library != null && (libraryTranslation = library.getLibraryTranslation(translationName)) == null) {
                logger.error((Object)("ERROR! no translation '" + translationName + "' found within library --> '" + libraryName + '\''));
            }
        }
        return libraryTranslation;
    }
}

