/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation.library;

import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.BasePlugin;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.Translator;
import org.andromda.core.translation.library.LibraryException;
import org.andromda.core.translation.library.LibraryTranslation;

public class Library
extends BasePlugin {
    private final Map<String, LibraryTranslation> libraryTranslations = new LinkedHashMap<String, LibraryTranslation>();

    public void addLibraryTranslation(LibraryTranslation libraryTranslation) {
        ExceptionUtils.checkNull("libraryTranslation", libraryTranslation);
        libraryTranslation.setLibrary(this);
        this.libraryTranslations.put(libraryTranslation.getName(), libraryTranslation);
    }

    public Map<String, LibraryTranslation> getLibraryTranslations() {
        return this.libraryTranslations;
    }

    public LibraryTranslation getLibraryTranslation(String name) {
        ExceptionUtils.checkEmpty("name", name);
        return this.libraryTranslations.get(name);
    }

    public void setTranslator(String translatorClass) {
        try {
            ComponentContainer.instance().registerDefaultComponent(Translator.class, ClassUtils.loadClass(translatorClass));
        }
        catch (Throwable throwable) {
            throw new LibraryException(throwable);
        }
    }

    @Override
    public void populateTemplateContext(Map<String, Object> templateContext) {
        super.populateTemplateContext(templateContext);
    }
}

