/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation.library;

import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.translation.library.LibraryException;
import org.andromda.core.translation.library.Translation;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Fragment {
    private String name;
    private String handlerMethod;
    private Translation translation;
    private Map<String, String> kinds = new LinkedHashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.trimToEmpty((String)name);
    }

    public Map<String, String> getKinds() {
        return this.kinds;
    }

    public String getKind(String name) {
        name = StringUtils.trimToEmpty((String)name);
        ExceptionUtils.checkEmpty("name", name);
        String kind = StringUtils.trimToEmpty((String)this.kinds.get(name));
        if (kind == null) {
            throw new LibraryException("No kind '" + name + "' could be found for the translation fragment '" + this.getName() + "' check the fragment '" + this.getName() + "' in translation template --> '" + this.getTranslation().getLibraryTranslation().getTemplate() + '\'');
        }
        return kind;
    }

    public void addKind(String name, String body) {
        this.kinds.put(StringUtils.trimToEmpty((String)name), body);
    }

    public String getHandlerMethod() {
        return this.handlerMethod;
    }

    public void setHandlerMethod(String handlerMethod) {
        this.handlerMethod = handlerMethod;
    }

    public Translation getTranslation() {
        String methodName = "Fragment.getTranslation";
        if (this.translation == null) {
            throw new LibraryException("Fragment.getTranslation - translation can not be null");
        }
        return this.translation;
    }

    public void setTranslation(Translation translation) {
        this.translation = translation;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

