/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.translation;

import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.translation.TranslatorException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class TranslationUtils {
    public static String replacePattern(String string, String pattern, String replaceWith) {
        if (string != null) {
            ExceptionUtils.checkNull("pattern", pattern);
            ExceptionUtils.checkNull("replaceWith", replaceWith);
            string = StringUtils.replace((String)string, (String)('{' + pattern + '}'), (String)replaceWith);
        }
        return string;
    }

    public static String replaceFirstPattern(String string, String pattern, String replaceWith) {
        if (string != null) {
            ExceptionUtils.checkNull("pattern", pattern);
            ExceptionUtils.checkNull("replaceWith", replaceWith);
            string = StringUtils.replaceOnce((String)string, (String)('{' + pattern + '}'), (String)replaceWith);
        }
        return string;
    }

    public static boolean containsPattern(String string, String pattern) {
        boolean containsPattern;
        boolean bl = containsPattern = string != null && pattern != null;
        if (containsPattern) {
            containsPattern = StringUtils.contains((String)string, (String)('{' + pattern + '}'));
        }
        return containsPattern;
    }

    public static String trimToEmpty(Object object) {
        return StringUtils.trimToEmpty((String)ObjectUtils.toString((Object)object));
    }

    public static String deleteWhitespace(Object object) {
        return StringUtils.deleteWhitespace((String)ObjectUtils.toString((Object)object));
    }

    public static String getStartingProperty(String property) {
        StringUtils.trimToEmpty((String)property);
        int dotIndex = property.indexOf(46);
        if (dotIndex != -1) {
            property = property.substring(0, dotIndex);
        }
        return property;
    }

    public static String removeExtraWhitespace(String string) {
        return string == null ? "" : string.replaceAll("[$\\s]+", " ").trim();
    }

    public static Object getProperty(Object bean, String property) {
        String methodName = "TranslationUtils.getProperty";
        try {
            return Introspector.instance().getProperty(bean, property);
        }
        catch (Exception exception) {
            throw new TranslatorException("Error performing TranslationUtils.getProperty with bean '" + bean + "' and property '" + property + '\'', exception);
        }
    }

    public static String getPropertyAsString(Object bean, String property) {
        return TranslationUtils.trimToEmpty(TranslationUtils.getProperty(bean, property));
    }
}

