/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.transformation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Transformation;
import org.andromda.core.transformation.Transformer;
import org.andromda.core.transformation.XslTransformerException;
import org.apache.commons.lang.StringUtils;

public class XslTransformer
implements Transformer {
    @Override
    public InputStream transform(String modelUri, Transformation[] xsltTransformations) {
        try {
            InputStream stream = null;
            if (StringUtils.isNotBlank((String)modelUri)) {
                URL modelUrl = new URL(modelUri);
                if (xsltTransformations != null && xsltTransformations.length > 0) {
                    StreamSource modelSource = new StreamSource(modelUrl.openStream());
                    List<Transformation> xslts = Arrays.asList(xsltTransformations);
                    TransformerFactory factory = TransformerFactory.newInstance();
                    TransformerURIResolver resolver = new TransformerURIResolver();
                    factory.setURIResolver(resolver);
                    Iterator xsltIterator = xslts.iterator();
                    while (xsltIterator.hasNext()) {
                        Transformation transformation = (Transformation)xsltIterator.next();
                        URL xslt = new URL(transformation.getUri());
                        resolver.setLocation(xslt);
                        AndroMDALogger.info("Applying transformation --> '" + xslt + '\'');
                        StreamSource xsltSource = new StreamSource(xslt.openStream());
                        javax.xml.transform.Transformer transformer = factory.newTransformer(xsltSource);
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        StreamResult result = new StreamResult(output);
                        transformer.transform(modelSource, result);
                        byte[] outputResult = output.toByteArray();
                        stream = new ByteArrayInputStream(outputResult);
                        String outputLocation = transformation.getOutputLocation();
                        if (StringUtils.isNotBlank((String)outputLocation)) {
                            File fileOutput = new File(outputLocation);
                            File parent = fileOutput.getParentFile();
                            if (parent != null) {
                                parent.mkdirs();
                            }
                            FileOutputStream outputStream = new FileOutputStream(fileOutput);
                            AndroMDALogger.info("Transformation output: '" + outputLocation + '\'');
                            outputStream.write(outputResult);
                            outputStream.flush();
                            outputStream.close();
                        }
                        if (!xsltIterator.hasNext()) continue;
                        modelSource = new StreamSource(stream);
                    }
                } else {
                    stream = modelUrl.openStream();
                }
            }
            return stream;
        }
        catch (Exception exception) {
            throw new XslTransformerException(exception);
        }
    }

    static final class TransformerURIResolver
    implements URIResolver {
        private URL location;

        TransformerURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            StreamSource source = null;
            if (this.location != null) {
                String locationUri = ResourceUtils.normalizePath(this.location.toString());
                locationUri = locationUri.substring(0, locationUri.lastIndexOf(47) + 1);
                source = new StreamSource(locationUri + href);
            }
            return source;
        }

        public void setLocation(URL location) {
            this.location = location;
        }
    }
}

