/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.server;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.engine.Engine;
import org.andromda.core.server.Server;
import org.andromda.core.server.ServerException;

public class DefaultServer
implements Server {
    private static final String COMPLETE = "complete";
    static final String STOP = "stop";
    private ServerSocket listener = null;
    private Engine engine = Engine.newInstance();
    private int failedLoadAttempts;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start(Configuration configuration) {
        org.andromda.core.configuration.Server serverConfiguration;
        this.engine.initialize(configuration);
        if (configuration == null || (serverConfiguration = configuration.getServer()) == null) return;
        try {
            try {
                this.listener = new ServerSocket(serverConfiguration.getPort());
                int modelLoadInterval = serverConfiguration.getLoadInterval();
                if (modelLoadInterval > 0) {
                    this.listener.setSoTimeout(serverConfiguration.getLoadInterval());
                }
            }
            catch (IOException exception) {
                throw new ServerException("Could not listen on port '" + serverConfiguration.getPort() + "', change the port in your configuration");
            }
            block10: while (true) {
                try {
                    while (true) {
                        Socket client;
                        if ((client = this.listener.accept()) == null) {
                            continue;
                        }
                        ObjectOutputStream serverOutput = new ObjectOutputStream(client.getOutputStream());
                        ObjectInputStream objectInput = new ObjectInputStream(new DataInputStream(client.getInputStream()));
                        try {
                            String string;
                            Object object = objectInput.readObject();
                            if (object instanceof Configuration) {
                                this.engine.run((Configuration)object, false, null);
                            } else if (object instanceof String && (string = (String)object).equals(STOP)) {
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            AndroMDALogger.error(throwable);
                            serverOutput.writeObject(throwable);
                        }
                        serverOutput.writeObject(COMPLETE);
                        serverOutput.flush();
                        serverOutput.close();
                        objectInput.close();
                        client.close();
                    }
                }
                catch (SocketTimeoutException exception) {
                    try {
                        this.engine.loadModelsIfNecessary(configuration);
                        this.resetFailedLoadAttempts();
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.incrementFailedLoadAttempts();
                        if (this.failedLoadAttempts > serverConfiguration.getMaximumFailedLoadAttempts()) throw throwable;
                        continue;
                    }
                }
                break;
            }
            this.shutdown();
            return;
        }
        catch (Throwable throwable) {
            throw new ServerException(throwable);
        }
    }

    private void resetFailedLoadAttempts() {
        this.failedLoadAttempts = 0;
    }

    private void incrementFailedLoadAttempts() {
        ++this.failedLoadAttempts;
    }

    public void shutdown() {
        try {
            this.listener.close();
            this.listener = null;
            this.engine.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

