/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.server;

import java.io.DataInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.configuration.Server;
import org.andromda.core.server.Client;
import org.andromda.core.server.ClientException;

public class DefaultClient
implements Client {
    @Override
    public void start(Configuration configuration) throws ConnectException {
        this.performServerOperation(configuration, configuration);
    }

    @Override
    public void stop(Configuration configuration) throws ConnectException {
        this.performServerOperation(configuration, "stop");
    }

    private void performServerOperation(Configuration configuration, Object object) throws ConnectException {
        Server serverConfiguration;
        if (configuration != null && configuration.getServer() != null && (serverConfiguration = configuration.getServer()) != null) {
            try {
                Object input;
                ObjectOutputStream out;
                ObjectInputStream objectInput;
                Socket server;
                String host = serverConfiguration.getHost();
                try {
                    server = new Socket(host, serverConfiguration.getPort());
                    objectInput = new ObjectInputStream(new DataInputStream(server.getInputStream()));
                    out = new ObjectOutputStream(server.getOutputStream());
                }
                catch (UnknownHostException exception) {
                    throw new ClientException("Can't connect to host '" + host + '\'');
                }
                out.writeObject(object);
                if (object instanceof Configuration && (input = objectInput.readObject()) instanceof Throwable) {
                    throw new ClientException((Throwable)input);
                }
                objectInput.close();
                server.close();
                out.flush();
                out.close();
            }
            catch (ConnectException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throw new ClientException(throwable);
            }
        }
    }
}

