/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.repository;

import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.namespace.PropertyDefinition;
import org.andromda.core.repository.Repository;
import org.andromda.core.repository.RepositoryException;
import org.andromda.core.repository.RepositoryFacade;
import org.andromda.core.transformation.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Repositories {
    private static Repositories instance;
    private final Map<String, RepositoryFacade> repositories = new LinkedHashMap<String, RepositoryFacade>();

    public static Repositories instance() {
        if (instance == null) {
            instance = new Repositories();
        }
        return instance;
    }

    public void initialize() {
        if (this.repositories.isEmpty()) {
            Namespaces namespaces = Namespaces.instance();
            Collection repositories = ComponentContainer.instance().findComponentsOfType(Repository.class);
            for (Repository repository : repositories) {
                RepositoryFacade repositoryImplementation = repository.getImplementation();
                String namespace = repository.getNamespace();
                PropertyDefinition[] properties = namespaces.getPropertyDefinitions(namespace);
                if (properties != null) {
                    for (PropertyDefinition property : properties) {
                        String propertyName = property.getName();
                        if (!Introspector.instance().isWritable(repositoryImplementation, propertyName)) continue;
                        Introspector.instance().setProperty(repositoryImplementation, property.getName(), namespaces.getPropertyValue(namespace, property.getName()));
                    }
                }
                repositoryImplementation.open();
                this.repositories.put(namespace, repositoryImplementation);
            }
        }
    }

    public RepositoryFacade getImplementation(String name) {
        RepositoryFacade implementation = this.repositories.get(name);
        if (implementation == null) {
            String message = this.repositories.isEmpty() ? "No repository implementations have been registered, make sure you have at least one valid repository registered under a namespace on your classpath" : ("emf-uml2".equals(name) ? "emf-uml2 (UML2 1.x) has been deprecated and is no longer the UML2 default, change your project andromda.xml configuration to 'emf-uml22' and export your model to UML2 2.x or upgrade to RSM 7.x, you must specify one of the following as your repository name: [" + StringUtils.join(this.repositories.keySet().iterator(), (String)", ") + ']' : "No repository implementation registered under namespace '" + name + "', you must specify one of the following as your repository name: [" + StringUtils.join(this.repositories.keySet().iterator(), (String)", ") + ']');
            throw new RepositoryException(message);
        }
        return implementation;
    }

    public boolean loadModel(Model model) {
        ExceptionUtils.checkNull("model", model);
        boolean loaded = model.isChanged();
        if (loaded) {
            String repositoryName;
            org.andromda.core.configuration.Repository repository = model.getRepository();
            String string = repositoryName = repository != null ? repository.getName() : null;
            if (repositoryName == null) {
                throw new RepositoryException("Could not retrieve the repository to which the '" + model + "' belongs");
            }
            Transformer transformer = (Transformer)ComponentContainer.instance().findRequiredComponent(Transformer.class);
            String[] uris = model.getUris();
            int uriNumber = uris.length;
            InputStream[] streams = new InputStream[uriNumber];
            for (int ctr = 0; ctr < uriNumber; ++ctr) {
                streams[ctr] = transformer.transform(uris[ctr], model.getTransformations());
            }
            for (String uri : uris) {
                AndroMDALogger.info("loading model --> '" + uri + '\'');
            }
            RepositoryFacade repositoryImplementation = this.getImplementation(repositoryName);
            repositoryImplementation.readModel(streams, uris, model.getModuleSearchLocationPaths());
            if (repositoryImplementation.getModel() != null) {
                repositoryImplementation.getModel().setPackageFilter(model.getPackages());
            }
            for (InputStream stream : streams) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        return loaded;
    }

    public void clear() {
        for (RepositoryFacade repositoryFacade : this.repositories.values()) {
            repositoryFacade.clear();
        }
    }
}

