/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.profile;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.namespace.BaseNamespaceComponent;
import org.andromda.core.profile.ProfileException;
import org.apache.commons.lang.StringUtils;

public class Profile
extends BaseNamespaceComponent
implements Serializable {
    private static final long serialVersionUID = 34L;
    private static Profile instance;
    private final Map<String, String> elements = new LinkedHashMap<String, String>();
    private final Map<String, Map<String, String>> allElements = new LinkedHashMap<String, Map<String, String>>();

    public static Profile instance() {
        if (instance == null) {
            instance = new Profile();
        }
        return instance;
    }

    public void addElement(String name, String value) {
        this.elements.put(name, value);
    }

    public String get(String name) {
        String value = this.elements.get(name = StringUtils.trim((String)name));
        if (StringUtils.isBlank((String)value)) {
            Map<String, String> namespaceElements = this.getNamespaceElements(this.getNamespace());
            if (namespaceElements != null) {
                value = namespaceElements.get(name);
            }
            if (value == null && (namespaceElements = this.getNamespaceElements("default")) != null) {
                value = namespaceElements.get(name);
            }
        }
        return value != null ? value : name;
    }

    public void initialize() {
        Collection profiles = ComponentContainer.instance().findComponentsOfType(Profile.class);
        for (Profile profile : profiles) {
            String namespace = profile.getNamespace();
            if (Namespaces.instance().isShared(namespace)) {
                profile.setNamespace("default");
            }
            this.addElements(profile);
        }
    }

    public void refresh() {
        this.elements.clear();
        try {
            String mappingsUriValue;
            Property mappingsUri = Namespaces.instance().getProperty("default", "profileMappingsUri", false);
            String string = mappingsUriValue = mappingsUri != null ? mappingsUri.getValue() : null;
            if (mappingsUriValue != null) {
                XmlObjectFactory factory = XmlObjectFactory.getInstance(Profile.class);
                Profile profile = (Profile)factory.getObject(new URL(mappingsUriValue.trim()));
                this.elements.putAll(profile.elements);
            }
        }
        catch (Throwable throwable) {
            throw new ProfileException(throwable);
        }
    }

    private void addElements(Profile profile) {
        Set<String> elements;
        Set<String> set = elements = profile != null ? profile.elements.keySet() : null;
        if (elements != null && profile != null) {
            String namespace = profile.getNamespace();
            Map<String, String> namespaceElements = this.getNamespaceElements(namespace);
            for (String name : elements) {
                namespaceElements.put(name, profile.elements.get(name));
            }
        }
    }

    public void addElement(String namespace, String name, String value) {
        Map<String, String> namespaceElements = this.getNamespaceElements(namespace);
        namespaceElements.put(name, value);
    }

    private Map<String, String> getNamespaceElements(String namespace) {
        Map<String, String> namespaceElements = this.allElements.get(namespace);
        if (namespaceElements == null) {
            namespaceElements = new LinkedHashMap<String, String>();
            this.allElements.put(namespace, namespaceElements);
        }
        return namespaceElements;
    }

    public void shutdown() {
        instance = null;
    }
}

