/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.namespace;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.namespace.Component;
import org.andromda.core.namespace.PropertyDefinition;

public class NamespaceRegistry {
    private String name;
    private boolean shared = false;
    private final Map<String, String[]> components = new LinkedHashMap<String, String[]>();
    private final Map<String, PropertyDefinition> definitions = new LinkedHashMap<String, PropertyDefinition>();
    private Collection<URL> resourceRoots = new ArrayList<URL>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void registerComponent(Component component) {
        if (component != null) {
            this.components.put(component.getName(), component.getPaths());
        }
    }

    public String[] getRegisteredComponents() {
        return this.components.keySet().toArray(new String[this.components.size()]);
    }

    public String[] getPaths(String name) {
        return this.components.get(name);
    }

    public PropertyDefinition getPropertyDefinition(String name) {
        return this.definitions.get(name);
    }

    public void addPropertyDefinitions(PropertyDefinition[] propertyDefinitions) {
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            this.addPropertyDefinition(propertyDefinition);
        }
    }

    final void copy(NamespaceRegistry registry) {
        if (registry != null) {
            this.addPropertyDefinitions(registry.getPropertyDefinitions());
            this.components.putAll(registry.components);
            if (registry.isShared()) {
                this.shared = registry.isShared();
            }
            this.resourceRoots.addAll(registry.resourceRoots);
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        return this.definitions.values().toArray(new PropertyDefinition[this.definitions.size()]);
    }

    public void addPropertyDefinition(PropertyDefinition propertyDefinition) {
        if (propertyDefinition != null) {
            this.definitions.put(propertyDefinition.getName(), propertyDefinition);
        }
    }

    public URL[] getResourceRoots() {
        return this.resourceRoots.toArray(new URL[this.resourceRoots.size()]);
    }

    final void addResourceRoot(URL resourceRoot) {
        this.resourceRoots.add(resourceRoot);
    }

    public String toString() {
        return super.toString() + '[' + this.getName() + ']';
    }
}

