/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.namespace;

import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.Merger;
import org.andromda.core.common.ResourceFinder;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.namespace.Component;
import org.andromda.core.namespace.NamespaceComponent;
import org.andromda.core.namespace.NamespaceComponentsException;
import org.andromda.core.namespace.NamespaceRegistry;
import org.andromda.core.profile.Profile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class NamespaceComponents {
    private static NamespaceComponents instance;
    private static final String CONFIGURATION_URI = "META-INF/andromda/namespace-components.xml";
    private Collection<URL> registeredNamespaceResources = new ArrayList<URL>();
    private Collection<String> registeredRegistries = new ArrayList<String>();
    private String path;
    private final Map<String, Component> components = new LinkedHashMap<String, Component>();

    public static final NamespaceComponents instance() {
        if (instance == null) {
            XmlObjectFactory factory = XmlObjectFactory.getInstance(NamespaceComponents.class);
            instance = (NamespaceComponents)factory.getObject(ResourceUtils.getResource(CONFIGURATION_URI));
        }
        return instance;
    }

    public void discover() {
        AndroMDALogger.info("- discovering namespaces -");
        XmlObjectFactory registryFactory = XmlObjectFactory.getInstance(NamespaceRegistry.class);
        ComponentContainer container = ComponentContainer.instance();
        Map<NamespaceRegistry, URL> registryMap = this.discoverAllRegistries();
        ArrayList<NamespaceRegistry> registries = new ArrayList<NamespaceRegistry>(registryMap.keySet());
        Collections.sort(registries, new NamespaceRegistryComparator());
        for (NamespaceRegistry registry : registries) {
            URL resource = registryMap.get(registry);
            String registryName = registry.getName();
            if (!this.registeredNamespaceResources.contains(resource)) {
                String[] components;
                NamespaceRegistry existingRegistry;
                Namespaces namespaces = Namespaces.instance();
                String namespace = registry.isShared() ? "default" : registry.getName();
                Merger merger = Merger.instance();
                boolean requiresMerge = merger.requiresMerge(namespace);
                if (requiresMerge) {
                    registry = (NamespaceRegistry)registryFactory.getObject(merger.getMergedString(ResourceUtils.getContents(resource), namespace), resource);
                }
                registry.addResourceRoot(this.getNamespaceResourceRoot(resource));
                if (!this.registeredRegistries.contains(registryName)) {
                    AndroMDALogger.info("found namespace --> '" + registryName + '\'');
                    this.registeredRegistries.add(registryName);
                }
                if ((existingRegistry = namespaces.getRegistry(registryName)) != null) {
                    registry.copy(existingRegistry);
                }
                namespaces.addRegistry(registry);
                for (String componentName : components = registry.getRegisteredComponents()) {
                    Component component = this.getComponent(componentName);
                    if (component == null) {
                        throw new NamespaceComponentsException('\'' + componentName + "' is not a valid namespace component");
                    }
                    component.addPaths(registry.getPaths(component.getName()));
                    if (container.isRegisteredByNamespace(registryName, component.getType())) continue;
                    AndroMDALogger.info("  +  registering component '" + componentName + '\'');
                    XmlObjectFactory componentFactory = XmlObjectFactory.getInstance(component.getType());
                    URL componentResource = this.getNamespaceResource(registry.getResourceRoots(), component.getPaths());
                    if (componentResource == null) {
                        throw new NamespaceComponentsException('\'' + componentName + "' is not a valid component within namespace '" + namespace + "' (the " + componentName + "'s descriptor can not be found)");
                    }
                    NamespaceComponent namespaceComponent = (NamespaceComponent)componentFactory.getObject(componentResource);
                    if (requiresMerge) {
                        namespaceComponent = (NamespaceComponent)componentFactory.getObject(merger.getMergedString(ResourceUtils.getContents(componentResource), namespace));
                    }
                    namespaceComponent.setNamespace(registryName);
                    namespaceComponent.setResource(componentResource);
                    container.registerComponentByNamespace(registryName, component.getType(), namespaceComponent);
                }
            }
            this.registeredNamespaceResources.add(resource);
        }
        Profile.instance().initialize();
    }

    private Map<NamespaceRegistry, URL> discoverAllRegistries() {
        HashMap<NamespaceRegistry, URL> registries = new HashMap<NamespaceRegistry, URL>();
        URL[] resources = ResourceFinder.findResources(this.getPath());
        XmlObjectFactory registryFactory = XmlObjectFactory.getInstance(NamespaceRegistry.class);
        if (resources != null) {
            for (URL resource : resources) {
                NamespaceRegistry registry = (NamespaceRegistry)registryFactory.getObject(resource);
                registries.put(registry, resource);
            }
        }
        return registries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getNamespaceResource(URL[] resourceRoots, String[] paths) {
        URL namespaceResource;
        block7: {
            namespaceResource = null;
            if (resourceRoots == null) break block7;
            for (URL resource : resourceRoots) {
                for (String path : paths) {
                    InputStream stream = null;
                    try {
                        namespaceResource = new URL(ResourceUtils.normalizePath(resource + path));
                        stream = namespaceResource.openStream();
                    }
                    catch (Throwable throwable) {
                        try {
                            namespaceResource = null;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            IOUtils.closeQuietly(stream);
                        }
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                    if (namespaceResource != null) break;
                }
                if (namespaceResource != null) break;
            }
        }
        return namespaceResource;
    }

    private URL getNamespaceResourceRoot(URL resource) {
        String resourcePath = resource != null ? resource.toString().replace('\\', '/') : null;
        return ResourceUtils.toURL(StringUtils.replace((String)resourcePath, (String)this.path, (String)""));
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addComponent(Component component) {
        if (component != null) {
            this.components.put(component.getName(), component);
        }
    }

    public void shutdown() {
        this.components.clear();
        this.registeredNamespaceResources.clear();
        this.registeredRegistries.clear();
        instance = null;
    }

    private Component getComponent(String name) {
        return this.components.get(name);
    }

    private static final class NamespaceRegistryComparator
    implements Comparator<NamespaceRegistry> {
        private final Collator collator = Collator.getInstance();

        NamespaceRegistryComparator() {
            this.collator.setStrength(0);
        }

        @Override
        public int compare(NamespaceRegistry objectA, NamespaceRegistry objectB) {
            return this.collator.compare(objectA.getName(), objectB.getName());
        }
    }
}

