/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.io.Serializable;
import java.util.List;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.metafacade.MetafacadeBase;
import org.apache.commons.lang.StringUtils;

public class ModelValidationMessage
implements Serializable {
    private static final long serialVersionUID = 34L;
    private String name;
    private String message;
    private MetafacadeBase metafacade;
    private String metafacadeName = null;
    private Class metafacadeClass = null;

    public ModelValidationMessage(MetafacadeBase metafacade, String message) {
        this(metafacade, null, message);
    }

    public ModelValidationMessage(MetafacadeBase metafacade, String name, String message) {
        ExceptionUtils.checkNull("metafacade", metafacade);
        ExceptionUtils.checkEmpty("message", message);
        this.metafacade = metafacade;
        this.name = name;
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMetafacadeName() {
        if (this.metafacadeName == null) {
            String separator = "::";
            StringBuilder name = new StringBuilder();
            for (MetafacadeBase metafacade = this.metafacade; metafacade != null; metafacade = (MetafacadeBase)metafacade.getValidationOwner()) {
                if (!StringUtils.isNotBlank((String)metafacade.getValidationName())) continue;
                String validationName = metafacade.getValidationName();
                if (metafacade.getValidationOwner() != null) {
                    validationName = validationName.replaceAll(".*::", "");
                }
                if (name.length() > 0) {
                    name.insert(0, "::");
                }
                name.insert(0, validationName);
            }
            this.metafacadeName = name.toString();
        }
        return this.metafacadeName;
    }

    public Class getMetafacadeClass() {
        if (this.metafacadeClass == null) {
            this.metafacadeClass = this.metafacade.getClass();
            List interfaces = ClassUtils.getAllInterfaces(this.metafacade.getClass());
            if (interfaces != null && !interfaces.isEmpty()) {
                this.metafacadeClass = (Class)interfaces.iterator().next();
            }
        }
        return this.metafacadeClass;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append('[');
        toString.append(this.getMetafacadeName());
        toString.append(']');
        toString.append(':');
        toString.append(this.message);
        return toString.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        boolean equals;
        boolean bl = equals = object != null && ModelValidationMessage.class == object.getClass();
        if (equals) {
            ModelValidationMessage message = (ModelValidationMessage)object;
            equals = message.toString().equals(this.toString());
        }
        return equals;
    }
}

