/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.Introspector;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.andromda.core.metafacade.MetafacadeMapping;
import org.andromda.core.metafacade.MetafacadeMappings;
import org.andromda.core.metafacade.MetafacadeMappingsException;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

final class MetafacadeUtils {
    MetafacadeUtils() {
    }

    static boolean propertiesValid(MetafacadeBase metafacade, MetafacadeMapping mapping) {
        boolean valid = false;
        Collection<MetafacadeMapping.PropertyGroup> propertyGroups = mapping.getMappingPropertyGroups();
        if (propertyGroups != null && !propertyGroups.isEmpty()) {
            try {
                if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                    MetafacadeUtils.getLogger().debug((Object)("evaluating " + propertyGroups.size() + " property groups(s) on metafacade '" + metafacade + '\''));
                }
                Introspector introspector = Introspector.instance();
                for (MetafacadeMapping.PropertyGroup propertyGroup : propertyGroups) {
                    for (MetafacadeMapping.Property property : propertyGroup.getProperties()) {
                        valid = introspector.containsValidProperty(metafacade, property.getName(), property.getValue());
                        if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                            MetafacadeUtils.getLogger().debug((Object)("property '" + property.getName() + "', with value '" + property.getValue() + "' on metafacade '" + metafacade + "', evaluated to --> '" + valid + '\''));
                        }
                        if (valid) continue;
                        break;
                    }
                    if (!valid) continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                    MetafacadeUtils.getLogger().debug((Object)("An error occured while evaluating properties on metafacade '" + metafacade + "', setting valid to 'false'"), throwable);
                }
                valid = false;
            }
            if (MetafacadeUtils.getLogger().isDebugEnabled()) {
                MetafacadeUtils.getLogger().debug((Object)("completed evaluating " + propertyGroups.size() + " properties on metafacade '" + metafacade + "' with a result of --> '" + valid + '\''));
            }
        }
        return valid;
    }

    static MetafacadeBase constructMetafacade(Class metafacadeClass, Object mappingObject, String context) throws Exception {
        if (MetafacadeUtils.getLogger().isDebugEnabled()) {
            MetafacadeUtils.getLogger().debug((Object)("constructing metafacade from class '" + metafacadeClass + "' mapping object '" + mappingObject + "', and context '" + context + '\''));
        }
        Constructor<?> constructor = metafacadeClass.getDeclaredConstructors()[0];
        return (MetafacadeBase)constructor.newInstance(mappingObject, context);
    }

    private static Set<String> intersection(Set<String> nameSet1, Set<String> nameSet2) {
        HashSet<String> results = new HashSet<String>();
        if (nameSet1 == null || nameSet2 == null) {
            return results;
        }
        HashMap classesToName = new HashMap();
        Set<Class<?>> classesSet1 = MetafacadeUtils.getClassesFromNames(nameSet1, classesToName);
        Set<Class<?>> classesSet2 = MetafacadeUtils.getClassesFromNames(nameSet2, classesToName);
        for (final Class<?> classToCheck : classesSet1) {
            HashSet classToCheckInterfaces = new HashSet(Arrays.asList(classToCheck.getInterfaces()));
            for (final Class<?> expectedResult : classesSet2) {
                if (classToCheck.isAssignableFrom(expectedResult)) {
                    results.add((String)classesToName.get(expectedResult));
                    continue;
                }
                if (expectedResult.isAssignableFrom(classToCheck)) {
                    results.add((String)classesToName.get(classToCheck));
                    continue;
                }
                boolean expectedResultNotCompliant = CollectionUtils.exists(classToCheckInterfaces, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        Class classToCheckInterface = (Class)object;
                        return !classToCheckInterface.isAssignableFrom(expectedResult);
                    }
                });
                if (!expectedResultNotCompliant) {
                    results.add((String)classesToName.get(expectedResult));
                    continue;
                }
                HashSet expectedResultInterfaces = new HashSet(Arrays.asList(expectedResult.getInterfaces()));
                boolean classToCheckNotCompliant = CollectionUtils.exists(expectedResultInterfaces, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        Class expectedResultInterface = (Class)object;
                        return !expectedResultInterface.isAssignableFrom(classToCheck);
                    }
                });
                if (classToCheckNotCompliant) continue;
                results.add((String)classesToName.get(classToCheck));
            }
        }
        return results;
    }

    private static Set<Class<?>> getClassesFromNames(Set<String> nameSet, Map<Class<?>, String> classesToName) {
        HashSet classesSet = new HashSet();
        for (String name : nameSet) {
            try {
                Class<?> cl = Class.forName(name);
                classesToName.put(cl, name);
                classesSet.add(cl);
            }
            catch (ClassNotFoundException e1) {
                try {
                    String instanciatedName = name;
                    if (instanciatedName.endsWith("$Impl")) {
                        instanciatedName = name.substring(0, name.lastIndexOf("$Impl"));
                    }
                    Class<?> cl = Class.forName(instanciatedName);
                    classesToName.put(cl, name);
                    classesSet.add(cl);
                }
                catch (ClassNotFoundException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        return classesSet;
    }

    private static Set<String> getInheritedMappingClassNames(Class metafacadeClass, MetafacadeImpls metafacadeImpls, Map<Class, Set<String>> mappingInstances) {
        Set<String> result = null;
        if (metafacadeClass != null) {
            if (metafacadeClass.isInterface()) {
                result = mappingInstances.get(metafacadeImpls.getMetafacadeImplClass(metafacadeClass.getName()));
            }
            if (result == null) {
                for (Class<?> currentInterface : metafacadeClass.getInterfaces()) {
                    Set<String> subInheritedMappingClassNames = MetafacadeUtils.getInheritedMappingClassNames(currentInterface, metafacadeImpls, mappingInstances);
                    if (subInheritedMappingClassNames == null) continue;
                    result = result == null ? subInheritedMappingClassNames : MetafacadeUtils.intersection(result, subInheritedMappingClassNames);
                }
            }
            if (result == null) {
                result = MetafacadeUtils.getInheritedMappingClassNames(metafacadeClass.getSuperclass(), metafacadeImpls, mappingInstances);
            }
        }
        return result;
    }

    public static Set<String> getInheritedMappingClassNames(MetafacadeMapping mapping) {
        Map<Class, Set<String>> mappingInstances;
        MetafacadeImpls metafacadeImpls;
        Class metafacadeClass = mapping.getMetafacadeClass();
        Set<String> className = MetafacadeUtils.getInheritedMappingClassNames(metafacadeClass, metafacadeImpls = MetafacadeImpls.instance(), mappingInstances = MetafacadeMappings.getAllMetafacadeMappingInstances());
        if (className == null || className.isEmpty()) {
            throw new MetafacadeMappingsException("No mapping class could be found for '" + metafacadeClass.getName() + '\'');
        }
        MetafacadeUtils.getLogger().debug((Object)("inheritedMappingClassName " + metafacadeClass.getName() + "=" + className));
        return className;
    }

    public static boolean isMetafacadeModelPresent(String namespace) {
        boolean present = false;
        if (ClassUtils.isClassOfTypePresent(Namespaces.instance().getResourceRoots(namespace), ModelAccessFacade.class)) {
            present = true;
        }
        return present;
    }

    private static Logger getLogger() {
        return MetafacadeFactory.getInstance().getLogger();
    }
}

