/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Namespace;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.andromda.core.metafacade.MetafacadeMapping;
import org.andromda.core.metafacade.MetafacadeMappingsException;
import org.andromda.core.metafacade.MetafacadeUtils;
import org.andromda.core.namespace.BaseNamespaceComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetafacadeMappings
extends BaseNamespaceComponent
implements Serializable {
    private static final long serialVersionUID = 34L;
    private final Collection<MetafacadeMapping> mappings = new ArrayList<MetafacadeMapping>();
    private final Map<String, MetafacadeMappings> namespaceMetafacadeMappings = new HashMap<String, MetafacadeMappings>();
    private Class defaultMetafacadeClass = null;
    private final Map<Class, MetafacadeMapping> mappingsByMetafacadeClass = new HashMap<Class, MetafacadeMapping>();
    private final Collection<String> propertyReferences = new LinkedHashSet<String>();
    private final Map<Object, Collection<String>> mappingObjectHierarchyCache = new HashMap<Object, Collection<String>>();
    private static final String METAFACADE_PACKAGE_REPLACE_PATTERN = "\\{0\\}";
    private static final String METAFACADE_NAME_REPLACE_PATTERN = "\\{1\\}";
    protected final Collection<MetafacadeMapping> inProcessMappings = new ArrayList<MetafacadeMapping>();
    protected final Collection<MetafacadeBase> inProcessMetafacades = new ArrayList<MetafacadeBase>();
    private final Map<String, List<String>> contextHierarchyCache = new HashMap<String, List<String>>();
    private final Map<String, Class[]> reversedInterfaceArrayCache = new HashMap<String, Class[]>();
    private Map<String, MetafacadeMappings> parents = new HashMap<String, MetafacadeMappings>();
    private String metaclassPattern;
    private static final Map<Class, Set<String>> allMetafacadeMappingInstances = new HashMap<Class, Set<String>>();
    private MetafacadeImpls metafacadeClasses = MetafacadeImpls.instance();
    private Map<String, MetafacadeMappings> modelMetafacadeMappings = new LinkedHashMap<String, MetafacadeMappings>();
    private String parentNamespace;

    public static MetafacadeMappings newInstance() {
        return new MetafacadeMappings();
    }

    public void addMapping(final MetafacadeMapping mapping) {
        ExceptionUtils.checkNull("mapping", mapping);
        ExceptionUtils.checkNull("mapping.metafacadeClass", mapping.getMetafacadeClass());
        mapping.setMetafacadeMappings(this);
        MetafacadeMapping foundMapping = this.findMapping(new Condition(){

            @Override
            public boolean evaluate(MetafacadeMapping object) {
                return mapping.match(object);
            }
        });
        if (foundMapping != null) {
            foundMapping.addMappingPropertyGroup(mapping.getMappingProperties());
        } else {
            this.mappings.add(mapping);
            this.mappingsByMetafacadeClass.put(this.getMetafacadeInterface(mapping.getMetafacadeClass()), mapping);
        }
    }

    public Class getMetafacadeInterface(Class metafacadeClass) {
        Class metafacadeInterface = null;
        if (metafacadeClass != null) {
            metafacadeInterface = metafacadeClass;
            List interfaces = ClassUtils.getAllInterfaces((Class)metafacadeClass);
            if (interfaces != null && !interfaces.isEmpty()) {
                metafacadeInterface = (Class)interfaces.iterator().next();
            }
        }
        return metafacadeInterface;
    }

    private void copyMappings(MetafacadeMappings mappings) {
        ExceptionUtils.checkNull("mappings", mappings);
        for (MetafacadeMapping mapping : mappings.mappings) {
            this.addMapping(mapping);
        }
        Collection<String> propertyReferences = mappings.getPropertyReferences();
        if (propertyReferences != null && !propertyReferences.isEmpty()) {
            this.propertyReferences.addAll(propertyReferences);
        }
        this.defaultMetafacadeClass = mappings.defaultMetafacadeClass;
    }

    public Collection<String> getPropertyReferences() {
        return this.propertyReferences;
    }

    protected MetafacadeMapping getMapping(Object mappingObject, String context, Collection<String> stereotypes) {
        Collection<String> hierarchy;
        MetafacadeMapping mapping = this.getMapping(null, mappingObject, context, stereotypes);
        if (mapping == null && (hierarchy = this.getMappingObjectHierarchy(mappingObject)) != null && !hierarchy.isEmpty()) {
            Iterator<String> iterator = hierarchy.iterator();
            while (iterator.hasNext() && mapping == null) {
                mapping = this.getMapping(iterator.next(), mappingObject, context, stereotypes);
            }
        }
        return mapping;
    }

    protected Collection<String> getMappingObjectHierarchy(Object mappingObject) {
        String pattern;
        Collection<String> hierarchy = this.mappingObjectHierarchyCache.get(mappingObject);
        if (hierarchy == null && StringUtils.isNotBlank((String)(pattern = this.getMetaclassPattern()))) {
            hierarchy = new ArrayList<String>();
            List metafacadeInterfaces = ClassUtils.getAllInterfaces(mappingObject.getClass());
            for (Class metafacadeInterface : metafacadeInterfaces) {
                String packageName = ClassUtils.getPackageName((Class)metafacadeInterface);
                String name = ClassUtils.getShortClassName((Class)metafacadeInterface);
                String metafacadeImplementationName = pattern != null ? pattern.replaceAll(METAFACADE_PACKAGE_REPLACE_PATTERN, packageName).replaceAll(METAFACADE_NAME_REPLACE_PATTERN, name) : metafacadeInterface.getName();
                hierarchy.add(metafacadeImplementationName);
            }
            this.mappingObjectHierarchyCache.put(mappingObject, hierarchy);
        }
        return hierarchy;
    }

    private MetafacadeMapping getMapping(String mappingClassName, final Object mappingObject, final String context, final Collection<String> stereotypes) {
        final String metaclassName = mappingClassName != null ? mappingClassName : mappingObject.getClass().getName();
        boolean validMetaclass = this.findMapping(new Condition(){

            @Override
            public boolean evaluate(MetafacadeMapping mapping) {
                return mapping.getMappingClassNames().contains(metaclassName);
            }
        }) != null;
        MetafacadeMapping mapping = null;
        if (validMetaclass) {
            boolean emptyStereotypes;
            boolean bl = emptyStereotypes = stereotypes == null || stereotypes.isEmpty();
            if (context != null && !emptyStereotypes) {
                mapping = this.findMapping(new Condition(){

                    @Override
                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (mapping.getMappingClassNames().contains(metaclassName) && mapping.hasContext() && mapping.hasStereotypes() && !mapping.hasMappingProperties()) {
                            valid = MetafacadeMappings.this.getContextHierarchy(context).contains(mapping.getContext()) && stereotypes != null && stereotypes.containsAll(mapping.getStereotypes());
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null && context != null) {
                mapping = this.findMapping(new Condition(){

                    @Override
                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (mapping.getMappingClassNames().contains(metaclassName) && !mapping.hasStereotypes() && mapping.hasContext() && mapping.hasMappingProperties() && !MetafacadeMappings.this.inProcessMappings.contains(mapping) && MetafacadeMappings.this.getContextHierarchy(context).contains(mapping.getContext())) {
                            MetafacadeMappings.this.inProcessMappings.add(mapping);
                            MetafacadeBase metafacade = MetafacadeFactory.getInstance().createMetafacade(mappingObject, mapping);
                            MetafacadeMappings.this.inProcessMetafacades.add(metafacade);
                            MetafacadeMappings.this.inProcessMappings.clear();
                            valid = MetafacadeUtils.propertiesValid(metafacade, mapping);
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null && context != null) {
                mapping = this.findMapping(new Condition(){

                    @Override
                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (mapping.getMappingClassNames().contains(metaclassName) && mapping.hasContext() && !mapping.hasStereotypes() && !mapping.hasMappingProperties()) {
                            valid = MetafacadeMappings.this.getContextHierarchy(context).contains(mapping.getContext());
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null && !emptyStereotypes) {
                mapping = this.findMapping(new Condition(){

                    @Override
                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (mapping.getMappingClassNames().contains(metaclassName) && mapping.hasStereotypes() && !mapping.hasContext() && !mapping.hasMappingProperties()) {
                            valid = stereotypes != null && stereotypes.containsAll(mapping.getStereotypes());
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null) {
                mapping = this.findMapping(new Condition(){

                    @Override
                    public boolean evaluate(MetafacadeMapping mapping) {
                        boolean valid = false;
                        if (mapping.getMappingClassNames().contains(metaclassName) && !mapping.hasStereotypes() && !mapping.hasContext() && mapping.hasMappingProperties() && !MetafacadeMappings.this.inProcessMappings.contains(mapping)) {
                            MetafacadeMappings.this.inProcessMappings.add(mapping);
                            MetafacadeBase metafacade = MetafacadeFactory.getInstance().createMetafacade(mappingObject, mapping);
                            MetafacadeMappings.this.inProcessMetafacades.add(metafacade);
                            MetafacadeMappings.this.inProcessMappings.clear();
                            valid = MetafacadeUtils.propertiesValid(metafacade, mapping);
                        }
                        return valid;
                    }
                });
            }
            if (mapping == null) {
                mapping = this.findMapping(new Condition(){

                    @Override
                    public boolean evaluate(MetafacadeMapping mapping) {
                        return mapping.getMappingClassNames().contains(metaclassName) && !mapping.hasContext() && !mapping.hasStereotypes() && !mapping.hasMappingProperties();
                    }
                });
            }
        }
        if (mapping == null && this.getParent() != null) {
            mapping = this.getParent().getMapping(metaclassName, mappingObject, context, stereotypes);
        }
        this.inProcessMetafacades.clear();
        return mapping;
    }

    private MetafacadeMapping findMapping(Condition condition) {
        MetafacadeMapping found = null;
        for (MetafacadeMapping mapping : this.mappings) {
            if (!condition.evaluate(mapping)) continue;
            found = mapping;
            break;
        }
        return found;
    }

    private void loadInheritedPropertyReferences(MetafacadeMapping mapping) {
        Class[] interfaces;
        if (mapping != null && (interfaces = this.getInterfacesReversed(mapping.getMetafacadeClass().getName())) != null && interfaces.length > 0) {
            for (Class metafacadeClass : interfaces) {
                MetafacadeMapping contextMapping = this.mappingsByMetafacadeClass.get(metafacadeClass);
                if (contextMapping == null) continue;
                mapping.addPropertyReferences(contextMapping.getPropertyReferences());
            }
        }
    }

    protected final List<String> getContextHierarchy(String context) {
        List<String> contexts = this.contextHierarchyCache.get(context);
        if (contexts == null) {
            List<Class> interfaces = ClassUtils.getInterfaces(context);
            contexts = new ArrayList<String>(interfaces.size());
            for (Class anInterface : interfaces) {
                contexts.add(anInterface.getName());
            }
            this.contextHierarchyCache.put(context, contexts);
        }
        return contexts;
    }

    private Class[] getInterfacesReversed(String className) {
        Class[] interfaces = this.reversedInterfaceArrayCache.get(className);
        if (interfaces == null) {
            interfaces = ClassUtils.getInterfacesReversed(className);
            this.reversedInterfaceArrayCache.put(className, interfaces);
        }
        return interfaces;
    }

    public void addPropertyReference(String reference) {
        this.propertyReferences.add(reference);
    }

    public MetafacadeMapping getMetafacadeMapping(Object mappingObject, String namespace, String context, Collection<String> stereotypes) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("performing 'MetafacadeMappings.getMetafacadeMapping' with mappingObject '" + mappingObject + "', stereotypes '" + stereotypes + "', namespace '" + namespace + "' and context '" + context + '\''));
        }
        MetafacadeMapping mapping = null;
        MetafacadeMappings mappings = this.getNamespaceMappings(namespace);
        if (mappings != null) {
            mappings.parentNamespace = this.getNamespace();
            mapping = mappings.getMapping(mappingObject, context, stereotypes);
        }
        if (mapping != null) {
            Collection<String> propertyReferences = mapping.getPropertyReferences();
            MetafacadeMapping defaultMapping = this.getMapping(mappingObject, context, stereotypes);
            if (defaultMapping != null) {
                Collection<String> defaultPropertyReferences = defaultMapping.getPropertyReferences();
                Class metafacadeInterface = this.metafacadeClasses.getMetafacadeClass(mapping.getMetafacadeClass().getName());
                Class defaultMetafacadeInterface = this.metafacadeClasses.getMetafacadeClass(defaultMapping.getMetafacadeClass().getName());
                if (defaultMetafacadeInterface.isAssignableFrom(metafacadeInterface)) {
                    mapping.addPropertyReferences(defaultPropertyReferences);
                    mapping.addPropertyReferences(propertyReferences);
                }
            }
        }
        if (mapping == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"namespace mapping not found --> finding default");
            }
            mapping = this.getMapping(mappingObject, context, stereotypes);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("found mapping --> '" + mapping + '\''));
        }
        return mapping;
    }

    private MetafacadeMappings getNamespaceMappings(String namespace) {
        return this.namespaceMetafacadeMappings.get(namespace);
    }

    private MetafacadeMappings getParent() {
        return this.parents.get(this.parentNamespace);
    }

    private void addNamespaceMappings(String namespace, MetafacadeMappings mappings) {
        if (mappings != null) {
            mappings.parents.put(this.getNamespace(), this);
            this.namespaceMetafacadeMappings.put(namespace, mappings);
        }
    }

    public void initialize() {
        ArrayList<String> modelTypeNamespaces = new ArrayList<String>();
        Collection metafacades = ComponentContainer.instance().findComponentsOfType(MetafacadeMappings.class);
        for (MetafacadeMappings mappings : metafacades) {
            String namespace = mappings.getNamespace();
            if (!MetafacadeUtils.isMetafacadeModelPresent(namespace)) continue;
            modelTypeNamespaces.add(namespace);
        }
        String[] modelNamespaces = modelTypeNamespaces.toArray(new String[modelTypeNamespaces.size()]);
        MetafacadeImpls.instance().discover(modelNamespaces);
        this.initializeMappings(modelNamespaces);
    }

    final void registerAllProperties() {
        Namespaces namespaces = Namespaces.instance();
        for (Namespace namespace1 : namespaces.getNamespaces()) {
            String mappingsNamespace = namespace1.getName();
            ArrayList<MetafacadeMapping> mappings = new ArrayList<MetafacadeMapping>(this.mappings);
            MetafacadeMappings metafacadeMappings = this.getNamespaceMappings(mappingsNamespace);
            ArrayList<String> propertyReferences = new ArrayList<String>(this.propertyReferences);
            if (metafacadeMappings != null) {
                mappings.addAll(metafacadeMappings.mappings);
                propertyReferences.addAll(metafacadeMappings.propertyReferences);
            }
            for (MetafacadeMapping mapping : mappings) {
                Class[] interfaces;
                String metafacadeInterface = this.metafacadeClasses.getMetafacadeClass(mapping.getMetafacadeClass().getName()).getName();
                for (Class anInterface : interfaces = this.getInterfacesReversed(metafacadeInterface)) {
                    this.registerProperties(mappingsNamespace, propertyReferences, anInterface.getName());
                }
                this.loadInheritedPropertyReferences(mapping);
                this.registerProperties(mappingsNamespace, mapping.getPropertyReferences(), metafacadeInterface);
            }
        }
    }

    private String getMetaclassPattern() {
        if (this.metaclassPattern == null && this.getParent() != null) {
            this.metaclassPattern = this.getParent().metaclassPattern;
        }
        return this.metaclassPattern;
    }

    public void setMetaclassPattern(String metaclassPattern) {
        this.metaclassPattern = metaclassPattern;
    }

    private void initializeMappings(String[] metafacadeModelNamespaces) {
        ExceptionUtils.checkNull("modelTypes", metafacadeModelNamespaces);
        Collection metafacades = ComponentContainer.instance().findComponentsOfType(MetafacadeMappings.class);
        for (MetafacadeMappings mappings : metafacades) {
            for (MetafacadeMapping mapping : mappings.mappings) {
                if (!mapping.isMappingClassNamePresent()) continue;
                Set<String> mappingClassNames = allMetafacadeMappingInstances.get(mapping.getMetafacadeClass());
                if (mappingClassNames == null) {
                    mappingClassNames = new HashSet<String>();
                    allMetafacadeMappingInstances.put(mapping.getMetafacadeClass(), mappingClassNames);
                }
                mappingClassNames.addAll(mapping.getMappingClassNames());
            }
        }
        ArrayList<String> modelNamespaces = new ArrayList<String>(Arrays.asList(metafacadeModelNamespaces));
        try {
            Namespaces namespaces = Namespaces.instance();
            for (String modelNamespace : metafacadeModelNamespaces) {
                if (modelNamespace == null) continue;
                modelNamespaces.remove(modelNamespace);
                MetafacadeMappings modelMetafacadeMappings = this.modelMetafacadeMappings.get(modelNamespace);
                if (modelMetafacadeMappings == null) {
                    modelMetafacadeMappings = MetafacadeMappings.newInstance();
                    modelMetafacadeMappings.setNamespace(modelNamespace);
                    this.modelMetafacadeMappings.put(modelNamespace, modelMetafacadeMappings);
                }
                for (MetafacadeMappings mappings : metafacades) {
                    String namespace = mappings.getNamespace();
                    if (modelNamespaces.contains(namespace)) continue;
                    if (namespaces.isShared(namespace) || metafacades.size() == 1) {
                        modelMetafacadeMappings.copyMappings(mappings);
                        String metaclassPattern = mappings.metaclassPattern;
                        if (!StringUtils.isNotBlank((String)metaclassPattern)) continue;
                        modelMetafacadeMappings.setMetaclassPattern(mappings.metaclassPattern);
                        continue;
                    }
                    modelMetafacadeMappings.addNamespaceMappings(namespace, mappings);
                }
                modelNamespaces.add(modelNamespace);
                if (StringUtils.isBlank((String)modelMetafacadeMappings.getNamespace())) {
                    throw new MetafacadeMappingsException("No shared metafacades found, please check your classpath, at least one set of metafacades must be marked as 'shared'");
                }
                if (!StringUtils.isBlank((String)modelMetafacadeMappings.metaclassPattern)) continue;
                throw new MetafacadeMappingsException("At least one set of metafacades marked as shared must have the 'metaclassPattern' attribute defined");
            }
        }
        catch (Throwable throwable) {
            throw new MetafacadeMappingsException(throwable);
        }
        this.getLogger().debug((Object)("initializeMappings  size=" + allMetafacadeMappingInstances.size()));
    }

    static Map<Class, Set<String>> getAllMetafacadeMappingInstances() {
        return allMetafacadeMappingInstances;
    }

    public MetafacadeMappings getModelMetafacadeMappings(String metafacadeModelNamespace) {
        MetafacadeMappings instance = this.modelMetafacadeMappings.get(metafacadeModelNamespace);
        if (instance == null) {
            throw new MetafacadeMappingsException("Namespace '" + metafacadeModelNamespace + "' is not a registered metafacade model namespace");
        }
        return instance;
    }

    final Class getDefaultMetafacadeClass(String namespace) {
        Class defaultMetafacadeClass = null;
        MetafacadeMappings mappings = this.getNamespaceMappings(namespace);
        if (mappings != null) {
            defaultMetafacadeClass = mappings.defaultMetafacadeClass;
        }
        if (defaultMetafacadeClass == null) {
            defaultMetafacadeClass = this.defaultMetafacadeClass;
        }
        return defaultMetafacadeClass;
    }

    public void setDefaultMetafacadeClass(String defaultMetafacadeClass) {
        try {
            this.defaultMetafacadeClass = ClassUtils.loadClass(StringUtils.trimToEmpty((String)defaultMetafacadeClass));
        }
        catch (Throwable throwable) {
            throw new MetafacadeMappingsException(throwable);
        }
    }

    protected Collection<MetafacadeMapping> getMappings() {
        return this.mappings;
    }

    final void registerProperties(String namespace, Collection<String> propertyReferences, String metafacadeName) {
        MetafacadeFactory factory = MetafacadeFactory.getInstance();
        for (String reference : propertyReferences) {
            String value = Namespaces.instance().getPropertyValue(namespace, reference);
            if (value != null && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("setting context property '" + reference + "' with value '" + value + "' for namespace '" + namespace + "' on metafacade '" + metafacadeName + '\''));
            }
            factory.registerProperty(namespace, metafacadeName, reference, value);
        }
    }

    final void shutdown() {
        this.mappings.clear();
        this.inProcessMappings.clear();
        this.inProcessMetafacades.clear();
        this.namespaceMetafacadeMappings.clear();
        this.propertyReferences.clear();
        this.mappingObjectHierarchyCache.clear();
        this.mappingsByMetafacadeClass.clear();
        this.contextHierarchyCache.clear();
        this.reversedInterfaceArrayCache.clear();
        for (MetafacadeMappings metafacadeMappings : this.modelMetafacadeMappings.values()) {
            metafacadeMappings.shutdown();
        }
        this.modelMetafacadeMappings.clear();
    }

    private Logger getLogger() {
        return AndroMDALogger.getNamespaceLogger(this.getNamespace());
    }

    public String toString() {
        return super.toString() + '[' + this.getNamespace() + ']';
    }

    static interface Condition {
        public boolean evaluate(MetafacadeMapping var1);
    }
}

