/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeImplsException;
import org.andromda.core.namespace.NamespaceRegistry;
import org.apache.commons.lang.StringUtils;

public class MetafacadeImpls
implements Serializable {
    private static final long serialVersionUID = 34L;
    private static final MetafacadeImpls instance = new MetafacadeImpls();
    private final Map<String, MetafacadeClasses> metafacadeClasses = new LinkedHashMap<String, MetafacadeClasses>();
    private String metafacadeModelNamespace;
    private static final String METAFACADE_IMPLEMENTATION_SUFFIX = "Impl.class";

    public static MetafacadeImpls instance() {
        return instance;
    }

    public void setMetafacadeModelNamespace(String metafacadeModelNamespace) {
        this.metafacadeModelNamespace = metafacadeModelNamespace;
    }

    public void discover(String[] metafacadeModelNamespaces) {
        ExceptionUtils.checkNull("modelTypes", metafacadeModelNamespaces);
        ArrayList<String> modelNamespaces = new ArrayList<String>(Arrays.asList(metafacadeModelNamespaces));
        for (String modelNamespace : metafacadeModelNamespaces) {
            if (modelNamespace == null) continue;
            modelNamespaces.remove(modelNamespace);
            MetafacadeClasses metafacadeClasses = this.metafacadeClasses.get(modelNamespace);
            if (metafacadeClasses == null) {
                metafacadeClasses = new MetafacadeClasses();
                this.metafacadeClasses.put(modelNamespace, metafacadeClasses);
            }
            metafacadeClasses.clear();
            try {
                Namespaces namespacesConfiguration = Namespaces.instance();
                for (NamespaceRegistry namespaceRegistry : namespacesConfiguration.getNamespaceRegistries()) {
                    String namespaceRegistryName = namespaceRegistry.getName();
                    if (modelNamespaces.contains(namespaceRegistryName)) continue;
                    this.registerMetafacadeClasses(metafacadeClasses, namespacesConfiguration, namespaceRegistry);
                }
            }
            catch (Throwable throwable) {
                throw new MetafacadeImplsException(throwable);
            }
            modelNamespaces.add(modelNamespace);
        }
    }

    private void registerMetafacadeClasses(MetafacadeClasses metafacadeClasses, Namespaces namespaces, NamespaceRegistry namespaceRegistry) {
        URL[] namespaceRoots;
        String namespaceRegistryName = namespaceRegistry.getName();
        if (namespaces.isComponentPresent(namespaceRegistryName, "metafacades") && (namespaceRoots = namespaceRegistry.getResourceRoots()) != null && namespaceRoots.length > 0) {
            for (URL namespaceRoot : namespaceRoots) {
                List<String> contents = ResourceUtils.getDirectoryContents(namespaceRoot, false, null);
                for (String path : contents) {
                    List<Class> allInterfaces;
                    if (!path.endsWith(METAFACADE_IMPLEMENTATION_SUFFIX)) continue;
                    String typeName = StringUtils.replace((String)ResourceUtils.normalizePath(path).replace('/', '.'), (String)".class", (String)"");
                    Class implementationClass = null;
                    try {
                        implementationClass = ClassUtils.loadClass(typeName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (implementationClass == null || !MetafacadeBase.class.isAssignableFrom(implementationClass) || (allInterfaces = ClassUtils.getInterfaces(implementationClass)).isEmpty()) continue;
                    Class interfaceClass = allInterfaces.iterator().next();
                    String implementationClassName = implementationClass.getName();
                    String interfaceClassName = interfaceClass.getName();
                    metafacadeClasses.metafacadesByImpls.put(implementationClassName, interfaceClassName);
                    metafacadeClasses.implsByMetafacades.put(interfaceClassName, implementationClassName);
                }
            }
        }
    }

    private MetafacadeClasses getMetafacadeClasses() {
        MetafacadeClasses classes = this.metafacadeClasses.get(this.metafacadeModelNamespace);
        if (classes == null) {
            throw new MetafacadeImplsException("Namespace '" + this.metafacadeModelNamespace + "' is not a registered metafacade model facade namespace");
        }
        return classes;
    }

    public Class getMetafacadeClass(String metafacadeImplClass) {
        ExceptionUtils.checkEmpty("metafacadeImplClass", metafacadeImplClass);
        return this.getMetafacadeClasses().getMetafacadeClass(metafacadeImplClass);
    }

    public Class getMetafacadeImplClass(String metafacadeClass) {
        ExceptionUtils.checkEmpty("metafacadeClass", metafacadeClass);
        return this.getMetafacadeClasses().getMetafacadeImplClass(metafacadeClass);
    }

    static final class MetafacadeClasses {
        Map<String, String> implsByMetafacades = new LinkedHashMap<String, String>();
        Map<String, String> metafacadesByImpls = new LinkedHashMap<String, String>();

        MetafacadeClasses() {
        }

        Class getMetafacadeClass(String metafacadeImplClass) {
            ExceptionUtils.checkEmpty("metafacadeImplClass", metafacadeImplClass);
            Class metafacadeClass = null;
            try {
                String metafacadeClassName = this.metafacadesByImpls.get(metafacadeImplClass);
                if (StringUtils.isEmpty((String)metafacadeClassName)) {
                    throw new MetafacadeImplsException("Can not find a metafacade interface for --> '" + metafacadeImplClass + "', check your classpath");
                }
                metafacadeClass = ClassUtils.loadClass(metafacadeClassName);
            }
            catch (Throwable throwable) {
                throw new MetafacadeImplsException(throwable);
            }
            return metafacadeClass;
        }

        Class getMetafacadeImplClass(String metafacadeClass) {
            ExceptionUtils.checkEmpty("metafacadeClass", metafacadeClass);
            Class metafacadeImplementationClass = null;
            try {
                String metafacadeImplementationClassName = this.implsByMetafacades.get(metafacadeClass);
                if (StringUtils.isEmpty((String)metafacadeImplementationClassName)) {
                    throw new MetafacadeImplsException("Can not find a metafacade implementation class for --> '" + metafacadeClass + "' check your classpath");
                }
                metafacadeImplementationClass = ClassUtils.loadClass(metafacadeImplementationClassName);
            }
            catch (Throwable throwable) {
                throw new MetafacadeImplsException(throwable);
            }
            return metafacadeImplementationClass;
        }

        void clear() {
            this.metafacadesByImpls.clear();
            this.implsByMetafacades.clear();
        }

        public String toString() {
            return super.toString() + '[' + this.metafacadesByImpls + ']';
        }
    }
}

