/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.metafacade.MetafacadeBase;
import org.andromda.core.metafacade.MetafacadeCache;
import org.andromda.core.metafacade.MetafacadeFactoryException;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.andromda.core.metafacade.MetafacadeMapping;
import org.andromda.core.metafacade.MetafacadeMappings;
import org.andromda.core.metafacade.MetafacadeMappingsException;
import org.andromda.core.metafacade.MetafacadeUtils;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.metafacade.ModelValidationMessage;
import org.andromda.core.profile.Profile;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class MetafacadeFactory
implements Serializable {
    private static final long serialVersionUID = 34L;
    private final Map<String, Map<String, Map<String, Object>>> metafacadeNamespaces = new LinkedHashMap<String, Map<String, Map<String, Object>>>();
    private static MetafacadeFactory instance = null;
    private final MetafacadeCache cache = MetafacadeCache.newInstance();
    private final MetafacadeMappings mappings = MetafacadeMappings.newInstance();
    private final Profile profile = Profile.instance();
    private String namespace;
    private final Collection<MultiKey> metafacadesInCreation = new ArrayList<MultiKey>();
    private ModelAccessFacade model;
    private MetafacadeImpls metafacadeImpls = MetafacadeImpls.instance();
    private String metafacadeModelNamespace;
    private final Collection<ModelValidationMessage> validationMessages = new LinkedHashSet<ModelValidationMessage>();
    private final Map<String, Collection<MetafacadeBase>> allMetafacades = new LinkedHashMap<String, Collection<MetafacadeBase>>();
    private final Map<String, Map<String, Collection<MetafacadeBase>>> metafacadesByStereotype = new LinkedHashMap<String, Map<String, Collection<MetafacadeBase>>>();

    private MetafacadeFactory() {
    }

    public static MetafacadeFactory getInstance() {
        if (instance == null) {
            instance = new MetafacadeFactory();
        }
        return instance;
    }

    public void initialize() {
        this.mappings.initialize();
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.profile.setNamespace(namespace);
        this.cache.setNamespace(this.namespace);
    }

    public String getNamespace() {
        if (this.namespace == null) {
            throw new MetafacadeFactoryException("This metafacade factory's namespace must be populated before metafacade construction can occur");
        }
        return this.namespace;
    }

    public MetafacadeBase createMetafacade(Object mappingObject, String context) {
        return this.createMetafacade(mappingObject, context, null);
    }

    private MetafacadeBase createMetafacade(Object mappingObject, String context, Class metafacadeClass) {
        String methodName = "MetafacadeFactory.createMetafacade";
        ExceptionUtils.checkNull("mappingObject", mappingObject);
        this.registerNamespaceProperties();
        if (mappingObject instanceof MetafacadeBase) {
            return (MetafacadeBase)mappingObject;
        }
        try {
            Collection<String> stereotypes = this.getModel().getStereotypeNames(mappingObject);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("mappingObject stereotypes --> '" + stereotypes + '\''));
            }
            MetafacadeMapping mapping = null;
            if (metafacadeClass == null) {
                MetafacadeMappings modelMetafacadeMappings = this.getModelMetafacadeMappings();
                mapping = modelMetafacadeMappings.getMetafacadeMapping(mappingObject, this.getNamespace(), context, stereotypes);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("mappingObject getModelMetafacadeMappings for " + mappingObject + " namespace " + this.getNamespace() + " context " + context));
                }
                if (mapping != null) {
                    metafacadeClass = mapping.getMetafacadeClass();
                } else {
                    metafacadeClass = modelMetafacadeMappings.getDefaultMetafacadeClass(this.getNamespace());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().warn((Object)("Meta object model class '" + mappingObject.getClass() + "' has no corresponding meta facade class, default is being used --> '" + metafacadeClass + '\''));
                    }
                }
            }
            if (metafacadeClass == null) {
                throw new MetafacadeMappingsException("MetafacadeFactory.createMetafacade metafacadeClass was not retrieved from mappings or specified as an argument in this method for mappingObject --> '" + mappingObject + '\'');
            }
            MetafacadeBase metafacade = this.getMetafacade(metafacadeClass, mappingObject, context, mapping);
            if (metafacade != null && !metafacade.isInitialized()) {
                metafacade.setInitialized();
                metafacade.initialize();
            }
            return metafacade;
        }
        catch (Throwable throwable) {
            String message = "Failed to construct a meta facade of type '" + metafacadeClass + "' with mappingObject of type --> '" + mappingObject.getClass() + '\'';
            this.getLogger().error((Object)message);
            throw new MetafacadeFactoryException(message, throwable);
        }
    }

    private MetafacadeMappings getModelMetafacadeMappings() {
        return this.mappings.getModelMetafacadeMappings(this.metafacadeModelNamespace);
    }

    public void validateAllMetafacades() {
        for (MetafacadeBase metafacadeBase : this.getAllMetafacades()) {
            metafacadeBase.validate(this.validationMessages);
        }
    }

    protected MetafacadeBase createMetafacade(Object mappingObject, MetafacadeMapping mapping) {
        try {
            return this.getMetafacade(mapping.getMetafacadeClass(), mappingObject, mapping.getContext(), mapping);
        }
        catch (Throwable throwable) {
            String message = "Failed to construct a meta facade of type '" + mapping.getMetafacadeClass() + "' with mappingObject of type --> '" + mapping.getMappingClassNames() + '\'';
            this.getLogger().error((Object)message);
            throw new MetafacadeFactoryException(message, throwable);
        }
    }

    private MetafacadeBase getMetafacade(Class metafacadeClass, Object mappingObject, String context, MetafacadeMapping mapping) throws Exception {
        MultiKey key;
        MetafacadeBase metafacade = this.cache.get(mappingObject, metafacadeClass);
        if (metafacade == null && !this.metafacadesInCreation.contains(key = new MultiKey(mappingObject, (Object)metafacadeClass))) {
            this.metafacadesInCreation.add(key);
            if (mapping != null && mapping.isContextRoot()) {
                metafacade = MetafacadeUtils.constructMetafacade(metafacadeClass, mappingObject, null);
                metafacade.setContextRoot(mapping.isContextRoot());
            } else {
                metafacade = MetafacadeUtils.constructMetafacade(metafacadeClass, mappingObject, context);
            }
            this.metafacadesInCreation.remove(key);
            this.cache.add(mappingObject, metafacade);
        }
        if (metafacade != null) {
            String metafacadeNamespace;
            if (mapping != null && !mapping.getMetafacadeClass().equals(metafacadeClass)) {
                metafacade.setContextRoot(false);
                metafacade.resetMetafacadeContext(context);
            }
            if ((metafacadeNamespace = metafacade.getMetafacadeNamespace()) == null || !metafacadeNamespace.equals(this.getNamespace())) {
                metafacade.setNamespace(this.getNamespace());
                metafacade.setLogger(this.getLogger());
            }
        }
        return metafacade;
    }

    public MetafacadeBase createMetafacade(Object mappingObject) {
        return this.createMetafacade(mappingObject, null, null);
    }

    public MetafacadeBase createFacadeImpl(String interfaceName, Object mappingObject, String context) {
        ExceptionUtils.checkEmpty("interfaceName", interfaceName);
        ExceptionUtils.checkNull("mappingObject", mappingObject);
        Class metafacadeClass = null;
        try {
            metafacadeClass = this.metafacadeImpls.getMetafacadeImplClass(interfaceName);
            return this.createMetafacade(mappingObject, context, metafacadeClass);
        }
        catch (Throwable throwable) {
            String message = "Failed to construct a meta facade of type '" + metafacadeClass + "' with mappingObject of type --> '" + mappingObject.getClass().getName() + '\'';
            this.getLogger().error((Object)message);
            throw new MetafacadeFactoryException(message, throwable);
        }
    }

    protected Collection<MetafacadeBase> createMetafacades(Collection mappingObjects, String contextName) {
        ArrayList<MetafacadeBase> metafacades = new ArrayList<MetafacadeBase>();
        if (mappingObjects != null && !mappingObjects.isEmpty()) {
            for (Object mappingObject : mappingObjects) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("MetafacadeFactory createMetafacade for namespace " + this.getNamespace() + " model " + this.getModel() + " contextName " + contextName + " mappingObject " + mappingObject));
                }
                metafacades.add(this.createMetafacade(mappingObject, contextName, null));
            }
        }
        return metafacades;
    }

    public Collection<MetafacadeBase> createMetafacades(Collection mappingObjects) {
        return this.createMetafacades(mappingObjects, null);
    }

    public ModelAccessFacade getModel() {
        if (this.model == null) {
            throw new MetafacadeFactoryException("This metafacade factory's model must be populated before metafacade construction can occur");
        }
        return this.model;
    }

    public void setModel(ModelAccessFacade model, String metafacadeModelNamespace) {
        this.metafacadeModelNamespace = metafacadeModelNamespace;
        this.metafacadeImpls.setMetafacadeModelNamespace(metafacadeModelNamespace);
        this.model = model;
    }

    final Logger getLogger() {
        return AndroMDALogger.getNamespaceLogger(this.getNamespace());
    }

    final void registerProperty(String namespace, String metafacadeName, String name, Object value) {
        Map<String, Object> propertyNamespace;
        ExceptionUtils.checkEmpty("name", name);
        Map<String, Map<String, Object>> metafacadeNamespace = this.metafacadeNamespaces.get(namespace);
        if (metafacadeNamespace == null) {
            metafacadeNamespace = new LinkedHashMap<String, Map<String, Object>>();
            this.metafacadeNamespaces.put(namespace, metafacadeNamespace);
        }
        if ((propertyNamespace = metafacadeNamespace.get(metafacadeName)) == null) {
            propertyNamespace = new LinkedHashMap<String, Object>();
            metafacadeNamespace.put(metafacadeName, propertyNamespace);
        }
        propertyNamespace.put(name, value);
    }

    final void registerProperty(String metafacadeName, String name, Object value) {
        this.registerProperty(this.getNamespace(), metafacadeName, name, value);
    }

    private Map<String, Object> getMetafacadePropertyNamespace(MetafacadeBase metafacade) {
        Map<String, Map<String, Object>> namespace;
        Map<String, Object> metafacadeNamespace = null;
        if (metafacade != null && (namespace = this.metafacadeNamespaces.get(this.getNamespace())) != null) {
            metafacadeNamespace = namespace.get(metafacade.getMetafacadeName());
        }
        return metafacadeNamespace;
    }

    final boolean isPropertyRegistered(MetafacadeBase metafacade, String name) {
        Map<String, Object> propertyNamespace = this.getMetafacadePropertyNamespace(metafacade);
        return propertyNamespace != null && propertyNamespace.containsKey(name);
    }

    private Object findProperty(MetafacadeBase metafacade, String name) {
        Map<String, Object> propertyNamespace = this.getMetafacadePropertyNamespace(metafacade);
        return propertyNamespace != null ? propertyNamespace.get(name) : null;
    }

    final Object getRegisteredProperty(MetafacadeBase metafacade, String name) {
        String methodName = "MetafacadeFactory.getRegisteredProperty";
        Object registeredProperty = this.findProperty(metafacade, name);
        if (registeredProperty == null && !this.isPropertyRegistered(metafacade, name)) {
            throw new MetafacadeFactoryException("MetafacadeFactory.getRegisteredProperty - no property '" + name + "' registered under metafacade '" + metafacade.getMetafacadeName() + "' for namespace '" + this.getNamespace() + '\'');
        }
        return registeredProperty;
    }

    public List<ModelValidationMessage> getValidationMessages() {
        return new ArrayList<ModelValidationMessage>(this.validationMessages);
    }

    public Collection<MetafacadeBase> getAllMetafacades() {
        String namespace = this.getNamespace();
        Collection<MetafacadeBase> metafacades = null;
        if (this.getModel() != null) {
            metafacades = this.allMetafacades.get(namespace);
            if (metafacades == null) {
                metafacades = this.createMetafacades(this.getModel().getModelElements());
                this.allMetafacades.put(namespace, metafacades);
            }
            if (metafacades != null) {
                metafacades = new ArrayList<MetafacadeBase>(metafacades);
            }
        }
        return metafacades;
    }

    public Collection<MetafacadeBase> getMetafacadesByStereotype(String stereotype) {
        String namespace = this.getNamespace();
        Collection<MetafacadeBase> metafacades = null;
        if (this.getModel() != null) {
            Map<String, Collection<MetafacadeBase>> stereotypeMetafacades = this.metafacadesByStereotype.get(namespace);
            if (stereotypeMetafacades == null) {
                stereotypeMetafacades = new LinkedHashMap<String, Collection<MetafacadeBase>>();
            }
            if ((metafacades = stereotypeMetafacades.get(stereotype)) == null) {
                metafacades = this.createMetafacades(this.getModel().findByStereotype(stereotype));
                stereotypeMetafacades.put(stereotype, metafacades);
                this.metafacadesByStereotype.put(namespace, stereotypeMetafacades);
            }
            if (metafacades != null) {
                metafacades = new ArrayList<MetafacadeBase>(metafacades);
            }
        }
        return metafacades;
    }

    public void shutdown() {
        this.clearCaches();
        this.metafacadeNamespaces.clear();
        this.mappings.shutdown();
        this.model = null;
        instance = null;
        this.profile.shutdown();
    }

    private void registerNamespaceProperties() {
        MetafacadeMappings modelMappings;
        if (this.metafacadeNamespaces.isEmpty() && StringUtils.isNotBlank((String)this.metafacadeModelNamespace) && (modelMappings = this.getModelMetafacadeMappings()) != null) {
            modelMappings.registerAllProperties();
        }
    }

    public void reset() {
        this.profile.refresh();
        this.metafacadeNamespaces.clear();
        this.registerNamespaceProperties();
        this.clearCaches();
    }

    public void clearCaches() {
        this.validationMessages.clear();
        this.allMetafacades.clear();
        this.metafacadesByStereotype.clear();
        this.cache.clear();
        this.metafacadesInCreation.clear();
    }
}

