/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.metafacade;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.MetafacadeImpls;
import org.andromda.core.metafacade.ModelValidationMessage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MetafacadeBase
implements Serializable,
Comparable {
    private static final long serialVersionUID = 34L;
    private Object metaObject;
    private boolean initialized = false;
    private String context = null;
    private String metafacadeNamespace = null;
    protected Logger logger;
    protected boolean contextRoot = false;
    private String metafacadeName = null;
    private Boolean metafacadePropertyCachingEnabled = null;
    private MetafacadeBase THIS = null;

    public MetafacadeBase(Object metaObjectIn, String contextIn) {
        this.metaObject = metaObjectIn;
        this.context = contextIn;
    }

    public Object getValidationOwner() {
        return null;
    }

    public String getValidationName() {
        return null;
    }

    final void setInitialized() {
        this.initialized = true;
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    public final void validate(Collection<ModelValidationMessage> validationMessages) {
        this.validateInvariants(validationMessages);
    }

    public void validateInvariants(Collection<ModelValidationMessage> messages) {
    }

    public void initialize() {
    }

    protected MetafacadeBase shieldedElement(Object metaObjectIn) {
        MetafacadeBase metafacade = null;
        if (metaObjectIn != null) {
            String contextIn = this.getContext();
            metafacade = MetafacadeFactory.getInstance().createMetafacade(metaObjectIn, contextIn);
            if (metafacade != null) {
                metafacade.resetMetafacadeContext(contextIn);
            }
        }
        return metafacade;
    }

    protected List shieldedElements(Collection metaobjects) {
        ArrayList<MetafacadeBase> metafacades = new ArrayList<MetafacadeBase>();
        if (metaobjects != null) {
            for (Object metaobject : metaobjects) {
                metafacades.add(this.shieldedElement(metaobject));
            }
        }
        return metafacades;
    }

    final String getContext() {
        String contextIn = this.context;
        if (StringUtils.isBlank((String)contextIn)) {
            contextIn = this.getMetafacadeName();
        }
        return contextIn;
    }

    public void setMetafacadeContext(String contextIn) {
        this.context = contextIn;
    }

    public void resetMetafacadeContext(String contextIn) {
        throw new IllegalStateException("Method resetMetafacadeContext() must be overridden by concrete metafacade class (" + this.getClass().getName() + ")! Please re-generate your metafacades using the new andromda-meta cartridge.");
    }

    final String getMetafacadeNamespace() {
        return this.metafacadeNamespace;
    }

    final void setNamespace(String namespaceIn) {
        this.metafacadeNamespace = namespaceIn;
    }

    protected boolean isConfiguredProperty(String property) {
        return MetafacadeFactory.getInstance().isPropertyRegistered(this, property);
    }

    protected Object getConfiguredProperty(String property) {
        return MetafacadeFactory.getInstance().getRegisteredProperty(this, property);
    }

    protected void setProperty(String nameIn, Object value) {
        MetafacadeFactory.getInstance().registerProperty(this.getMetafacadeName(), nameIn, value);
    }

    public final Object getMetaObject() {
        return this.metaObject;
    }

    final void setLogger(Logger loggerIn) {
        this.logger = loggerIn;
    }

    final void setContextRoot(boolean contextRootIn) {
        this.contextRoot = contextRootIn;
    }

    public String getMetafacadeContext() {
        String metafacadeContext = this.getContext();
        if (this.contextRoot) {
            metafacadeContext = this.getMetafacadeName();
        }
        return metafacadeContext;
    }

    final String getMetafacadeName() {
        if (this.metafacadeName == null) {
            this.metafacadeName = MetafacadeImpls.instance().getMetafacadeClass(this.getClass().getName()).getName();
        }
        return this.metafacadeName;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof MetafacadeBase) {
            MetafacadeBase that = (MetafacadeBase)object;
            equals = this.metaObject.equals(that.metaObject);
        }
        return equals;
    }

    public int hashCode() {
        return this.metaObject.hashCode();
    }

    public final boolean isMetafacadePropertyCachingEnabled() {
        if (this.metafacadePropertyCachingEnabled == null) {
            String enableCache = (String)this.getConfiguredProperty("enableMetafacadePropertyCaching");
            this.metafacadePropertyCachingEnabled = Boolean.valueOf(enableCache);
        }
        return this.metafacadePropertyCachingEnabled;
    }

    protected final MetafacadeBase THIS() {
        return this.THIS == null ? (this.THIS = this.shieldedElement(this.metaObject)) : this.THIS;
    }

    public String toString() {
        return super.toString() + '[' + this.metafacadeName + ": " + this.metaObject.getClass().getName() + ']';
    }

    public int compareTo(Object object) {
        if (object == null || !(object instanceof MetafacadeBase)) {
            return -1;
        }
        MetafacadeBase metafacade = (MetafacadeBase)object;
        if (metafacade.getValidationName() == null) {
            return -1;
        }
        return metafacade.getValidationName().compareTo(this.getValidationName());
    }
}

