/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.mapping;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.mapping.Mappings;
import org.andromda.core.mapping.MappingsException;
import org.apache.commons.lang.StringUtils;

public class Mapping {
    private final Collection<String> froms = new LinkedHashSet<String>();
    private final List<String> paths = new ArrayList<String>();
    private String to;
    private Mappings mappings;

    public void addFrom(String from) {
        ExceptionUtils.checkNull("from", from);
        this.froms.add(from);
    }

    public Collection<String> getFroms() {
        return this.froms;
    }

    public String getTo() {
        StringBuilder to = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.to)) {
            to.append(this.to);
        }
        if (!this.paths.isEmpty()) {
            try {
                for (String path : this.paths) {
                    to.append(ResourceUtils.getContents(new FileReader(this.mappings.getCompletePath(path))));
                }
            }
            catch (FileNotFoundException exception) {
                throw new MappingsException(exception);
            }
        }
        return to.toString();
    }

    public void addPath(String path) {
        this.paths.add(path);
    }

    public void setTo(String to) {
        this.to = to;
    }

    final void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(512);
        Iterator<String> fromIterator = this.froms.iterator();
        while (fromIterator.hasNext()) {
            String from = fromIterator.next();
            buffer.append(from);
            if (!fromIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(" --> ").append(this.to);
        return buffer.toString();
    }
}

