/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.engine;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.andromda.core.ModelValidationException;
import org.andromda.core.cartridge.Cartridge;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.BuildInformation;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.ExceptionRecorder;
import org.andromda.core.common.Introspector;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.configuration.Filters;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Namespace;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.configuration.Repository;
import org.andromda.core.engine.ModelProcessorException;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.metafacade.ModelValidationMessage;
import org.andromda.core.namespace.NamespaceComponents;
import org.andromda.core.repository.Repositories;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ModelProcessor {
    private static final Logger logger = Logger.getLogger(ModelProcessor.class);
    private final MetafacadeFactory factory = MetafacadeFactory.getInstance();
    private final Namespaces namespaces = Namespaces.instance();
    private final Repositories repositories = Repositories.instance();
    private boolean lastModifiedCheck = true;
    private String historyDir = null;
    private Configuration currentConfiguration = null;
    private static final String VERSION = BuildInformation.instance().getBuildVersion();
    private static boolean modelValidation = true;
    private boolean failOnValidationErrors = true;
    private List cartridgeFilter = null;
    private boolean negateCartridgeFilter = false;
    private static final String CARTRIDGE_FILTER_NEGATOR = "~";

    public static ModelProcessor newInstance() {
        return new ModelProcessor();
    }

    private ModelProcessor() {
    }

    public ModelValidationMessage[] process(Configuration configuration) {
        this.configure(configuration);
        List<ModelValidationMessage> messages = this.process(configuration.getRepositories());
        return messages != null ? messages.toArray(new ModelValidationMessage[messages.size()]) : new ModelValidationMessage[]{};
    }

    private void configure(Configuration configuration) {
        if (this.requiresConfiguration(configuration)) {
            configuration.initialize();
            this.reset();
            Property[] properties = configuration.getProperties();
            Introspector introspector = Introspector.instance();
            for (Property property : properties) {
                try {
                    introspector.setProperty(this, property.getName(), property.getValue());
                }
                catch (Throwable throwable) {
                    AndroMDALogger.warn("Could not set model processor property '" + property.getName() + "' with a value of '" + property.getValue() + '\'');
                }
            }
            this.currentConfiguration = configuration;
        }
    }

    private List<ModelValidationMessage> process(Repository[] repositories) {
        List<ModelValidationMessage> messages = null;
        long startTime = System.currentTimeMillis();
        for (Repository repository : repositories) {
            if (repository == null) continue;
            String repositoryName = repository.getName();
            Model[] models = this.filterInvalidModels(repository.getModels());
            if (models.length > 0) {
                messages = this.processModels(repositoryName, models);
                AndroMDALogger.info("completed model processing --> TIME: " + this.getDurationInSeconds(startTime) + "[s], RESOURCES WRITTEN: " + ResourceWriter.instance().getWrittenCount());
                continue;
            }
            AndroMDALogger.warn("No model(s) found to process for repository '" + repositoryName + '\'');
        }
        if (messages == null) {
            messages = Collections.emptyList();
        }
        return messages;
    }

    public void setLastModifiedCheck(boolean lastModifiedCheck) {
        this.lastModifiedCheck = lastModifiedCheck;
    }

    public void setHistoryDir(String historyDir) {
        this.historyDir = historyDir;
    }

    private List<ModelValidationMessage> processModels(String repositoryName, Model[] models) {
        List<ModelValidationMessage> messages = null;
        String cartridgeName = null;
        try {
            long lastModified = 0L;
            ResourceWriter writer = ResourceWriter.instance();
            writer.setHistoryStorage(this.historyDir);
            for (Model model : models) {
                writer.resetHistory(model.getUris()[0]);
                boolean bl = this.lastModifiedCheck = model.isLastModifiedCheck() || this.lastModifiedCheck;
                if (model.getLastModified() <= lastModified) continue;
                lastModified = model.getLastModified();
            }
            if (!this.lastModifiedCheck || writer.isHistoryBefore(lastModified)) {
                Collection cartridges = ComponentContainer.instance().findComponentsOfType(Cartridge.class);
                if (cartridges.isEmpty()) {
                    AndroMDALogger.warn("WARNING! No cartridges found, check your classpath!");
                }
                Map<String, Cartridge> cartridgesByNamespace = this.loadCartridgesByNamespace(cartridges);
                Collection<Namespace> namespaces = this.namespaces.getNamespaces();
                messages = this.loadIfNecessary(models);
                for (Namespace namespace : namespaces) {
                    Cartridge cartridge = cartridgesByNamespace.get(namespace.getName());
                    if (cartridge == null || !this.shouldProcess(cartridgeName = cartridge.getNamespace())) continue;
                    this.factory.setNamespace(cartridgeName);
                    cartridge.initialize();
                    for (Model model : models) {
                        AndroMDALogger.info("Processing cartridge " + cartridge.getNamespace() + " on model " + model);
                        this.factory.setModel(this.repositories.getImplementation(repositoryName).getModel(), model.getType());
                        cartridge.processModelElements(this.factory);
                        writer.writeHistory();
                    }
                    cartridge.shutdown();
                }
            } else {
                AndroMDALogger.info("Files are up-to-date, skipping AndroMDA execution");
            }
        }
        catch (ModelValidationException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            String messsage = "Error performing ModelProcessor.process with model(s) --> '" + StringUtils.join((Object[])models, (String)",") + '\'';
            logger.error((Object)messsage);
            ExceptionRecorder.instance().record(messsage, throwable, cartridgeName);
            throw new ModelProcessorException(messsage, throwable);
        }
        if (messages == null) {
            messages = Collections.emptyList();
        }
        return messages;
    }

    private Map<String, Cartridge> loadCartridgesByNamespace(Collection<Cartridge> cartridges) {
        LinkedHashMap<String, Cartridge> cartridgesByNamespace = new LinkedHashMap<String, Cartridge>();
        for (Cartridge cartridge : cartridges) {
            cartridgesByNamespace.put(cartridge.getNamespace(), cartridge);
        }
        return cartridgesByNamespace;
    }

    public void initialize(Configuration configuration) {
        long startTime = System.currentTimeMillis();
        this.printConsoleHeader();
        this.configure(configuration);
        AndroMDALogger.initialize();
        NamespaceComponents.instance().discover();
        this.repositories.initialize();
        this.factory.initialize();
        this.printWorkCompleteMessage("core initialization", startTime);
    }

    protected final List<ModelValidationMessage> loadModelIfNecessary(Model model) {
        ArrayList<ModelValidationMessage> validationMessages = new ArrayList<ModelValidationMessage>();
        long startTime = System.currentTimeMillis();
        if (this.repositories.loadModel(model)) {
            this.printWorkCompleteMessage("loading", startTime);
            Repository repository = model.getRepository();
            String repositoryName = repository != null ? repository.getName() : null;
            validationMessages.addAll(this.validateModel(repositoryName, model));
        }
        return validationMessages;
    }

    private List<ModelValidationMessage> validateModel(String repositoryName, Model model) {
        Filters constraints = model != null ? model.getConstraints() : null;
        ArrayList<ModelValidationMessage> validationMessages = new ArrayList<ModelValidationMessage>();
        if (modelValidation && model != null) {
            long startTime = System.currentTimeMillis();
            AndroMDALogger.info("- validating model -");
            Collection cartridges = ComponentContainer.instance().findComponentsOfType(Cartridge.class);
            ModelAccessFacade modelAccessFacade = this.repositories.getImplementation(repositoryName).getModel();
            this.factory.clearCaches();
            this.factory.setModel(modelAccessFacade, model.getType());
            for (Cartridge cartridge : cartridges) {
                String cartridgeName = cartridge.getNamespace();
                if (!this.shouldProcess(cartridgeName)) continue;
                this.factory.setNamespace(cartridgeName);
                this.factory.validateAllMetafacades();
            }
            List<ModelValidationMessage> messages = this.factory.getValidationMessages();
            this.filterAndSortValidationMessages(messages, constraints);
            this.printValidationMessages(messages);
            this.printWorkCompleteMessage("validation", startTime);
            if (messages != null && !messages.isEmpty()) {
                validationMessages.addAll(messages);
            }
        }
        return validationMessages;
    }

    private void printWorkCompleteMessage(String unitOfWork, long startTime) {
        AndroMDALogger.info("- " + unitOfWork + " complete: " + this.getDurationInSeconds(startTime) + "[s] -");
    }

    private double getDurationInSeconds(long startTime) {
        return (double)(System.currentTimeMillis() - startTime) / 1000.0;
    }

    private void printValidationMessages(List<ModelValidationMessage> messages) {
        if (messages != null && !messages.isEmpty()) {
            StringBuilder header = new StringBuilder("Model Validation Failed - " + messages.size() + " VALIDATION ERROR");
            if (messages.size() > 1) {
                header.append('S');
            }
            AndroMDALogger.error(header);
            int ctr = 1;
            for (ModelValidationMessage message : messages) {
                AndroMDALogger.error(ctr + ") " + message);
                ++ctr;
            }
            AndroMDALogger.reset();
            if (this.failOnValidationErrors) {
                throw new ModelValidationException("Model validation failed!");
            }
        }
    }

    private boolean requiresConfiguration(Configuration configuration) {
        boolean requiresConfiguration;
        boolean bl = requiresConfiguration = this.currentConfiguration == null || this.currentConfiguration.getContents() == null || configuration.getContents() == null;
        if (!requiresConfiguration) {
            requiresConfiguration = !this.currentConfiguration.getContents().equals(configuration.getContents());
        }
        return requiresConfiguration;
    }

    final List<ModelValidationMessage> loadIfNecessary(Repository[] repositories) {
        ArrayList<ModelValidationMessage> messages = new ArrayList<ModelValidationMessage>();
        if (repositories != null) {
            for (Repository repository : repositories) {
                if (repository == null) continue;
                messages.addAll(this.loadIfNecessary(repository.getModels()));
            }
        }
        return messages;
    }

    private List<ModelValidationMessage> loadIfNecessary(Model[] models) {
        ArrayList<ModelValidationMessage> messages = new ArrayList<ModelValidationMessage>();
        if (models != null) {
            for (Model model : models) {
                messages.addAll(this.loadModelIfNecessary(model));
            }
        }
        return messages;
    }

    protected void printConsoleHeader() {
        AndroMDALogger.info("");
        AndroMDALogger.info("A n d r o M D A  -  " + VERSION);
        AndroMDALogger.info("");
    }

    public void setModelValidation(boolean modelValidationIn) {
        modelValidation = modelValidationIn;
    }

    public static boolean getModelValidation() {
        return modelValidation;
    }

    public void setFailOnValidationErrors(boolean failOnValidationErrors) {
        this.failOnValidationErrors = failOnValidationErrors;
    }

    protected boolean shouldProcess(String namespace) {
        boolean shouldProcess = this.namespaces.namespacePresent(namespace);
        if (shouldProcess) {
            boolean bl = shouldProcess = this.cartridgeFilter == null || this.cartridgeFilter.isEmpty();
            if (!shouldProcess) {
                shouldProcess = this.negateCartridgeFilter ^ this.cartridgeFilter.contains(StringUtils.trimToEmpty((String)namespace));
            }
        }
        return shouldProcess;
    }

    public void setCartridgeFilter(String namespaces) {
        if (namespaces != null) {
            if ((namespaces = StringUtils.deleteWhitespace((String)namespaces)).startsWith(CARTRIDGE_FILTER_NEGATOR)) {
                this.negateCartridgeFilter = true;
                namespaces = namespaces.substring(1);
            } else {
                this.negateCartridgeFilter = false;
            }
            if (StringUtils.isNotBlank((String)namespaces)) {
                this.cartridgeFilter = Arrays.asList(namespaces.split(","));
            }
        }
    }

    public void setOutputEncoding(String outputEncoding) {
        ResourceWriter.instance().setEncoding(outputEncoding);
    }

    public void setXmlValidation(boolean xmlValidation) {
        XmlObjectFactory.setDefaultValidating(xmlValidation);
    }

    public void setLoggingConfigurationUri(String loggingConfigurationUri) {
        AndroMDALogger.setLoggingConfigurationUri(loggingConfigurationUri);
    }

    private Model[] filterInvalidModels(Model[] models) {
        ArrayList<Model> validModels = new ArrayList<Model>(Arrays.asList(models));
        CollectionUtils.filter(validModels, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                Model model = (Model)o;
                return model != null && model.getUris() != null && model.getUris().length > 0;
            }
        });
        return validModels.toArray(new Model[validModels.size()]);
    }

    public void shutdown() {
        this.factory.shutdown();
        this.namespaces.clear();
        ComponentContainer.instance().shutdown();
        NamespaceComponents.instance().shutdown();
        Introspector.instance().shutdown();
        Configuration.clearCaches();
        this.repositories.clear();
    }

    private void reset() {
        this.factory.reset();
        this.cartridgeFilter = null;
        this.setXmlValidation(true);
        this.setOutputEncoding(null);
        this.setModelValidation(true);
        this.setFailOnValidationErrors(true);
    }

    protected void filterAndSortValidationMessages(List<ModelValidationMessage> messages, final Filters constraints) {
        if (constraints != null) {
            CollectionUtils.filter(messages, (Predicate)new Predicate(){

                public boolean evaluate(Object o) {
                    ModelValidationMessage message = (ModelValidationMessage)o;
                    return constraints.isApply(message.getName());
                }
            });
        }
        if (messages != null && !messages.isEmpty()) {
            ComparatorChain chain = new ComparatorChain();
            chain.addComparator((Comparator)new ValidationMessageTypeComparator());
            chain.addComparator((Comparator)new ValidationMessageNameComparator());
            Collections.sort(messages, chain);
        }
    }

    private static final class ValidationMessageNameComparator
    implements Comparator<ModelValidationMessage> {
        private final Collator collator = Collator.getInstance();

        ValidationMessageNameComparator() {
            this.collator.setStrength(0);
        }

        @Override
        public int compare(ModelValidationMessage objectA, ModelValidationMessage objectB) {
            return this.collator.compare(StringUtils.trimToEmpty((String)objectA.getMetafacadeName()), StringUtils.trimToEmpty((String)objectB.getMetafacadeName()));
        }
    }

    private static final class ValidationMessageTypeComparator
    implements Comparator<ModelValidationMessage> {
        private final Collator collator = Collator.getInstance();

        ValidationMessageTypeComparator() {
            this.collator.setStrength(0);
        }

        @Override
        public int compare(ModelValidationMessage objectA, ModelValidationMessage objectB) {
            return this.collator.compare(objectA.getMetafacadeClass().getName(), objectB.getMetafacadeClass().getName());
        }
    }
}

