/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.engine;

import java.util.List;
import org.andromda.core.configuration.Configuration;
import org.andromda.core.engine.ModelProcessor;
import org.andromda.core.metafacade.ModelValidationMessage;

public final class Engine {
    private ModelProcessor modelProcessor = ModelProcessor.newInstance();

    public static Engine newInstance() {
        return new Engine();
    }

    private Engine() {
    }

    public void initialize(Configuration configuration) {
        this.modelProcessor.initialize(configuration);
    }

    public ModelValidationMessage[] loadModelsIfNecessary(Configuration configuration) {
        ModelValidationMessage[] messages = null;
        if (configuration != null) {
            List<ModelValidationMessage> messagesList = this.modelProcessor.loadIfNecessary(configuration.getRepositories());
            messages = messagesList.toArray(new ModelValidationMessage[messagesList.size()]);
        }
        return messages == null ? new ModelValidationMessage[]{} : messages;
    }

    public ModelValidationMessage[] run(Configuration configuration, boolean lastModifiedCheck, String historyDir) {
        ModelValidationMessage[] messages = null;
        if (configuration != null) {
            this.modelProcessor.setHistoryDir(historyDir);
            this.modelProcessor.setLastModifiedCheck(lastModifiedCheck);
            messages = this.modelProcessor.process(configuration);
        }
        return messages == null ? new ModelValidationMessage[]{} : messages;
    }

    public void shutdown() {
        this.modelProcessor.shutdown();
    }
}

