/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.configuration.Namespace;
import org.andromda.core.configuration.NamespacesException;
import org.andromda.core.configuration.Property;
import org.andromda.core.namespace.NamespaceRegistry;
import org.andromda.core.namespace.PropertyDefinition;
import org.apache.log4j.Logger;

public class Namespaces
implements Serializable {
    private static final long serialVersionUID = 34L;
    private static final Logger logger = Logger.getLogger(Namespaces.class);
    public static final String DEFAULT = "default";
    private final Map<String, Namespace> namespaces = new LinkedHashMap<String, Namespace>();
    private static Namespaces instance = null;
    private final Map<String, NamespaceRegistry> registries = new LinkedHashMap<String, NamespaceRegistry>();

    public static Namespaces instance() {
        if (instance == null) {
            instance = new Namespaces();
        }
        return instance;
    }

    public Collection<Namespace> getNamespaces() {
        return this.namespaces.values();
    }

    public void addNamespace(Namespace namespace) {
        this.namespaces.put(namespace.getName(), namespace);
    }

    public void addNamespaces(Namespace[] namespaces) {
        if (namespaces != null && namespaces.length > 0) {
            int namespaceNumber = namespaces.length;
            for (int ctr = 0; ctr < namespaceNumber; ++ctr) {
                this.addNamespace(namespaces[ctr]);
            }
        }
    }

    public Namespace getNamespace(String namespaceName) {
        return this.namespaces.get(namespaceName);
    }

    public boolean namespacePresent(String namespaceName) {
        return this.getNamespace(namespaceName) != null;
    }

    public Property getProperty(String namespaceName, String propertyName) {
        Collection<Property> properties = this.getProperties(namespaceName, propertyName);
        return properties == null || properties.isEmpty() ? null : properties.iterator().next();
    }

    public Collection<Property> getProperties(String namespaceName, String propertyName) {
        return this.getProperties(namespaceName, propertyName, true);
    }

    public Property getProperty(String namespaceName, String propertyName, boolean showWarning) {
        Collection<Property> properties = this.getProperties(namespaceName, propertyName, showWarning);
        return properties == null || properties.isEmpty() ? null : properties.iterator().next();
    }

    public Collection<Property> getProperties(String namespaceName, String propertyName, boolean showWarning) {
        ExceptionUtils.checkEmpty("namespaceName", namespaceName);
        ExceptionUtils.checkEmpty("propertyName", propertyName);
        Collection<Property> property = null;
        Namespace namespace = this.namespaces.get(namespaceName);
        if (namespace != null) {
            property = namespace.getProperties(propertyName);
        }
        Namespace defaultNamespace = null;
        if (property == null && (defaultNamespace = this.namespaces.get(DEFAULT)) != null) {
            property = defaultNamespace.getProperties(propertyName);
        }
        if (namespace == null && defaultNamespace == null && showWarning) {
            logger.warn((Object)("WARNING! No 'default' or '" + namespaceName + "' namespace found, " + "--> please define a namespace with at least one of these names, if you would like " + "to ignore this message, define the namespace with " + "ignore set to 'true'"));
        } else if (property == null && showWarning) {
            logger.warn((Object)("WARNING! Namespaces 'default' and '" + namespaceName + "' have no property '" + propertyName + "' defined --> please define this property in AT LEAST ONE of these two namespaces. " + " If you want to 'ignore' this message, add the property to the namespace with ignore set to 'true'"));
        }
        return property;
    }

    public PropertyDefinition[] getPropertyDefinitions(String namespaceName) {
        NamespaceRegistry registry = this.getRegistry(namespaceName);
        return registry == null ? new PropertyDefinition[]{} : registry.getPropertyDefinitions();
    }

    public Collection<NamespaceRegistry> getNamespaceRegistries() {
        return this.registries.values();
    }

    public void addRegistry(NamespaceRegistry registry) {
        if (registry != null) {
            this.registries.put(registry.getName(), registry);
            if (registry.isShared()) {
                NamespaceRegistry defaultRegistry = this.getRegistry(DEFAULT);
                if (defaultRegistry == null) {
                    defaultRegistry = registry;
                } else {
                    defaultRegistry.addPropertyDefinitions(registry.getPropertyDefinitions());
                }
                this.registries.put(DEFAULT, defaultRegistry);
            }
        }
    }

    public boolean isShared(String namespace) {
        NamespaceRegistry registry = this.getRegistry(namespace);
        return registry != null && registry.isShared();
    }

    public String getPropertyValue(String namespace, String name) {
        PropertyDefinition definition = this.getPropertyDefinition(namespace, name);
        if (definition == null) {
            throw new NamespacesException("Property '" + name + "' is not registered in either the '" + namespace + "' or '" + DEFAULT + "' namespaces");
        }
        String defaultValue = definition.getDefaultValue();
        boolean warning = defaultValue == null && definition.isRequired();
        Property property = this.getProperty(namespace, name, warning);
        return property != null && !property.isIgnore() ? property.getValue() : defaultValue;
    }

    public URL[] getResourceRoots(String namespace) {
        NamespaceRegistry registry = this.getRegistry(namespace);
        if (registry == null) {
            throw new NamespacesException('\'' + namespace + "' is not a registered namespace");
        }
        URL[] resourceRoots = registry.getResourceRoots();
        if (resourceRoots == null || resourceRoots.length == 0) {
            throw new NamespacesException("No resource root(s) could be retrieved for namespace '" + namespace + '\'');
        }
        return resourceRoots;
    }

    public boolean isComponentPresent(String namespace, String component) {
        boolean present = false;
        NamespaceRegistry registry = this.getRegistry(namespace);
        if (namespace != null && component != null && registry != null) {
            String[] components = registry.getRegisteredComponents();
            int numberOfComponents = components.length;
            for (int ctr = 0; ctr < numberOfComponents; ++ctr) {
                if (!component.equals(components[ctr])) continue;
                present = true;
                break;
            }
        }
        return present;
    }

    private PropertyDefinition getPropertyDefinition(String namespace, String name) {
        NamespaceRegistry defaultRegistry;
        NamespaceRegistry registry = this.getRegistry(namespace);
        PropertyDefinition definition = null;
        if (registry != null) {
            definition = registry.getPropertyDefinition(name);
        }
        if (definition == null && (defaultRegistry = this.getRegistry(DEFAULT)) != null) {
            definition = defaultRegistry.getPropertyDefinition(name);
        }
        return definition;
    }

    public NamespaceRegistry getRegistry(String namespace) {
        return this.registries.get(namespace);
    }

    public void clear() {
        this.namespaces.clear();
    }
}

