/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.ConfigurationException;
import org.andromda.core.configuration.Filters;
import org.andromda.core.configuration.Location;
import org.andromda.core.configuration.Repository;
import org.andromda.core.configuration.Transformation;
import org.apache.commons.lang.StringUtils;

public class Model
implements Serializable {
    private static final long serialVersionUID = 34L;
    private boolean lastModifiedCheck = false;
    private Filters packages = new Filters();
    private Filters constraints = new Filters();
    private List<URL> uris = new ArrayList<URL>();
    private String[] urisAsStrings = null;
    private final Collection<Transformation> transformations = new ArrayList<Transformation>();
    private final Collection<Location> moduleSearchLocations = new ArrayList<Location>();
    private String type;
    private String[] moduleSearchLocationPaths = null;
    private URL[] moduleSearchLocationResources = null;
    private static final Map<String, Map<String, Long>> modelModifiedTimes = new HashMap<String, Map<String, Long>>();
    private String key = null;
    private Repository repository;

    public boolean isLastModifiedCheck() {
        return this.lastModifiedCheck;
    }

    public void setLastModifiedCheck(boolean lastModifiedCheck) {
        this.lastModifiedCheck = lastModifiedCheck;
    }

    public void setProcessAllPackages(boolean processAllPackages) {
        this.packages.setApplyAll(processAllPackages);
    }

    public Filters getPackages() {
        return this.packages;
    }

    public void setPackages(Filters packages) {
        this.packages = packages;
    }

    public void setEnforceAllConstraints(boolean enforceAllConstraints) {
        this.constraints.setApplyAll(enforceAllConstraints);
    }

    public Filters getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Filters constraints) {
        this.constraints = constraints;
    }

    public String[] getUris() {
        if (this.urisAsStrings == null) {
            int uriNumber = this.uris.size();
            this.urisAsStrings = new String[uriNumber];
            for (int ctr = 0; ctr < uriNumber; ++ctr) {
                this.urisAsStrings[ctr] = this.uris.get(ctr).toString();
            }
        }
        return this.urisAsStrings;
    }

    public void addUri(String uri) {
        try {
            URL url = ResourceUtils.toURL(uri);
            if (url == null) {
                throw new ConfigurationException("Model could not be loaded from invalid path --> '" + uri + '\'');
            }
            try {
                url.openConnection().setDefaultUseCaches(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.uris.add(url);
        }
        catch (Throwable throwable) {
            throw new ConfigurationException(throwable);
        }
    }

    public void addTransformation(Transformation transformation) {
        this.transformations.add(transformation);
    }

    public Transformation[] getTransformations() {
        return this.transformations.toArray(new Transformation[this.transformations.size()]);
    }

    public void addModuleSearchLocation(Location location) {
        this.moduleSearchLocations.add(location);
    }

    public void addModuleSearchLocation(String path) {
        if (path != null) {
            Location location = new Location();
            location.setPath(path);
            this.moduleSearchLocations.add(location);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Location[] getModuleSearchLocations() {
        return this.moduleSearchLocations.toArray(new Location[this.moduleSearchLocations.size()]);
    }

    public String[] getModuleSearchLocationPaths() {
        if (this.moduleSearchLocationPaths == null) {
            ArrayList<String> paths = new ArrayList<String>();
            for (Location location : this.moduleSearchLocations) {
                URL[] resources = location.getResources();
                int resourceNumber = resources.length;
                for (int ctr = 0; ctr < resourceNumber; ++ctr) {
                    paths.add(resources[ctr].toString());
                }
                paths.add(location.getPath());
            }
            this.moduleSearchLocationPaths = paths.toArray(new String[paths.size()]);
        }
        return this.moduleSearchLocationPaths;
    }

    public URL[] getModuleSearchLocationResources() {
        if (this.moduleSearchLocationResources == null) {
            Location[] locations;
            ArrayList<URL> allResources = new ArrayList<URL>();
            for (Location location : locations = this.getModuleSearchLocations()) {
                URL[] resources = location.getResources();
                allResources.addAll(Arrays.asList(resources));
            }
            this.moduleSearchLocationResources = allResources.toArray(new URL[allResources.size()]);
        }
        return this.moduleSearchLocationResources;
    }

    public long getLastModified() {
        long lastModifiedTime = 0L;
        for (URL url : this.uris) {
            long modifiedTime = ResourceUtils.getLastModifiedTime(url);
            if (modifiedTime <= lastModifiedTime) continue;
            lastModifiedTime = modifiedTime;
        }
        return lastModifiedTime;
    }

    public String toString() {
        String toString = super.toString();
        String key = this.getKey();
        if (StringUtils.isNotBlank((String)key)) {
            toString = key;
        }
        return toString;
    }

    private String getKey() {
        if (StringUtils.isBlank((String)this.key)) {
            StringBuilder buffer = new StringBuilder();
            Iterator<URL> iterator = this.uris.iterator();
            while (iterator.hasNext()) {
                URL uri = iterator.next();
                buffer.append(uri.getFile());
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            this.key = buffer.toString();
        }
        return this.key;
    }

    public Repository getRepository() {
        return this.repository;
    }

    void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isChanged() {
        boolean changed;
        boolean bl = changed = this.getUris().length > 0;
        if (changed) {
            String modelKey = this.getKey();
            Map<String, Long> lastModifiedTimes = modelModifiedTimes.get(modelKey);
            if (lastModifiedTimes != null) {
                long modelLastModified = lastModifiedTimes.get(modelKey);
                boolean bl2 = changed = this.getLastModified() > modelLastModified;
                if (!changed) {
                    URL[] resources;
                    for (URL resource : resources = this.getModuleSearchLocationResources()) {
                        Long lastModified = lastModifiedTimes.get(resource.getFile());
                        if (lastModified == null || ResourceUtils.getLastModifiedTime(resource) <= lastModified) continue;
                        changed = true;
                        break;
                    }
                }
            }
            if (changed) {
                this.loadLastModifiedTimes();
            }
        }
        return changed;
    }

    private void loadLastModifiedTimes() {
        URL[] resources;
        String modelKey = this.getKey();
        Map<String, Long> lastModifiedTimes = modelModifiedTimes.get(modelKey);
        if (lastModifiedTimes == null) {
            lastModifiedTimes = new HashMap<String, Long>();
        } else {
            lastModifiedTimes.clear();
        }
        for (URL resource : resources = this.getModuleSearchLocationResources()) {
            lastModifiedTimes.put(resource.getFile(), ResourceUtils.getLastModifiedTime(resource));
        }
        lastModifiedTimes.put(modelKey, this.getLastModified());
        modelModifiedTimes.put(modelKey, lastModifiedTimes);
    }

    static void clearLastModifiedTimes() {
        modelModifiedTimes.clear();
    }
}

