/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.andromda.core.common.ResourceUtils;

public class Location
implements Serializable {
    private static final long serialVersionUID = 34L;
    private String path;
    private String patterns;
    private static final String PATTERN_DELIMITER = ",";

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    public URL[] getResources() {
        URL[] resources;
        URL url = ResourceUtils.toURL(this.path);
        if (url != null) {
            if (ResourceUtils.isFile(url)) {
                resources = new URL[]{url};
            } else {
                String[] patterns = this.patterns != null ? this.patterns.split(PATTERN_DELIMITER) : new String[]{};
                List<String> paths = ResourceUtils.getDirectoryContents(url, true, patterns);
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : paths) {
                    URL resource = ResourceUtils.toURL(path);
                    if (resource == null) continue;
                    urls.add(resource);
                }
                resources = urls.toArray(new URL[urls.size()]);
            }
        } else {
            resources = new URL[]{};
        }
        return resources;
    }
}

