/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import org.andromda.core.configuration.Filter;
import org.andromda.core.metafacade.MetafacadeFactory;
import org.apache.commons.lang.StringUtils;

public class Filters
implements Serializable {
    private static final long serialVersionUID = 34L;
    private boolean applyAll = true;
    private final Collection<Filter> filters = new ArrayList<Filter>();
    private final MetafacadeFactory factory = MetafacadeFactory.getInstance();
    private static final String DOUBLE_STAR = "**";

    public void setApplyAll(boolean applyAll) {
        this.applyAll = applyAll;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public void addFilters(Filters filters) {
        this.filters.addAll(filters.filters);
    }

    public Filter[] getFilters() {
        return this.filters.toArray(new Filter[this.filters.size()]);
    }

    public boolean isApply(String value) {
        boolean shouldApply = this.applyAll;
        for (Filter filter : this.filters) {
            if (!this.match(value, filter.getValue())) continue;
            shouldApply = filter.isApply() && (filter.getNamespaceList().isEmpty() || filter.getNamespaceList().contains(StringUtils.trim((String)this.factory.getNamespace())));
            break;
        }
        return shouldApply;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public boolean match(String value, String pattern) {
        value = StringUtils.trimToEmpty((String)value);
        boolean matches = false;
        if (value != null) {
            String scopeOperator = "::";
            pattern = StringUtils.replace((String)pattern, (String)".", (String)"\\.");
            boolean matchAll = pattern.contains(DOUBLE_STAR);
            pattern = pattern.replaceAll("\\*{1}", "\\.\\*");
            if (matchAll) {
                pattern = StringUtils.replace((String)pattern, (String)DOUBLE_STAR, (String)".*");
            }
            try {
                matches = value.matches(pattern);
            }
            catch (PatternSyntaxException exception) {
                matches = false;
            }
            if (!matchAll) {
                matches = matches && StringUtils.countMatches((String)pattern, (String)"::") == StringUtils.countMatches((String)value, (String)"::");
            }
        }
        return matches;
    }
}

