/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Location;
import org.andromda.core.configuration.Model;
import org.andromda.core.configuration.Namespace;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.configuration.Property;
import org.andromda.core.configuration.Repository;
import org.andromda.core.configuration.Server;
import org.andromda.core.mapping.Mappings;
import org.apache.commons.lang.StringUtils;

public class Configuration
implements Serializable {
    private static final long serialVersionUID = 34L;
    private final Collection<Repository> repositories = new ArrayList<Repository>();
    private final Collection<Namespace> namespaces = new ArrayList<Namespace>();
    private final Collection<Property> properties = new ArrayList<Property>();
    private Server server;
    private final Collection<Location> mappingsSearchLocations = new ArrayList<Location>();
    private String contents = null;

    public static Configuration getInstance(URL uri) {
        Configuration configuration = (Configuration)XmlObjectFactory.getInstance(Configuration.class).getObject(uri);
        configuration.setContents(ResourceUtils.getContents(uri));
        return configuration;
    }

    public static Configuration getInstance(InputStream stream) {
        Configuration configuration = (Configuration)XmlObjectFactory.getInstance(Configuration.class).getObject(new InputStreamReader(stream));
        configuration.setContents(ResourceUtils.getContents(new InputStreamReader(stream)));
        return configuration;
    }

    public static Configuration getInstance(String string) {
        Configuration configuration = (Configuration)XmlObjectFactory.getInstance(Configuration.class).getObject(string);
        configuration.setContents(string);
        return configuration;
    }

    public void initialize() {
        this.initializeNamespaces();
        this.initializeMappings();
    }

    public void addRepository(Repository repository) {
        this.repositories.add(repository);
    }

    public Repository[] getRepositories() {
        return this.repositories.toArray(new Repository[this.repositories.size()]);
    }

    public void addNamespace(Namespace namespace) {
        this.namespaces.add(namespace);
    }

    public Namespace[] getNamespaces() {
        return this.namespaces.toArray(new Namespace[this.namespaces.size()]);
    }

    public void addProperty(Property property) {
        this.properties.add(property);
    }

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public void addMappingsSearchLocation(Location location) {
        if (location != null) {
            this.mappingsSearchLocations.add(location);
        }
    }

    public void addMappingsSearchLocation(String path) {
        if (path != null) {
            Location location = new Location();
            location.setPath(path);
            this.mappingsSearchLocations.add(location);
        }
    }

    public Location[] getMappingsSearchLocations() {
        return this.mappingsSearchLocations.toArray(new Location[this.mappingsSearchLocations.size()]);
    }

    public String getContents() {
        return this.contents;
    }

    public static void clearCaches() {
        Model.clearLastModifiedTimes();
    }

    private void setContents(String contents) {
        this.contents = StringUtils.trimToEmpty((String)contents);
    }

    private void initializeNamespaces() {
        Namespaces namespaces = Namespaces.instance();
        namespaces.clear();
        namespaces.addNamespaces(this.getNamespaces());
    }

    private void initializeMappings() {
        if (this.mappingsSearchLocations != null) {
            Location[] locations;
            ArrayList<URL> mappingsLocations = new ArrayList<URL>();
            for (Location location : locations = this.getMappingsSearchLocations()) {
                mappingsLocations.addAll(Arrays.asList(location.getResources()));
            }
            Mappings.clearLogicalMappings();
            for (URL mappingsUri : mappingsLocations) {
                try {
                    Mappings.addLogicalMappings(mappingsUri);
                }
                catch (Throwable throwable) {}
            }
            Mappings.initializeLogicalMappings();
        }
    }
}

