/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Merger;
import org.andromda.core.common.ResourceUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class ResourceWriter {
    private static final ResourceWriter instance = new ResourceWriter();
    private String encoding = null;
    private StringBuffer history = new StringBuffer();
    private String modelFile = null;
    private long writtenCount = 0L;
    private String historyDir = null;

    public static ResourceWriter instance() {
        return instance;
    }

    public void writeStringToFile(String string, File file, String namespace) throws IOException {
        ExceptionUtils.checkNull("file", file);
        this.writeStringToFile(string, file.toString(), namespace, true);
    }

    public void writeStringToFile(String string, String fileLocation) throws IOException {
        this.writeStringToFile(string, fileLocation, true);
    }

    public void writeStringToFile(String string, File file) throws IOException {
        this.writeStringToFile(string, file != null ? file.toString() : null, true);
    }

    private void writeStringToFile(String string, String fileLocation, boolean recordHistory) throws IOException {
        this.writeStringToFile(string, fileLocation, null, recordHistory);
    }

    public void writeStringToFile(String string, String fileLocation, String namespace) throws IOException {
        this.writeStringToFile(string, fileLocation, namespace, true);
    }

    private void writeStringToFile(String string, String fileLocation, String namespace, boolean recordHistory) throws IOException {
        if (string == null) {
            string = "";
        }
        ExceptionUtils.checkEmpty("fileLocation", fileLocation);
        ResourceUtils.makeDirectories(fileLocation);
        Merger merger = Merger.instance();
        if (merger.requiresMerge(namespace)) {
            string = Merger.instance().getMergedString(string, namespace);
        }
        File file = new File(fileLocation);
        FileUtils.writeStringToFile((File)file, (String)string, (String)this.encoding);
        if (recordHistory) {
            this.recordHistory(file);
        }
    }

    public void writeUrlToFile(URL url, String fileLocation) throws IOException {
        ResourceUtils.writeUrlToFile(url, fileLocation);
        this.recordHistory(new File(fileLocation));
    }

    public void setEncoding(String encoding) {
        this.encoding = StringUtils.trimToNull((String)encoding);
    }

    public void resetHistory(String modelUri) {
        String modelFile = modelUri.replace('\\', '/');
        int lastSlash = modelFile.lastIndexOf(47);
        if (lastSlash != -1) {
            modelFile = modelFile.substring(lastSlash + 1, modelFile.length());
        }
        this.modelFile = modelFile;
        this.history = new StringBuffer();
        this.writtenCount = 0L;
    }

    public long getWrittenCount() {
        return this.writtenCount;
    }

    public String getHistoryStorage() {
        return this.historyDir + '/' + this.modelFile;
    }

    public void setHistoryStorage(String historyDirIn) {
        this.historyDir = historyDirIn;
    }

    public void writeHistory() throws IOException {
        this.writeStringToFile(this.history.toString(), this.getHistoryStorage(), false);
    }

    private void recordHistory(File file) {
        if (this.history != null) {
            this.history.append(file).append(',');
        }
        ++this.writtenCount;
    }

    public boolean isHistoryBefore(long time) {
        boolean before = true;
        try {
            File historyFile = new File(this.getHistoryStorage());
            if (historyFile.exists() && historyFile.lastModified() >= time) {
                String history = ResourceUtils.getContents(new File(this.getHistoryStorage()).toURI().toURL());
                String[] fileNames = history.split(",");
                long lastModified = 0L;
                for (String fileName : fileNames) {
                    if (!StringUtils.isNotBlank((String)fileName)) continue;
                    File file = new File(fileName.trim());
                    if (!file.exists()) {
                        lastModified = 0L;
                        break;
                    }
                    if (file.lastModified() <= lastModified) continue;
                    lastModified = file.lastModified();
                }
                before = time > lastModified;
            }
        }
        catch (IOException ex) {
            before = true;
        }
        return before;
    }
}

