/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.PathMatcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ResourceUtils {
    private static final Logger logger = Logger.getLogger(ResourceUtils.class);
    private static final String ARCHIVE_PREFIX = "jar:";
    private static final String FILE_PREFIX = "file:";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String PATH_WHITESPACE_CHARACTER = "%20";
    private static final String URL_DECODE_ENCODING = "UTF-8";
    private static final String FORWARD_SLASH = "/";
    private static final String BACK_SLASH_NORMALIZATION_PATTERN = "\\\\+";
    private static final String FORWARD_SLASH_NORMALIZATION_PATTERN = "/+";

    public static URL getResource(String resourceName) {
        ExceptionUtils.checkEmpty("resourceName", resourceName);
        ClassLoader loader = ClassUtils.getClassLoader();
        URL resource = loader != null ? loader.getResource(resourceName) : null;
        return resource;
    }

    public static String getContents(URL resource) {
        String result = null;
        InputStream in = null;
        try {
            if (null != resource) {
                in = resource.openStream();
                result = IOUtils.toString((InputStream)in);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return result;
    }

    public static String getContents(Reader resource) {
        String result;
        try {
            result = IOUtils.toString((Reader)resource);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)resource);
        }
        return StringUtils.trimToEmpty((String)result);
    }

    public static List<String> getClassPathArchiveContents(URL resource) {
        ZipFile archive;
        ArrayList<String> contents = new ArrayList<String>();
        if (ResourceUtils.isArchive(resource) && (archive = ResourceUtils.getArchive(resource)) != null) {
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                contents.add(entry.getName());
            }
        }
        return contents;
    }

    public static List<String> getDirectoryContents(URL resource, int levels) {
        return ResourceUtils.getDirectoryContents(resource, levels, true);
    }

    public static String unescapeFilePath(String filePath) {
        if (StringUtils.isNotBlank((String)filePath)) {
            filePath = filePath.replaceAll(PATH_WHITESPACE_CHARACTER, " ");
        }
        return filePath;
    }

    public static List<String> getDirectoryContents(URL resource, int levels, boolean includeSubdirectories) {
        File fileResource;
        ArrayList<String> contents = new ArrayList<String>();
        if (resource != null && (fileResource = new File(ResourceUtils.unescapeFilePath(resource.getFile()))).isDirectory()) {
            File rootDirectory = fileResource;
            for (int ctr = 0; ctr < levels; ++ctr) {
                rootDirectory = rootDirectory.getParentFile();
            }
            File pluginDirectory = rootDirectory;
            ResourceUtils.loadFiles(pluginDirectory, contents, includeSubdirectories);
            ListIterator<String> iterator = contents.listIterator();
            while (iterator.hasNext()) {
                String filePath = (String)iterator.next();
                iterator.set(StringUtils.replace((String)filePath.replace('\\', '/'), (String)(pluginDirectory.getPath().replace('\\', '/') + '/'), (String)""));
            }
        }
        return contents;
    }

    private static void loadFiles(File directory, Collection<String> fileList, boolean includeSubdirectories) {
        Collection<File> lAllFiles = ResourceUtils.loadFiles(directory, includeSubdirectories);
        for (File file : lAllFiles) {
            fileList.add(file.getPath());
        }
    }

    private static Collection<File> loadFiles(File directory, boolean includeSubdirectories) {
        Collection<File> result = Collections.emptyList();
        if (null != directory && directory.exists()) {
            result = FileUtils.listFiles((File)(directory.isDirectory() ? directory : directory.getParentFile()), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)(includeSubdirectories ? TrueFileFilter.INSTANCE : null));
        }
        return result;
    }

    public static boolean isArchive(URL resource) {
        return resource != null && resource.toString().startsWith(ARCHIVE_PREFIX);
    }

    public static ZipFile getArchive(URL resource) {
        try {
            ZipFile archive = null;
            if (resource != null) {
                File zipFile;
                String resourceUrl = resource.toString();
                int entryPrefixIndex = (resourceUrl = resourceUrl.replaceFirst(ARCHIVE_PREFIX, "")).indexOf(33);
                if (entryPrefixIndex != -1) {
                    resourceUrl = resourceUrl.substring(0, entryPrefixIndex);
                }
                if ((zipFile = new File(resourceUrl = URLDecoder.decode(new URL(resourceUrl).getFile(), URL_DECODE_ENCODING))).exists()) {
                    archive = new ZipFile(resourceUrl);
                } else {
                    throw new FileNotFoundException("ResourceUtils.getArchive " + resourceUrl + " NOT FOUND.");
                }
            }
            return archive;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static String getContents(String resourceName) {
        return ResourceUtils.getContents(ResourceUtils.getResource(resourceName));
    }

    public static URL getClassResource(String className) {
        ExceptionUtils.checkEmpty("className", className);
        return ResourceUtils.getResource(ResourceUtils.getClassNameAsResource(className));
    }

    private static String getClassNameAsResource(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static URL getResource(String resourceName, String directory) {
        File file;
        ExceptionUtils.checkEmpty("resourceName", resourceName);
        if (directory != null && (file = new File(directory, resourceName)).exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ResourceUtils.getResource(resourceName);
    }

    public static void makeDirectories(String location) {
        File file = new File(location);
        ResourceUtils.makeDirectories(file);
    }

    public static void makeDirectories(File location) {
        File parent = location.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static long getLastModifiedTime(URL resource) {
        long lastModified;
        try {
            File file = new File(resource.getFile());
            if (file.exists()) {
                lastModified = file.lastModified();
            } else {
                URLConnection uriConnection = resource.openConnection();
                lastModified = uriConnection.getLastModified();
                IOUtils.closeQuietly((InputStream)uriConnection.getInputStream());
            }
        }
        catch (Exception exception) {
            lastModified = 0L;
        }
        return lastModified;
    }

    public static URL getResource(String resourceName, URL directory) {
        String directoryLocation = null;
        if (directory != null) {
            directoryLocation = directory.getFile();
        }
        return ResourceUtils.getResource(resourceName, directoryLocation);
    }

    public static URL toURL(String path) {
        URL url = null;
        if (path != null) {
            path = ResourceUtils.normalizePath(path);
            try {
                File file;
                url = path.startsWith(CLASSPATH_PREFIX) ? ResourceUtils.resolveClasspathResource(path) : ((file = new File(path)).exists() ? file.toURI().toURL() : new URL(path));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static URL resolveClasspathResource(String path) {
        URL urlResource = null;
        if (path.startsWith(CLASSPATH_PREFIX)) {
            int nestedPathOffset = (path = path.substring(CLASSPATH_PREFIX.length(), path.length())).indexOf("!/");
            String resourcePath = nestedPathOffset == -1 ? path : path.substring(0, nestedPathOffset);
            String nestingPath = nestedPathOffset == -1 ? "" : path.substring(nestedPathOffset);
            urlResource = Thread.currentThread().getContextClassLoader().getResource(resourcePath);
            if (urlResource == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resource could not be located on the classpath: " + resourcePath));
                }
            } else {
                try {
                    String resourceFileName;
                    int fileNameOffset = resourcePath.lastIndexOf(47);
                    String string = resourceFileName = fileNameOffset == -1 ? resourcePath : resourcePath.substring(fileNameOffset + 1);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Creating temporary copy on the file system of the classpath resource");
                    }
                    File fileSystemResource = File.createTempFile(resourceFileName, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Temporary file will be deleted on VM exit: " + fileSystemResource.getAbsolutePath()));
                    }
                    fileSystemResource.deleteOnExit();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Copying classpath resource contents into temporary file");
                    }
                    ResourceUtils.writeUrlToFile(urlResource, fileSystemResource.toString());
                    int nestingCount = StringUtils.countMatches((String)path, (String)"!/");
                    StringBuilder buffer = new StringBuilder();
                    for (int ctr = 0; ctr < nestingCount; ++ctr) {
                        buffer.append(ARCHIVE_PREFIX);
                    }
                    buffer.append(FILE_PREFIX).append(fileSystemResource.getAbsolutePath()).append(nestingPath);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Constructing URL to " + (nestingCount > 0 ? "nested" : "") + " resource in temporary file"));
                    }
                    urlResource = new URL(buffer.toString());
                }
                catch (IOException exception) {
                    logger.warn((Object)"Unable to resolve classpath resource", (Throwable)exception);
                    urlResource = null;
                }
            }
        }
        return urlResource;
    }

    public static void writeUrlToFile(URL url, String fileLocation) throws IOException {
        ExceptionUtils.checkNull("url", url);
        ExceptionUtils.checkEmpty("fileLocation", fileLocation);
        File lOutputFile = new File(fileLocation);
        ResourceUtils.makeDirectories(lOutputFile);
        FileUtils.copyURLToFile((URL)url, (File)lOutputFile);
    }

    public static boolean isFile(URL url) {
        return url != null && new File(url.getFile()).isFile();
    }

    public static List<String> getDirectoryContents(URL url, boolean absolute, String[] patterns) {
        List<String> contents = ResourceUtils.getDirectoryContents(url, 0, true);
        if (!contents.isEmpty()) {
            ListIterator<String> iterator = contents.listIterator();
            while (iterator.hasNext()) {
                String path = iterator.next();
                if (!ResourceUtils.matchesAtLeastOnePattern(path, patterns)) {
                    iterator.remove();
                    continue;
                }
                if (!absolute) continue;
                String string = path = url.toString().endsWith(FORWARD_SLASH) ? path : FORWARD_SLASH + path;
                URL resource = ResourceUtils.toURL(url + path);
                if (resource == null) continue;
                iterator.set(resource.toString());
            }
        } else {
            String urlAsString = url.toString();
            String delimiter = "!/";
            String archivePath = urlAsString.replaceAll("!/.*", "!/");
            contents = ResourceUtils.getClassPathArchiveContents(url);
            ListIterator<String> iterator = contents.listIterator();
            while (iterator.hasNext()) {
                String relativePath = iterator.next();
                String fullPath = archivePath + relativePath;
                if (!fullPath.startsWith(urlAsString) || fullPath.equals(urlAsString + FORWARD_SLASH)) {
                    iterator.remove();
                    continue;
                }
                if (!ResourceUtils.matchesAtLeastOnePattern(relativePath, patterns)) {
                    iterator.remove();
                    continue;
                }
                if (!absolute) continue;
                iterator.set(fullPath);
            }
        }
        return contents;
    }

    public static boolean matchesAtLeastOnePattern(String path, String[] patterns) {
        boolean matches;
        boolean bl = matches = patterns == null || patterns.length == 0;
        if (!matches && patterns != null && patterns.length > 0) {
            for (String pattern : patterns) {
                if (!PathMatcher.wildcardMatch(path, pattern)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public static boolean modifiedAfter(long time, File directory) {
        File file;
        Collection<File> files = ResourceUtils.loadFiles(directory, true);
        boolean changed = files.isEmpty();
        Iterator<File> i$ = files.iterator();
        while (i$.hasNext() && !(changed = (file = i$.next()).lastModified() < time)) {
        }
        return changed;
    }

    public static String normalizePath(String path) {
        return path != null ? path.replaceAll(BACK_SLASH_NORMALIZATION_PATTERN, FORWARD_SLASH).replaceAll(FORWARD_SLASH_NORMALIZATION_PATTERN, FORWARD_SLASH) : null;
    }

    public static String renameExtension(String path, String oldExtension, String newExtension) {
        ExceptionUtils.checkEmpty("path", path);
        ExceptionUtils.checkNull("oldExtension", oldExtension);
        ExceptionUtils.checkNull("newExtension", newExtension);
        String newPath = path;
        int oldExtensionIndex = path.lastIndexOf(oldExtension);
        if (oldExtensionIndex != -1) {
            newPath = path.substring(0, oldExtensionIndex) + newExtension;
        }
        return newPath;
    }
}

