/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceFinderException;

public class ResourceFinder {
    public static URL[] findResources(String resource) {
        ExceptionUtils.checkEmpty("resource", resource);
        try {
            ArrayList<URL> resources = new ArrayList<URL>();
            Enumeration<URL> enumeration = ClassUtils.getClassLoader().getResources(resource);
            while (enumeration.hasMoreElements()) {
                resources.add(enumeration.nextElement());
            }
            return resources.toArray(new URL[resources.size()]);
        }
        catch (Exception exception) {
            throw new ResourceFinderException(exception);
        }
    }
}

